CREATE TABLE CONFIG_INFO
(
    ID bigint NOT NULL AUTO_INCREMENT,
    DATA_ID character varying(255) NOT NULL,
    GROUP_ID character varying(128) ,
    "CONTENT" clob NOT NULL,
    MD5 character varying(32) ,
    GMT_CREATE timestamp without time zone DEFAULT (NOW())::timestamp(6) without time zone NOT NULL,
    GMT_MODIFIED timestamp without time zone DEFAULT (NOW())::timestamp(6) without time zone NOT NULL,
    SRC_USER clob ,
    SRC_IP character varying(50) ,
    APP_NAME character varying(128) ,
    TENANT_ID character varying(128) DEFAULT '' ,
    C_DESC character varying(256) ,
    C_USE character varying(64) ,
    EFFECT character varying(64) ,
    "TYPE" character varying(64) ,
    C_SCHEMA clob ,
    ENCRYPTED_DATA_KEY clob NOT NULL,
    CONSTRAINT CONFIG_INFO_PKEY PRIMARY KEY (ID),
    CONSTRAINT CONFIG_INFO_UK_CONFIGINFO_DATAGROUPTENANT_KEY UNIQUE (DATA_ID, GROUP_ID, TENANT_ID)
)
    BINLOG ON ;
--Indexes DDL
CREATE UNIQUE INDEX CONFIG_INFO_PKEY ON CONFIG_INFO USING BTREE(ID);
CREATE UNIQUE INDEX CONFIG_INFO_UK_CONFIGINFO_DATAGROUPTENANT_KEY ON CONFIG_INFO USING BTREE(DATA_ID, GROUP_ID, TENANT_ID);


CREATE TABLE CONFIG_INFO_AGGR
(
    ID bigint NOT NULL AUTO_INCREMENT,
    DATA_ID character varying(255) NOT NULL,
    GROUP_ID character varying(128) NOT NULL,
    DATUM_ID character varying(255) NOT NULL,
    "CONTENT" clob NOT NULL,
    GMT_MODIFIED timestamp without time zone NOT NULL,
    APP_NAME character varying(128) ,
    TENANT_ID character varying(128) DEFAULT '' ,
    CONSTRAINT CONFIG_INFO_AGGR_PKEY PRIMARY KEY (ID),
    CONSTRAINT CONFIG_INFO_AGGR_UK_CONFIGINFOAGGR_DATAGROUPTENANTDATUM_KEY UNIQUE (DATA_ID, GROUP_ID, TENANT_ID, DATUM_ID)
)
BINLOG ON ;
--Indexes DDL
CREATE UNIQUE INDEX CONFIG_INFO_AGGR_PKEY ON CONFIG_INFO_AGGR USING BTREE(ID);
CREATE UNIQUE INDEX CONFIG_INFO_AGGR_UK_CONFIGINFOAGGR_DATAGROUPTENANTDATUM_KEY ON CONFIG_INFO_AGGR USING BTREE(DATA_ID, GROUP_ID, DATUM_ID, TENANT_ID);


CREATE TABLE CONFIG_INFO_BETA
(
    ID bigint NOT NULL AUTO_INCREMENT,
    DATA_ID character varying(255) NOT NULL,
    GROUP_ID character varying(128) NOT NULL,
    APP_NAME character varying(128) ,
    "CONTENT" clob NOT NULL,
    BETA_IPS character varying(1024) ,
    MD5 character varying(32) ,
    GMT_CREATE timestamp without time zone DEFAULT (NOW())::timestamp(6) without time zone NOT NULL,
    GMT_MODIFIED timestamp without time zone DEFAULT (NOW())::timestamp(6) without time zone NOT NULL,
    SRC_USER clob ,
    SRC_IP character varying(50) ,
    TENANT_ID character varying(128) DEFAULT '' ,
    ENCRYPTED_DATA_KEY clob NOT NULL,
    CONSTRAINT CONFIG_INFO_BETA_PKEY PRIMARY KEY (ID),
    CONSTRAINT CONFIG_INFO_BETA_UK_CONFIGINFOBETA_DATAGROUPTENANT_KEY UNIQUE (DATA_ID, GROUP_ID, TENANT_ID)
)
    BINLOG ON ;
--Indexes DDL
CREATE UNIQUE INDEX CONFIG_INFO_BETA_PKEY ON CONFIG_INFO_BETA USING BTREE(ID);
CREATE UNIQUE INDEX CONFIG_INFO_BETA_UK_CONFIGINFOBETA_DATAGROUPTENANT_KEY ON CONFIG_INFO_BETA USING BTREE(DATA_ID, GROUP_ID, TENANT_ID);


CREATE TABLE CONFIG_INFO_TAG
(
    ID bigint NOT NULL AUTO_INCREMENT,
    DATA_ID character varying(255) NOT NULL,
    GROUP_ID character varying(128) NOT NULL,
    TENANT_ID character varying(128) DEFAULT '' ,
    TAG_ID character varying(128) NOT NULL,
    APP_NAME character varying(128) ,
    "CONTENT" clob NOT NULL,
    MD5 character varying(32) ,
    GMT_CREATE timestamp without time zone DEFAULT (NOW())::timestamp(6) without time zone NOT NULL,
    GMT_MODIFIED timestamp without time zone DEFAULT (NOW())::timestamp(6) without time zone NOT NULL,
    SRC_USER clob ,
    SRC_IP character varying(50) ,
    CONSTRAINT CONFIG_INFO_TAG_PKEY PRIMARY KEY (ID),
    CONSTRAINT CONFIG_INFO_TAG_UK_CONFIGINFOTAG_DATAGROUPTENANTTAG_KEY UNIQUE (DATA_ID, GROUP_ID, TENANT_ID, TAG_ID)
)
BINLOG ON ;
--Indexes DDL
CREATE UNIQUE INDEX CONFIG_INFO_TAG_PKEY ON CONFIG_INFO_TAG USING BTREE(ID);
CREATE UNIQUE INDEX CONFIG_INFO_TAG_UK_CONFIGINFOTAG_DATAGROUPTENANTTAG_KEY ON CONFIG_INFO_TAG USING BTREE(DATA_ID, GROUP_ID, TENANT_ID, TAG_ID);


CREATE TABLE CONFIG_TAGS_RELATION
(
    ID bigint NOT NULL,
    TAG_NAME character varying(128) NOT NULL,
    TAG_TYPE character varying(64) ,
    DATA_ID character varying(255) NOT NULL,
    GROUP_ID character varying(128) NOT NULL,
    TENANT_ID character varying(128) DEFAULT '' ,
    NID bigint NOT NULL AUTO_INCREMENT,
    CONSTRAINT CONFIG_TAGS_RELATION_PKEY PRIMARY KEY (NID),
    CONSTRAINT CONFIG_TAGS_RELATION_UK_CONFIGTAGRELATION_CONFIGIDTAG_KEY UNIQUE (ID, TAG_NAME, TAG_TYPE)
)
BINLOG ON ;
--Indexes DDL
CREATE INDEX CONFIG_TAGS_RELATION_IDX_TENANT_ID ON CONFIG_TAGS_RELATION USING BTREE(TENANT_ID);
CREATE UNIQUE INDEX CONFIG_TAGS_RELATION_PKEY ON CONFIG_TAGS_RELATION USING BTREE(NID);
CREATE UNIQUE INDEX CONFIG_TAGS_RELATION_UK_CONFIGTAGRELATION_CONFIGIDTAG_KEY ON CONFIG_TAGS_RELATION USING BTREE(ID, TAG_NAME, TAG_TYPE);


CREATE TABLE GROUP_CAPACITY
(
    ID bigint NOT NULL AUTO_INCREMENT,
    GROUP_ID character varying(128) DEFAULT '' NOT NULL,
    QUOTA bigint DEFAULT 0 NOT NULL,
    "USAGE" bigint DEFAULT 0 NOT NULL,
    MAX_SIZE bigint DEFAULT 0 NOT NULL,
    MAX_AGGR_COUNT bigint DEFAULT 0 NOT NULL,
    MAX_AGGR_SIZE bigint DEFAULT 0 NOT NULL,
    MAX_HISTORY_COUNT bigint DEFAULT 0 NOT NULL,
    GMT_CREATE timestamp without time zone DEFAULT (NOW())::timestamp(6) without time zone NOT NULL,
    GMT_MODIFIED timestamp without time zone DEFAULT (NOW())::timestamp(6) without time zone NOT NULL,
    CONSTRAINT GROUP_CAPACITY_PKEY PRIMARY KEY (ID),
    CONSTRAINT GROUP_CAPACITY_UK_GROUP_ID_KEY UNIQUE (GROUP_ID)
)
    BINLOG ON ;
--Indexes DDL
CREATE UNIQUE INDEX GROUP_CAPACITY_PKEY ON GROUP_CAPACITY USING BTREE(ID);
CREATE UNIQUE INDEX GROUP_CAPACITY_UK_GROUP_ID_KEY ON GROUP_CAPACITY USING BTREE(GROUP_ID);


CREATE TABLE HIS_CONFIG_INFO
(
    ID numeric(20,0) NOT NULL,
    NID bigint NOT NULL AUTO_INCREMENT,
    DATA_ID character varying(255) NOT NULL,
    GROUP_ID character varying(128) NOT NULL,
    APP_NAME character varying(128) ,
    "CONTENT" clob NOT NULL,
    MD5 character varying(32) ,
    GMT_CREATE timestamp without time zone DEFAULT (NOW())::timestamp(6) without time zone NOT NULL,
    GMT_MODIFIED timestamp without time zone DEFAULT (NOW())::timestamp(6) without time zone NOT NULL,
    SRC_USER clob ,
    SRC_IP character varying(50) ,
    OP_TYPE character(10) ,
    TENANT_ID character varying(128) DEFAULT '' ,
    ENCRYPTED_DATA_KEY clob NOT NULL,
    CONSTRAINT HIS_CONFIG_INFO_PKEY PRIMARY KEY (NID)
)
BINLOG ON ;
--Indexes DDL
CREATE INDEX HIS_CONFIG_INFO_IDX_DID ON HIS_CONFIG_INFO USING BTREE(DATA_ID);
CREATE INDEX HIS_CONFIG_INFO_IDX_GMT_CREATE ON HIS_CONFIG_INFO USING BTREE(GMT_CREATE);
CREATE INDEX HIS_CONFIG_INFO_IDX_GMT_MODIFIED ON HIS_CONFIG_INFO USING BTREE(GMT_MODIFIED);
CREATE UNIQUE INDEX HIS_CONFIG_INFO_PKEY ON HIS_CONFIG_INFO USING BTREE(NID);

CREATE TABLE PERMISSIONS
(
    "ROLE" character varying(50) NOT NULL,
    RESOURCE character varying(255) NOT NULL,
    "ACTION" character varying(8) NOT NULL,
    CONSTRAINT PERMISSIONS_UK_ROLE_PERMISSION_KEY UNIQUE ("ROLE", RESOURCE, "ACTION")
)
BINLOG ON ;
--Indexes DDL
CREATE UNIQUE INDEX PERMISSIONS_UK_ROLE_PERMISSION_KEY ON PERMISSIONS USING BTREE("ROLE", RESOURCE, "ACTION");

CREATE TABLE ROLES
(
    USERNAME character varying(50) NOT NULL,
    "ROLE" character varying(50) NOT NULL,
    CONSTRAINT ROLES_IDX_USER_ROLE_KEY UNIQUE (USERNAME, "ROLE")
)
BINLOG ON ;
--Indexes DDL
CREATE UNIQUE INDEX ROLES_IDX_USER_ROLE_KEY ON ROLES USING BTREE(USERNAME, "ROLE");

CREATE TABLE TENANT_CAPACITY
(
    ID bigint NOT NULL AUTO_INCREMENT,
    TENANT_ID character varying(128) DEFAULT '' NOT NULL,
    QUOTA bigint DEFAULT 0 NOT NULL,
    "USAGE" bigint DEFAULT 0 NOT NULL,
    MAX_SIZE bigint DEFAULT 0 NOT NULL,
    MAX_AGGR_COUNT bigint DEFAULT 0 NOT NULL,
    MAX_AGGR_SIZE bigint DEFAULT 0 NOT NULL,
    MAX_HISTORY_COUNT bigint DEFAULT 0 NOT NULL,
    GMT_CREATE timestamp without time zone DEFAULT (NOW())::timestamp(6) without time zone NOT NULL,
    GMT_MODIFIED timestamp without time zone DEFAULT (NOW())::timestamp(6) without time zone NOT NULL,
    CONSTRAINT TENANT_CAPACITY_PKEY PRIMARY KEY (ID),
    CONSTRAINT TENANT_CAPACITY_UK_TENANT_ID_KEY UNIQUE (TENANT_ID)
)
BINLOG ON ;
--Indexes DDL
CREATE UNIQUE INDEX TENANT_CAPACITY_PKEY ON TENANT_CAPACITY USING BTREE(ID);
CREATE UNIQUE INDEX TENANT_CAPACITY_UK_TENANT_ID_KEY ON TENANT_CAPACITY USING BTREE(TENANT_ID);

CREATE TABLE TENANT_INFO
(
    ID bigint NOT NULL AUTO_INCREMENT,
    KP character varying(128) NOT NULL,
    TENANT_ID character varying(128) DEFAULT '' ,
    TENANT_NAME character varying(128) DEFAULT '' ,
    TENANT_DESC character varying(256) ,
    CREATE_SOURCE character varying(32) ,
    GMT_CREATE bigint NOT NULL,
    GMT_MODIFIED bigint NOT NULL,
    CONSTRAINT TENANT_INFO_PKEY PRIMARY KEY (ID),
    CONSTRAINT TENANT_INFO_UK_TENANT_INFO_KPTENANTID_KEY UNIQUE (KP, TENANT_ID)
)
BINLOG ON ;
--Indexes DDL
CREATE INDEX TENANT_INFO_IDX_TENANT_ID ON TENANT_INFO USING BTREE(TENANT_ID);
CREATE UNIQUE INDEX TENANT_INFO_PKEY ON TENANT_INFO USING BTREE(ID);
CREATE UNIQUE INDEX TENANT_INFO_UK_TENANT_INFO_KPTENANTID_KEY ON TENANT_INFO USING BTREE(KP, TENANT_ID);

CREATE TABLE USERS
(
    USERNAME character varying(50) NOT NULL,
    "PASSWORD" character varying(500) NOT NULL,
    ENABLED smallint NOT NULL,
    CONSTRAINT USERS_PK PRIMARY KEY (USERNAME)
)
BINLOG ON ;
--Indexes DDL
CREATE UNIQUE INDEX USERS_PK ON USERS USING BTREE(USERNAME);

INSERT INTO USERS(USERNAME, PASSWORD, ENABLED) VALUES ( 'nacos', '$2a$10$EuWPZHzz32dJN7jexM34MOeYirDdFAZm2kuWj7VEOJhhZkDrxfvUu', 1);
INSERT INTO ROLES(USERNAME,ROLE) VALUES ( 'nacos', 'ROLE_ADMIN');