/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.xa;

import com.kingbase8.util.Base64;
import com.kingbase8.util.TraceLogger;
import java.util.Arrays;
import java.util.logging.Level;
import javax.transaction.xa.Xid;

class RecoveredXid
implements Xid {
    int formatId;
    byte[] glTransactionId;
    byte[] branchQualifier;

    RecoveredXid() {
    }

    @Override
    public int getFormatId() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.glTransactionId;
    }

    @Override
    public byte[] getBranchQualifier() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.branchQualifier;
    }

    public int hashCode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int prime = 31;
        int _result = 1;
        _result = 31 * _result + Arrays.hashCode(this.branchQualifier);
        _result = 31 * _result + this.formatId;
        _result = 31 * _result + Arrays.hashCode(this.glTransactionId);
        return _result;
    }

    public boolean equals(Object o) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (o == this) {
            return true;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!(o instanceof Xid)) {
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Xid oth = (Xid)o;
        if (oth.getFormatId() != this.formatId) {
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!Arrays.equals(this.glTransactionId, oth.getGlobalTransactionId())) {
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return Arrays.equals(this.branchQualifier, oth.getBranchQualifier());
    }

    public String toString() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return RecoveredXid._xidToString(this);
    }

    static String _xidToString(Xid _xid) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return _xid.getFormatId() + "_" + Base64._encodeBytes(_xid.getGlobalTransactionId(), 8) + "_" + Base64._encodeBytes(_xid.getBranchQualifier(), 8);
    }

    static Xid stringToXid(String s) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        RecoveredXid _xid = new RecoveredXid();
        int a = s.indexOf("_");
        int b = s.lastIndexOf("_");
        if (a == b) {
            return null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            _xid.formatId = Integer.parseInt(s.substring(0, a));
            _xid.glTransactionId = Base64.decode(s.substring(a + 1, b));
            _xid.branchQualifier = Base64.decode(s.substring(b + 1));
            if (_xid.glTransactionId == null || _xid.branchQualifier == null) {
                return null;
            }
        }
        catch (Exception ex) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        return _xid;
    }
}

