/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core.v3;

import com.kingbase8.core.ParameterList;
import com.kingbase8.core.v3.SimpleParameterList;
import com.kingbase8.core.v3.V3ParameterList;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.logging.Level;

class CompositeParameterList
implements V3ParameterList {
    private final int totalNum;
    private final SimpleParameterList[] subParamsT;
    private final int[] offsetsT;

    CompositeParameterList(SimpleParameterList[] subParamsT, int[] offsetsT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.offsetsT = offsetsT;
        this.subParamsT = subParamsT;
        this.totalNum = offsetsT[offsetsT.length - 1] + subParamsT[offsetsT.length - 1].getInParameterCount();
    }

    private int findSubParam(int indexT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (indexT < 1 || indexT > this.totalNum) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("The _column _index is out of range: {0}, number of _columns: {1}.", indexT, this.totalNum), KSQLState.INVALID_PARAMETER_VALUE);
        }
        for (int j = this.offsetsT.length - 1; j >= 0; --j) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.offsetsT[j] >= indexT) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return j;
        }
        throw new IllegalArgumentException("I am confused; can't find a sub_param for _index " + indexT);
    }

    @Override
    public void registerOutParameter(int _index, int oid, boolean outParmBeforeFunc) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    @Override
    public int getParameterCount() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.totalNum;
    }

    public int getDirection(int iDirection) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int v = 0;
        return v;
    }

    @Override
    public int getOutParameterCount() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int v = 0;
        return v;
    }

    @Override
    public int getInParameterCount() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.totalNum;
    }

    @Override
    public int[] getTypeOIDs() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int[] oidsT = new int[this.totalNum];
        for (int i = 0; i < this.offsetsT.length; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int[] subOids = this.subParamsT[i].getTypeOIDs();
            System.arraycopy(subOids, 0, oidsT, this.offsetsT[i], subOids.length);
        }
        return oidsT;
    }

    @Override
    public void setIntParameter(int _index, int _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int sub = this.findSubParam(_index);
        this.subParamsT[sub].setIntParameter(_index - this.offsetsT[sub], _value);
    }

    @Override
    public void setLiteralParameter(int _index, String _value, int oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int sub = this.findSubParam(_index);
        this.subParamsT[sub].setStringParameter(_index - this.offsetsT[sub], _value, oid);
    }

    @Override
    public void setStringParameter(int _index, String _value, int oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int sub = this.findSubParam(_index);
        this.subParamsT[sub].setStringParameter(_index - this.offsetsT[sub], _value, oid);
    }

    @Override
    public void setBinaryParameter(int _index, byte[] _value, int oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int sub = this.findSubParam(_index);
        this.subParamsT[sub].setBinaryParameter(_index - this.offsetsT[sub], _value, oid);
    }

    @Override
    public void setBytea(int _index, byte[] data, int _offset, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int sub = this.findSubParam(_index);
        this.subParamsT[sub].setBytea(_index - this.offsetsT[sub], data, _offset, length);
    }

    @Override
    public void setBytea(int _index, InputStream stream, int length) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int sub = this.findSubParam(_index);
        this.subParamsT[sub].setBytea(_index - this.offsetsT[sub], stream, length);
    }

    @Override
    public void setBytea(int _index, InputStream stream) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int sub = this.findSubParam(_index);
        this.subParamsT[sub].setBytea(_index - this.offsetsT[sub], stream);
    }

    @Override
    public void setText(int _index, InputStream stream) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int sub = this.findSubParam(_index);
        this.subParamsT[sub].setText(_index - this.offsetsT[sub], stream);
    }

    @Override
    public void setNull(int _index, int oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int sub = this.findSubParam(_index);
        this.subParamsT[sub].setNull(_index - this.offsetsT[sub], oid);
    }

    @Override
    public String toString(int _index, boolean standardConformingStrings) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            int sub = this.findSubParam(_index);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this.subParamsT[sub].toString(_index - this.offsetsT[sub], standardConformingStrings);
        }
        catch (SQLException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalStateException(e.getMessage());
        }
    }

    @Override
    public ParameterList copy() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SimpleParameterList[] copySub = new SimpleParameterList[this.subParamsT.length];
        for (int sub = 0; sub < this.subParamsT.length; ++sub) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            copySub[sub] = (SimpleParameterList)this.subParamsT[sub].copy();
        }
        return new CompositeParameterList(copySub, this.offsetsT);
    }

    @Override
    public void clear() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (SimpleParameterList sub_param : this.subParamsT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sub_param.clear();
        }
    }

    @Override
    public SimpleParameterList[] getSub_params() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.subParamsT;
    }

    @Override
    public void checkAllParametersSet() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (SimpleParameterList sub_param : this.subParamsT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sub_param.checkAllParametersSet();
        }
    }

    @Override
    public byte[][] getEncoding() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return null;
    }

    @Override
    public byte[] getFlags() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return null;
    }

    @Override
    public int[] getParamTypes() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return null;
    }

    @Override
    public Object[] getValues() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return null;
    }

    @Override
    public void appendAll(ParameterList list) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    @Override
    public void convertFunctionOutParameters() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (SimpleParameterList sub_param : this.subParamsT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sub_param.convertFunctionOutParameters();
        }
    }
}

