/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core.v3;

import com.kingbase8.core.KBStream;
import com.kingbase8.core.ParameterList;
import com.kingbase8.core.QueryExecutor;
import com.kingbase8.core.Utils;
import com.kingbase8.core.v3.TypeTransferModeRegistry;
import com.kingbase8.core.v3.V3ParameterList;
import com.kingbase8.geometric.KBbox;
import com.kingbase8.geometric.KBpoint;
import com.kingbase8.jdbc.UUIDArrayAssistant;
import com.kingbase8.util.ByteConverter;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.StreamWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Arrays;

class SimpleParameterList
implements V3ParameterList {
    public static final byte IN = 1;
    public static final byte OUT = 2;
    public static final byte INOUT = 3;
    public static final byte OUTPARMBEFOREFUNC = 8;
    private static final byte TEXT = 0;
    private static final byte BINARY = 4;
    public static final int INPARM = 0x20000000;
    public static final int OUTPARM = 0x40000000;
    public static final int OUTPARMBEFOREFUNCPARM = Integer.MIN_VALUE;
    private final Object[] paramValues;
    private final int[] paramTypes;
    private final byte[] flags;
    private final byte[][] encoded;
    private final TypeTransferModeRegistry transferModeRegistry;
    private static final Object NULL_OBJECT = new Object();
    private int pos = 0;

    SimpleParameterList(int paramCount, TypeTransferModeRegistry transferModeRegistry) {
        this.paramValues = new Object[paramCount];
        this.paramTypes = new int[paramCount];
        this.encoded = new byte[paramCount][];
        this.flags = new byte[paramCount];
        this.transferModeRegistry = transferModeRegistry;
    }

    @Override
    public void registerOutParameter(int index, int oid, boolean outParmBeforeFunc) throws SQLException {
        if (index < 1 || index > this.paramValues.length) {
            throw new KSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", index, this.paramValues.length), KSQLState.INVALID_PARAMETER_VALUE);
        }
        int n = --index;
        this.flags[n] = (byte)(this.flags[n] | 2);
        if ("oracle".equals(((QueryExecutor)this.transferModeRegistry).getCompatibleLevel())) {
            if (this.paramValues[index] == null) {
                this.paramValues[index] = NULL_OBJECT;
            }
            this.paramTypes[index] = oid;
            if (outParmBeforeFunc && index == 0) {
                int n2 = index;
                this.flags[n2] = (byte)(this.flags[n2] | 8);
            }
        }
        this.pos = index + 1;
    }

    private void bind(int index, Object value, int oid, byte binary) throws SQLException {
        if (index < 1 || index > this.paramValues.length) {
            throw new KSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", index, this.paramValues.length), KSQLState.INVALID_PARAMETER_VALUE);
        }
        this.encoded[--index] = null;
        this.paramValues[index] = value;
        this.flags[index] = (byte)(this.direction(index) | 1 | binary);
        if (oid == 0 && this.paramTypes[index] != 0 && value == NULL_OBJECT) {
            return;
        }
        this.paramTypes[index] = oid;
        this.pos = index + 1;
    }

    @Override
    public int getParameterCount() {
        return this.paramValues.length;
    }

    @Override
    public int getOutParameterCount() {
        int count = 0;
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if ((this.direction(i) & 2) != 2) continue;
            ++count;
        }
        if (count == 0) {
            count = 1;
        }
        return count;
    }

    @Override
    public int getInParameterCount() {
        int count = 0;
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (this.direction(i) == 2) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void setIntParameter(int index, int value) throws SQLException {
        byte[] data = new byte[4];
        ByteConverter.int4(data, 0, value);
        this.bind(index, data, 23, (byte)4);
    }

    @Override
    public void setLiteralParameter(int index, String value, int oid) throws SQLException {
        this.bind(index, value, oid, (byte)0);
    }

    @Override
    public void setStringParameter(int index, String value, int oid) throws SQLException {
        this.bind(index, value, oid, (byte)0);
    }

    @Override
    public void setBinaryParameter(int index, byte[] value, int oid) throws SQLException {
        this.bind(index, value, oid, (byte)4);
    }

    @Override
    public void setBytea(int index, byte[] data, int offset, int length) throws SQLException {
        this.bind(index, new StreamWrapper(data, offset, length), 17, (byte)4);
    }

    @Override
    public void setBytea(int index, InputStream stream, int length) throws SQLException {
        this.bind(index, new StreamWrapper(stream, length), 17, (byte)4);
    }

    @Override
    public void setBytea(int index, InputStream stream) throws SQLException {
        this.bind(index, new StreamWrapper(stream), 17, (byte)4);
    }

    @Override
    public void setText(int index, InputStream stream) throws SQLException {
        this.bind(index, new StreamWrapper(stream), 25, (byte)0);
    }

    @Override
    public void setNull(int index, int oid) throws SQLException {
        byte binaryTransfer = 0;
        if (this.transferModeRegistry.useBinaryForReceive(oid)) {
            binaryTransfer = 4;
        }
        this.bind(index, NULL_OBJECT, oid, binaryTransfer);
    }

    @Override
    public String toString(int index, boolean standardConformingStrings) {
        if (this.paramValues[--index] == null) {
            return "?";
        }
        if (this.paramValues[index] == NULL_OBJECT) {
            return "NULL";
        }
        if ((this.flags[index] & 4) == 4) {
            switch (this.paramTypes[index]) {
                case 21: {
                    short s = ByteConverter.int2((byte[])this.paramValues[index], 0);
                    return Short.toString(s);
                }
                case 23: {
                    int i = ByteConverter.int4((byte[])this.paramValues[index], 0);
                    return Integer.toString(i);
                }
                case 20: {
                    long l = ByteConverter.int8((byte[])this.paramValues[index], 0);
                    return Long.toString(l);
                }
                case 700: {
                    float f = ByteConverter.float4((byte[])this.paramValues[index], 0);
                    if (Float.isNaN(f)) {
                        return "'NaN'::real";
                    }
                    return Float.toString(f);
                }
                case 701: {
                    double d = ByteConverter.float8((byte[])this.paramValues[index], 0);
                    if (Double.isNaN(d)) {
                        return "'NaN'::double precision";
                    }
                    return Double.toString(d);
                }
                case 2950: {
                    String uuid = new UUIDArrayAssistant().buildElement((byte[])this.paramValues[index], 0, 16).toString();
                    return "'" + uuid + "'::uuid";
                }
                case 600: {
                    KBpoint pgPoint = new KBpoint();
                    pgPoint.setByteValue((byte[])this.paramValues[index], 0);
                    return "'" + pgPoint.toString() + "'::point";
                }
                case 603: {
                    KBbox pgBox = new KBbox();
                    pgBox.setByteValue((byte[])this.paramValues[index], 0);
                    return "'" + pgBox.toString() + "'::box";
                }
            }
            return "?";
        }
        String param = this.paramValues[index].toString();
        StringBuilder p = new StringBuilder(3 + (param.length() + 10) / 10 * 11);
        p.append('\'');
        try {
            p = Utils.escapeLiteral(p, param, standardConformingStrings);
        }
        catch (SQLException sqle) {
            p.append(param);
        }
        p.append('\'');
        int paramType = this.paramTypes[index];
        if (paramType == 1114) {
            p.append("::timestamp");
        } else if (paramType == 1184) {
            p.append("::timestamp with time zone");
        } else if (paramType == 1083) {
            p.append("::time");
        } else if (paramType == 1266) {
            p.append("::time with time zone");
        } else if (paramType == 1082) {
            p.append("::date");
        } else if (paramType == 1186) {
            p.append("::interval");
        } else if (paramType == 1700) {
            p.append("::numeric");
        }
        return p.toString();
    }

    @Override
    public void checkAllParametersSet() throws SQLException {
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (this.direction(i) == 2 || this.paramValues[i] != null) continue;
            throw new KSQLException(GT.tr("No value specified for parameter {0}.", i + 1), KSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    @Override
    public void convertFunctionOutParameters() {
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (this.direction(i) != 2) continue;
            this.paramTypes[i] = 2278;
            this.paramValues[i] = "null";
        }
    }

    private static void streamBytea(KBStream pgStream, StreamWrapper wrapper) throws IOException {
        byte[] rawData = wrapper.getBytes();
        if (rawData != null) {
            pgStream.send(rawData, wrapper.getOffset(), wrapper.getLength());
            return;
        }
        pgStream.sendStream(wrapper.getStream(), wrapper.getLength());
    }

    @Override
    public int[] getTypeOIDs() {
        return this.paramTypes;
    }

    int getTypeOID(int index) {
        return this.paramTypes[index - 1];
    }

    boolean hasUnresolvedTypes() {
        for (int paramType : this.paramTypes) {
            if (paramType != 0) continue;
            return true;
        }
        return false;
    }

    void setResolvedType(int index, int oid) {
        if (this.paramTypes[index - 1] == 0) {
            this.paramTypes[index - 1] = oid;
        } else if (this.paramTypes[index - 1] != oid) {
            throw new IllegalArgumentException("Can't change resolved type for param: " + index + " from " + this.paramTypes[index - 1] + " to " + oid);
        }
    }

    boolean isNull(int index) {
        return this.paramValues[index - 1] == NULL_OBJECT;
    }

    boolean isBinary(int index) {
        return (this.flags[index - 1] & 4) != 0;
    }

    private byte direction(int index) {
        return (byte)(this.flags[index] & 3);
    }

    int getV3Length(int index, String encoding) throws UnsupportedEncodingException {
        if (this.paramValues[--index] == NULL_OBJECT) {
            throw new IllegalArgumentException("can't getV3Length() on a null parameter");
        }
        if (this.paramValues[index] instanceof byte[]) {
            return ((byte[])this.paramValues[index]).length;
        }
        if (this.paramValues[index] instanceof StreamWrapper) {
            return ((StreamWrapper)this.paramValues[index]).getLength();
        }
        if (this.encoded[index] == null) {
            this.encoded[index] = Utils.encode(this.paramValues[index].toString(), encoding);
        }
        return this.encoded[index].length;
    }

    void writeV3Value(int index, KBStream pgStream, String encoding) throws IOException {
        if (this.paramValues[--index] == NULL_OBJECT) {
            throw new IllegalArgumentException("can't writeV3Value() on a null parameter");
        }
        if (this.paramValues[index] instanceof byte[]) {
            pgStream.send((byte[])this.paramValues[index]);
            return;
        }
        if (this.paramValues[index] instanceof StreamWrapper) {
            SimpleParameterList.streamBytea(pgStream, (StreamWrapper)this.paramValues[index]);
            return;
        }
        if (this.encoded[index] == null) {
            this.encoded[index] = Utils.encode((String)this.paramValues[index], encoding);
        }
        pgStream.send(this.encoded[index]);
    }

    @Override
    public ParameterList copy() {
        SimpleParameterList newCopy = new SimpleParameterList(this.paramValues.length, this.transferModeRegistry);
        System.arraycopy(this.paramValues, 0, newCopy.paramValues, 0, this.paramValues.length);
        System.arraycopy(this.paramTypes, 0, newCopy.paramTypes, 0, this.paramTypes.length);
        System.arraycopy(this.flags, 0, newCopy.flags, 0, this.flags.length);
        newCopy.pos = this.pos;
        return newCopy;
    }

    @Override
    public void clear() {
        Arrays.fill(this.paramValues, null);
        Arrays.fill(this.paramTypes, 0);
        Arrays.fill((Object[])this.encoded, null);
        Arrays.fill(this.flags, (byte)0);
        this.pos = 0;
    }

    @Override
    public SimpleParameterList[] getSubparams() {
        return null;
    }

    @Override
    public Object[] getValues() {
        return this.paramValues;
    }

    @Override
    public int[] getParamTypes() {
        return this.paramTypes;
    }

    @Override
    public byte[] getFlags() {
        return this.flags;
    }

    @Override
    public byte[][] getEncoding() {
        return this.encoded;
    }

    @Override
    public void appendAll(ParameterList list) throws SQLException {
        if (list instanceof SimpleParameterList) {
            SimpleParameterList spl = (SimpleParameterList)list;
            int inParamCount = spl.getInParameterCount();
            if (this.pos + inParamCount > this.paramValues.length) {
                throw new KSQLException(GT.tr("Added parameters index out of range: {0}, number of columns: {1}.", this.pos + inParamCount, this.paramValues.length), KSQLState.INVALID_PARAMETER_VALUE);
            }
            System.arraycopy(spl.getValues(), 0, this.paramValues, this.pos, inParamCount);
            System.arraycopy(spl.getParamTypes(), 0, this.paramTypes, this.pos, inParamCount);
            System.arraycopy(spl.getFlags(), 0, this.flags, this.pos, inParamCount);
            System.arraycopy(spl.getEncoding(), 0, this.encoded, this.pos, inParamCount);
            this.pos += inParamCount;
        }
    }

    public String toString() {
        StringBuilder ts = new StringBuilder("<[");
        if (this.paramValues.length > 0) {
            ts.append(this.toString(1, true));
            for (int c = 2; c <= this.paramValues.length; ++c) {
                ts.append(" ,").append(this.toString(c, true));
            }
        }
        ts.append("]>");
        return ts.toString();
    }
}

