/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.hostchooser;

import org.postgresql.hostchooser.HostStatus;

public enum HostRequirement {
    ANY("any"){

        @Override
        public boolean allowConnectingTo(HostStatus status) {
            return status != HostStatus.CONNECT_FAIL;
        }
    }
    ,
    MASTER("master"){

        @Override
        public boolean allowConnectingTo(HostStatus status) {
            return status == HostStatus.MASTER || status == HostStatus.CONNECT_OK;
        }
    }
    ,
    SECONDARY("secondary"){

        @Override
        public boolean allowConnectingTo(HostStatus status) {
            return status == HostStatus.SECONDARY || status == HostStatus.MAIN_STANDBY || status == HostStatus.CONNECT_OK;
        }
    }
    ,
    PREFER_SECONDARY("preferSecondary"){

        @Override
        public boolean allowConnectingTo(HostStatus status) {
            return status != HostStatus.CONNECT_FAIL;
        }
    }
    ,
    CLUSTER_MAIN_NODE("clusterMainNode"){

        @Override
        public boolean allowConnectingTo(HostStatus status) {
            return status == HostStatus.MASTER || status == HostStatus.MAIN_STANDBY || status == HostStatus.CONNECT_OK;
        }
    };

    public final String name;

    public abstract boolean allowConnectingTo(HostStatus var1);

    private HostRequirement(String name) {
        this.name = name;
    }

    public static HostRequirement getTargetServerType(String targetServerType) {
        String allowSlave = targetServerType.replace("lave", "econdary");
        return HostRequirement.getValueByName(allowSlave);
    }

    public static HostRequirement getValueByName(String name) {
        for (HostRequirement value : HostRequirement.values()) {
            if (!value.name.equals(name)) continue;
            return value;
        }
        throw new IllegalArgumentException("unexpected name for HostRequirement: " + name);
    }

    public String getName() {
        return this.name;
    }
}

