/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.hostchooser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.postgresql.GlobalConnectionTracker;
import org.postgresql.hostchooser.HostRequirement;
import org.postgresql.hostchooser.HostStatus;
import org.postgresql.util.HostSpec;

public class GlobalHostStatusTracker {
    private static final Map<HostSpec, HostSpecStatus> hostStatusMap = new HashMap<HostSpec, HostSpecStatus>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportHostStatus(HostSpec hostSpec, HostStatus hostStatus, Properties prop) {
        long now = System.currentTimeMillis();
        Map<HostSpec, HostSpecStatus> map = hostStatusMap;
        synchronized (map) {
            HostStatus originalHostStatus;
            HostSpecStatus hostSpecStatus = hostStatusMap.get(hostSpec);
            if (hostSpecStatus == null) {
                hostSpecStatus = new HostSpecStatus(hostSpec);
                hostStatusMap.put(hostSpec, hostSpecStatus);
                originalHostStatus = hostStatus;
            } else {
                originalHostStatus = hostSpecStatus.status;
            }
            hostSpecStatus.status = hostStatus;
            hostSpecStatus.lastUpdated = now;
            GlobalHostStatusTracker.observationState(prop, originalHostStatus, hostStatus, hostSpec);
        }
    }

    public static void observationState(Properties prop, HostStatus originalHostStatus, HostStatus currentHostStatus, HostSpec hostSpec) {
        if ((originalHostStatus == HostStatus.SECONDARY || originalHostStatus == HostStatus.MAIN_STANDBY) && currentHostStatus == HostStatus.MASTER) {
            GlobalConnectionTracker.closeOldConnection(hostSpec.toString(), prop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<HostSpec> getCandidateHosts(HostSpec[] hostSpecs, HostRequirement targetServerType, long hostRecheckMillis) {
        ArrayList<HostSpec> candidates = new ArrayList<HostSpec>(hostSpecs.length);
        long latestAllowedUpdate = System.currentTimeMillis() - hostRecheckMillis;
        Map<HostSpec, HostSpecStatus> map = hostStatusMap;
        synchronized (map) {
            for (HostSpec hostSpec : hostSpecs) {
                HostSpecStatus hostInfo = hostStatusMap.get(hostSpec);
                if (hostInfo != null && hostInfo.lastUpdated >= latestAllowedUpdate && !targetServerType.allowConnectingTo(hostInfo.status)) continue;
                candidates.add(hostSpec);
            }
        }
        return candidates;
    }

    static class HostSpecStatus {
        final HostSpec host;
        HostStatus status;
        long lastUpdated;

        HostSpecStatus(HostSpec host) {
            this.host = host;
        }

        public String toString() {
            return this.host.toString() + '=' + (Object)((Object)this.status);
        }
    }
}

