/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import dm.jdbc.driver.DBError;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;

public class StringEncoder {
    private byte[][] unicodeMapping = new byte[65536][];

    public StringEncoder(String string) {
        try {
            int n2 = 0;
            while (n2 < 65536) {
                char c2 = (char)n2;
                this.unicodeMapping[n2] = String.valueOf(c2).getBytes(string);
                ++n2;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            DBError.throwRuntimeException("create string encoder fail", unsupportedEncodingException);
        }
    }

    public final int getBytes(String string, byte[] byArray) {
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        while (n3 < n4) {
            byte[] byArray2 = this.unicodeMapping[string.charAt(n3)];
            byArray[n2++] = byArray2[0];
            if (byArray2.length > 1) {
                byArray[n2++] = byArray2[1];
                if (byArray2.length > 2) {
                    byArray[n2++] = byArray2[2];
                    if (byArray2.length > 3) {
                        byArray[n2++] = byArray2[3];
                    }
                }
            }
            ++n3;
        }
        return n2;
    }

    public final byte[] getBytes(String string) {
        byte[] byArray = new byte[string.length() * 3];
        int n2 = this.getBytes(string, byArray);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public static void main(String[] stringArray) {
        String string = "`M<>?\":{}][|\\]12345*()_+~!@#$%^&\u8fbe\u68a6\u6570\u636e\u5e93\u5f88\u597d\u5f88\u5f3a\u5927";
        String string2 = "\u8fbe\u68a6";
        String string3 = "\u5f88\u597d";
        String string4 = "\u6570\u636e";
        String string5 = "\u636e\u5e93";
        String string6 = "\u5f3a\u5927";
        String string7 = "\u6570\u636e\u5e93";
        String string8 = "\u5f88\u5f3a\u5927";
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        byte[] byArray6 = null;
        byte[] byArray7 = null;
        byte[] byArray8 = null;
        byte[] byArray9 = null;
        byte[] byArray10 = null;
        byte[] byArray11 = null;
        byte[] byArray12 = null;
        byte[] byArray13 = null;
        byte[] byArray14 = null;
        byte[] byArray15 = null;
        byte[] byArray16 = null;
        StringEncoder stringEncoder = new StringEncoder(Charset.defaultCharset().name());
        long l2 = System.currentTimeMillis();
        int n2 = 0;
        while (n2 < 5000000) {
            byArray = stringEncoder.getBytes(string);
            byArray2 = stringEncoder.getBytes(string2);
            byArray3 = stringEncoder.getBytes(string3);
            byArray4 = stringEncoder.getBytes(string4);
            byArray5 = stringEncoder.getBytes(string5);
            byArray6 = stringEncoder.getBytes(string6);
            byArray7 = stringEncoder.getBytes(string7);
            byArray8 = stringEncoder.getBytes(string8);
            ++n2;
        }
        System.out.println(System.currentTimeMillis() - l2);
        l2 = System.currentTimeMillis();
        n2 = 0;
        while (n2 < 5000000) {
            byArray9 = string.getBytes();
            byArray10 = string2.getBytes();
            byArray11 = string3.getBytes();
            byArray12 = string4.getBytes();
            byArray13 = string5.getBytes();
            byArray14 = string6.getBytes();
            byArray15 = string7.getBytes();
            byArray16 = string8.getBytes();
            ++n2;
        }
        System.out.println(System.currentTimeMillis() - l2);
        System.out.println(Arrays.equals(byArray, byArray9));
        System.out.println(Arrays.equals(byArray2, byArray10));
        System.out.println(Arrays.equals(byArray3, byArray11));
        System.out.println(Arrays.equals(byArray4, byArray12));
        System.out.println(Arrays.equals(byArray5, byArray13));
        System.out.println(Arrays.equals(byArray6, byArray14));
        System.out.println(Arrays.equals(byArray7, byArray15));
        System.out.println(Arrays.equals(byArray8, byArray16));
    }
}

