/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.Column;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.filter.Filterable;
import dm.jdbc.util.StringUtil;
import java.sql.ResultSetMetaData;
import java.util.concurrent.atomic.AtomicLong;

public class DmdbResultSetMetaData
extends Filterable
implements ResultSetMetaData {
    public DmdbConnection connection;
    private Column[] columns;
    public static AtomicLong IDGenerator = new AtomicLong(0L);

    @Override
    public long getID() {
        if (this.ID < 0L) {
            this.ID = IDGenerator.incrementAndGet();
        }
        return this.ID;
    }

    public DmdbResultSetMetaData(DmdbConnection dmdbConnection, Column[] columnArray) {
        super(dmdbConnection, null);
        this.connection = dmdbConnection;
        this.columns = columnArray;
    }

    private Column checkIndex(int n2) {
        if (n2 < 1 || n2 > this.columns.length) {
            DBError.ECJDBC_INVALID_SEQUENCE_NUMBER.throwz(new Object[0]);
        }
        return this.columns[n2 - 1];
    }

    public int do_getColumnCount() {
        return this.columns.length;
    }

    public boolean do_isAutoIncrement(int n2) {
        Column column = this.checkIndex(n2);
        return column.identity;
    }

    public boolean do_isCaseSensitive(int n2) {
        Column column = this.checkIndex(n2);
        boolean bl = false;
        switch (column.type) {
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean do_isSearchable(int n2) {
        Column column = this.checkIndex(n2);
        boolean bl = true;
        switch (column.type) {
            case 12: 
            case 17: 
            case 18: 
            case 19: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    public boolean do_isCurrency(int n2) {
        Column column = this.checkIndex(n2);
        return column.type == 9 && column.prec == 19 && column.scale == 4;
    }

    public int do_isNullable(int n2) {
        Column column = this.checkIndex(n2);
        return column.nullable ? 1 : 0;
    }

    public boolean do_isSigned(int n2) {
        Column column = this.checkIndex(n2);
        return DmdbType.isNumeric(column.type);
    }

    public int do_getColumnDisplaySize(int n2) {
        Column column = this.checkIndex(n2);
        int n3 = 0;
        switch (column.type) {
            case 3: 
            case 13: {
                n3 = 1;
                break;
            }
            case 5: {
                n3 = 4;
                break;
            }
            case 6: {
                n3 = 6;
                break;
            }
            case 7: {
                n3 = 11;
                break;
            }
            case 8: {
                n3 = 20;
                break;
            }
            case 9: {
                if (column.prec == 0) {
                    n3 = 22;
                    break;
                }
                n3 = column.prec + 2;
                break;
            }
            case 10: {
                n3 = 25;
                break;
            }
            case 11: {
                n3 = StringUtil.equalsIgnoreCase(column.typeName, "DOUBLE") ? 53 : 54;
                break;
            }
            case 12: 
            case 17: 
            case 18: {
                n3 = column.prec * 2;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                n3 = column.prec;
                break;
            }
            case 14: {
                n3 = 10;
                break;
            }
            case 15: {
                if (column.scale != 0) {
                    n3 = 9 + column.scale;
                    break;
                }
                n3 = 8;
                break;
            }
            case 16: {
                int n4 = column.scale;
                n3 = n4 != 0 ? 20 + n4 : 19;
                break;
            }
            case 25: {
                n3 = column.prec + 2;
                break;
            }
            default: {
                n3 = column.prec;
            }
        }
        return n3;
    }

    public String do_getColumnLabel(int n2) {
        return this.do_getColumnName(n2);
    }

    public String do_getColumnName(int n2) {
        Column column = this.checkIndex(n2);
        String string = column.name;
        if (string == null) {
            return string;
        }
        if (this.connection.isColumnNameUpperCase()) {
            return string.toUpperCase();
        }
        if (this.connection.isColumnNameLowerCase()) {
            return string.toLowerCase();
        }
        return string;
    }

    public String do_getSchemaName(int n2) {
        Column column = this.checkIndex(n2);
        String string = column.schemaName;
        return string == null ? "" : string;
    }

    public int do_getPrecision(int n2) {
        Column column = this.checkIndex(n2);
        return DmdbType.d2jPrec(column);
    }

    public int do_getScale(int n2) {
        Column column = this.checkIndex(n2);
        return column.scale;
    }

    public String do_getTableName(int n2) {
        Column column = this.checkIndex(n2);
        return column.tableName;
    }

    public String do_getCatalogName(int n2) {
        return "";
    }

    public int do_getColumnType(int n2) {
        Column column = this.checkIndex(n2);
        return DmdbType.d2jType(column, this.connection);
    }

    public String do_getColumnTypeName(int n2) {
        Column column = this.checkIndex(n2);
        if (DmdbType.isComplexType(column.type, column.scale)) {
            return column.typeDescriptor.getFulName();
        }
        String string = column.typeName;
        if (StringUtil.isEmpty(string)) {
            string = DmdbType.getDTypeName(column);
        }
        return string;
    }

    public boolean do_isReadOnly(int n2) {
        Column column = this.checkIndex(n2);
        return !this.connection.compatibleOracle() && column.readonly;
    }

    public boolean do_isWritable(int n2) {
        return !this.do_isReadOnly(n2);
    }

    public boolean do_isDefinitelyWritable(int n2) {
        return this.do_isWritable(n2);
    }

    public String do_getColumnClassName(int n2) {
        int n3 = this.do_getColumnType(n2);
        return DmdbType.getClassName(n3, this.columns[n2 - 1].type);
    }

    @Override
    public int getColumnCount() {
        if (this.filterChain == null) {
            return this.do_getColumnCount();
        }
        return this.filterChain.reset().ResultSetMetaData_getColumnCount(this);
    }

    @Override
    public boolean isAutoIncrement(int n2) {
        if (this.filterChain == null) {
            return this.do_isAutoIncrement(n2);
        }
        return this.filterChain.reset().ResultSetMetaData_isAutoIncrement(this, n2);
    }

    @Override
    public boolean isCaseSensitive(int n2) {
        if (this.filterChain == null) {
            return this.do_isCaseSensitive(n2);
        }
        return this.filterChain.reset().ResultSetMetaData_isCaseSensitive(this, n2);
    }

    @Override
    public boolean isSearchable(int n2) {
        if (this.filterChain == null) {
            return this.do_isSearchable(n2);
        }
        return this.filterChain.reset().ResultSetMetaData_isSearchable(this, n2);
    }

    @Override
    public boolean isCurrency(int n2) {
        if (this.filterChain == null) {
            return this.do_isCurrency(n2);
        }
        return this.filterChain.reset().ResultSetMetaData_isCurrency(this, n2);
    }

    @Override
    public int isNullable(int n2) {
        if (this.filterChain == null) {
            return this.do_isNullable(n2);
        }
        return this.filterChain.reset().ResultSetMetaData_isNullable(this, n2);
    }

    @Override
    public boolean isSigned(int n2) {
        if (this.filterChain == null) {
            return this.do_isSigned(n2);
        }
        return this.filterChain.reset().ResultSetMetaData_isSigned(this, n2);
    }

    @Override
    public int getColumnDisplaySize(int n2) {
        if (this.filterChain == null) {
            return this.do_getColumnDisplaySize(n2);
        }
        return this.filterChain.reset().ResultSetMetaData_getColumnDisplaySize(this, n2);
    }

    @Override
    public String getColumnLabel(int n2) {
        if (this.filterChain == null) {
            return this.do_getColumnLabel(n2);
        }
        return this.filterChain.reset().ResultSetMetaData_getColumnLabel(this, n2);
    }

    @Override
    public String getColumnName(int n2) {
        if (this.filterChain == null) {
            return this.do_getColumnName(n2);
        }
        return this.filterChain.reset().ResultSetMetaData_getColumnName(this, n2);
    }

    @Override
    public String getSchemaName(int n2) {
        if (this.filterChain == null) {
            return this.do_getSchemaName(n2);
        }
        return this.filterChain.reset().ResultSetMetaData_getSchemaName(this, n2);
    }

    @Override
    public int getPrecision(int n2) {
        if (this.filterChain == null) {
            return this.do_getPrecision(n2);
        }
        return this.filterChain.reset().ResultSetMetaData_getPrecision(this, n2);
    }

    @Override
    public int getScale(int n2) {
        if (this.filterChain == null) {
            return this.do_getScale(n2);
        }
        return this.filterChain.reset().ResultSetMetaData_getScale(this, n2);
    }

    @Override
    public String getTableName(int n2) {
        if (this.filterChain == null) {
            return this.do_getTableName(n2);
        }
        return this.filterChain.reset().ResultSetMetaData_getTableName(this, n2);
    }

    @Override
    public String getCatalogName(int n2) {
        if (this.filterChain == null) {
            return this.do_getCatalogName(n2);
        }
        return this.filterChain.reset().ResultSetMetaData_getCatalogName(this, n2);
    }

    @Override
    public int getColumnType(int n2) {
        if (this.filterChain == null) {
            return this.do_getColumnType(n2);
        }
        return this.filterChain.reset().ResultSetMetaData_getColumnType(this, n2);
    }

    @Override
    public String getColumnTypeName(int n2) {
        if (this.filterChain == null) {
            return this.do_getColumnTypeName(n2);
        }
        return this.filterChain.reset().ResultSetMetaData_getColumnTypeName(this, n2);
    }

    @Override
    public boolean isReadOnly(int n2) {
        if (this.filterChain == null) {
            return this.do_isReadOnly(n2);
        }
        return this.filterChain.reset().ResultSetMetaData_isReadOnly(this, n2);
    }

    @Override
    public boolean isWritable(int n2) {
        if (this.filterChain == null) {
            return this.do_isWritable(n2);
        }
        return this.filterChain.reset().ResultSetMetaData_isWritable(this, n2);
    }

    @Override
    public boolean isDefinitelyWritable(int n2) {
        if (this.filterChain == null) {
            return this.do_isDefinitelyWritable(n2);
        }
        return this.filterChain.reset().ResultSetMetaData_isDefinitelyWritable(this, n2);
    }

    @Override
    public String getColumnClassName(int n2) {
        if (this.filterChain == null) {
            return this.do_getColumnClassName(n2);
        }
        return this.filterChain.reset().ResultSetMetaData_getColumnClassName(this, n2);
    }

    public Object unwrap(Class clazz) {
        return clazz.cast(this);
    }

    public boolean isWrapperFor(Class clazz) {
        return clazz.isInstance(this);
    }
}

