CREATE TABLE "CONFIG_INFO"
(
    "ID" INT IDENTITY(1, 1) NOT NULL,
    "DATA_ID" NVARCHAR2(255 CHAR) NOT NULL,
    "GROUP_ID" NVARCHAR2(255 CHAR),
    "CONTENT" TEXT NOT NULL,
    "MD5" NVARCHAR2(32 CHAR),
    "GMT_CREATE" DATE DEFAULT SYSDATE() NOT NULL,
    "GMT_MODIFIED" DATE DEFAULT SYSDATE() NOT NULL,
    "SRC_USER" TEXT,
    "SRC_IP" NVARCHAR2(50 CHAR),
    "APP_NAME" NVARCHAR2(128 CHAR),
    "TENANT_ID" NVARCHAR2(128 CHAR) DEFAULT '',
    "C_DESC" NVARCHAR2(256 CHAR),
    "C_USE" NVARCHAR2(64 CHAR),
    "EFFECT" NVARCHAR2(64 CHAR),
    "TYPE" NVARCHAR2(64 CHAR),
    "C_SCHEMA" TEXT,
    "ENCRYPTED_DATA_KEY" NVARCHAR2(1024 CHAR) ,
    NOT CLUSTER PRIMARY KEY("ID")) STORAGE(ON "MAIN", CLUSTERBTR) ;



CREATE TABLE "CONFIG_INFO_AGGR"
(
    "ID" INT IDENTITY(1, 1) NOT NULL,
    "DATA_ID" NVARCHAR2(255 CHAR) NOT NULL,
    "GROUP_ID" NVARCHAR2(255 CHAR) NOT NULL,
    "DATUM_ID" NVARCHAR2(255 CHAR) NOT NULL,
    "CONTENT" TEXT NOT NULL,
    "GMT_MODIFIED" DATE NOT NULL,
    "APP_NAME" NVARCHAR2(128 CHAR),
    "TENANT_ID" NVARCHAR2(128 CHAR),
    NOT CLUSTER PRIMARY KEY("ID")) STORAGE(ON "MAIN", CLUSTERBTR) ;

CREATE TABLE "CONFIG_INFO_BETA"
(
    "ID" INT IDENTITY(1, 1) NOT NULL,
    "DATA_ID" NVARCHAR2(255 CHAR) NOT NULL,
    "GROUP_ID" NVARCHAR2(128 CHAR) NOT NULL,
    "APP_NAME" NVARCHAR2(128 CHAR),
    "CONTENT" TEXT NOT NULL,
    "BETA_IPS" TEXT,
    "MD5" NVARCHAR2(32 CHAR),
    "GMT_CREATE" DATE NOT NULL,
    "GMT_MODIFIED" DATE NOT NULL,
    "SRC_USER" TEXT,
    "SRC_IP" NVARCHAR2(50 CHAR),
    "TENANT_ID" NVARCHAR2(128 CHAR),
    "ENCRYPTED_DATA_KEY" NVARCHAR2(1024 CHAR) ,
    NOT CLUSTER PRIMARY KEY("ID")) STORAGE(ON "MAIN", CLUSTERBTR) ;

CREATE TABLE "CONFIG_INFO_TAG"
(
    "ID" INT IDENTITY(1, 1) NOT NULL,
    "DATA_ID" NVARCHAR2(255 CHAR) NOT NULL,
    "GROUP_ID" NVARCHAR2(128 CHAR) NOT NULL,
    "TENANT_ID" NVARCHAR2(128 CHAR),
    "TAG_ID" NVARCHAR2(128 CHAR) NOT NULL,
    "APP_NAME" NVARCHAR2(128 CHAR),
    "CONTENT" TEXT NOT NULL,
    "MD5" NVARCHAR2(32 CHAR),
    "GMT_CREATE" DATE NOT NULL,
    "GMT_MODIFIED" DATE NOT NULL,
    "SRC_USER" TEXT,
    "SRC_IP" NVARCHAR2(50 CHAR),
    NOT CLUSTER PRIMARY KEY("ID")) STORAGE(ON "MAIN", CLUSTERBTR) ;

CREATE TABLE "CONFIG_TAGS_RELATION"
(
    "ID" NUMBER(20,0) NOT NULL,
    "TAG_NAME" NVARCHAR2(128 CHAR) NOT NULL,
    "TAG_TYPE" NVARCHAR2(64 CHAR),
    "DATA_ID" NVARCHAR2(255 CHAR) NOT NULL,
    "GROUP_ID" NVARCHAR2(128 CHAR) NOT NULL,
    "TENANT_ID" NVARCHAR2(128 CHAR),
    "NID" INT IDENTITY(1, 1) NOT NULL,
    NOT CLUSTER PRIMARY KEY("NID")) STORAGE(ON "MAIN", CLUSTERBTR) ;

CREATE TABLE "GROUP_CAPACITY"
(
    "ID" INT IDENTITY(1, 1) NOT NULL,
    "GROUP_ID" NVARCHAR2(128 CHAR) NOT NULL,
    "QUOTA" NUMBER(11,0) NOT NULL,
    "USAGE" NUMBER(11,0) NOT NULL,
    "MAX_SIZE" NUMBER(11,0) NOT NULL,
    "MAX_AGGR_COUNT" NUMBER(11,0) NOT NULL,
    "MAX_AGGR_SIZE" NUMBER(11,0) NOT NULL,
    "MAX_HISTORY_COUNT" NUMBER(11,0) NOT NULL,
    "GMT_CREATE" DATE NOT NULL,
    "GMT_MODIFIED" DATE NOT NULL,
    NOT CLUSTER PRIMARY KEY("ID")) STORAGE(ON "MAIN", CLUSTERBTR) ;



CREATE TABLE "HIS_CONFIG_INFO"
(
    "ID" INT NOT NULL,
    "NID" INT IDENTITY(1, 1) NOT NULL,
    "DATA_ID" NVARCHAR2(255 CHAR) NOT NULL,
    "GROUP_ID" NVARCHAR2(128 CHAR) NOT NULL,
    "APP_NAME" NVARCHAR2(128 CHAR),
    "CONTENT" TEXT NOT NULL,
    "MD5" NVARCHAR2(32 CHAR),
    "GMT_CREATE" DATE DEFAULT SYSDATE() NOT NULL,
    "GMT_MODIFIED" DATE DEFAULT SYSDATE() NOT NULL,
    "SRC_USER" TEXT,
    "SRC_IP" NVARCHAR2(50 CHAR),
    "OP_TYPE" NCHAR(10),
    "TENANT_ID" NVARCHAR2(128 CHAR),
    "ENCRYPTED_DATA_KEY" NVARCHAR2(1024 CHAR) ,
    NOT CLUSTER PRIMARY KEY("NID")) STORAGE(ON "MAIN", CLUSTERBTR) ;



CREATE TABLE "PERMISSIONS"
(
    "ROLE" NVARCHAR2(50 CHAR) NOT NULL,
    "RESOURCE" NVARCHAR2(255 CHAR) NOT NULL,
    "ACTION" NVARCHAR2(8 CHAR) NOT NULL) STORAGE(ON "MAIN", CLUSTERBTR) ;

CREATE TABLE "ROLES"
(
    "USERNAME" NVARCHAR2(50 CHAR) NOT NULL,
    "ROLE" NVARCHAR2(50 CHAR) NOT NULL) STORAGE(ON "MAIN", CLUSTERBTR) ;

CREATE TABLE "TENANT_CAPACITY"
(
    "ID" INT IDENTITY(1, 1) NOT NULL,
    "TENANT_ID" NVARCHAR2(128 CHAR) NOT NULL,
    "QUOTA" NUMBER(11,0) NOT NULL,
    "USAGE" NUMBER(11,0) NOT NULL,
    "MAX_SIZE" NUMBER(11,0) NOT NULL,
    "MAX_AGGR_COUNT" NUMBER(11,0) NOT NULL,
    "MAX_AGGR_SIZE" NUMBER(11,0) NOT NULL,
    "MAX_HISTORY_COUNT" NUMBER(11,0) NOT NULL,
    "GMT_CREATE" DATE NOT NULL,
    "GMT_MODIFIED" DATE NOT NULL,
    NOT CLUSTER PRIMARY KEY("ID")) STORAGE(ON "MAIN", CLUSTERBTR) ;


CREATE TABLE "TENANT_INFO"
(
    "ID" INT IDENTITY(1, 1) NOT NULL,
    "KP" NVARCHAR2(128 CHAR) NOT NULL,
    "TENANT_ID" NVARCHAR2(128 CHAR),
    "TENANT_NAME" NVARCHAR2(128 CHAR),
    "TENANT_DESC" NVARCHAR2(256 CHAR),
    "CREATE_SOURCE" NVARCHAR2(32 CHAR),
    "GMT_CREATE" NUMBER(20,0) NOT NULL,
    "GMT_MODIFIED" NUMBER(20,0) NOT NULL,
    NOT CLUSTER PRIMARY KEY("ID")) STORAGE(ON "MAIN", CLUSTERBTR) ;



CREATE TABLE "USERS"
(
    "USERNAME" NVARCHAR2(50 CHAR) NOT NULL,
    "PASSWORD" NVARCHAR2(500 CHAR) NOT NULL,
    "ENABLED" NUMBER(4,0) NOT NULL) STORAGE(ON "MAIN", CLUSTERBTR) ;

CREATE UNIQUE  INDEX "UK_CONFIG_INFO" ON "CONFIG_INFO"("DATA_ID" ASC,"GROUP_ID" ASC,"TENANT_ID" ASC) STORAGE(ON "MAIN", CLUSTERBTR);

CREATE UNIQUE  INDEX "UK_CONFIG_INFO_AGGR" ON "CONFIG_INFO_AGGR"("DATA_ID" ASC,"GROUP_ID" ASC,"DATUM_ID" ASC,"TENANT_ID" ASC) STORAGE(ON "MAIN", CLUSTERBTR);

CREATE UNIQUE  INDEX "UK_CONFIG_INFO_BETA" ON "CONFIG_INFO_BETA"("DATA_ID" ASC,"GROUP_ID" ASC,"TENANT_ID" ASC) STORAGE(ON "MAIN", CLUSTERBTR);

CREATE UNIQUE  INDEX "UK_CONFIG_INFO_TAG" ON "CONFIG_INFO_TAG"("DATA_ID" ASC,"GROUP_ID" ASC,"TENANT_ID" ASC,"TAG_ID" ASC) STORAGE(ON "MAIN", CLUSTERBTR) ;

CREATE  INDEX "INDEX_TENANT_ID" ON "CONFIG_TAGS_RELATION"("TENANT_ID" ASC) STORAGE(ON "MAIN", CLUSTERBTR) ;

CREATE UNIQUE  INDEX "UK_TAGS_RELATION" ON "CONFIG_TAGS_RELATION"("ID" ASC,"TAG_NAME" ASC,"TAG_TYPE" ASC) STORAGE(ON "MAIN", CLUSTERBTR) ;

CREATE UNIQUE  INDEX "UK_GROUP_ID" ON "GROUP_CAPACITY"("GROUP_ID" ASC) STORAGE(ON "MAIN", CLUSTERBTR) ;

CREATE  INDEX "INDEX_DATA_ID" ON "HIS_CONFIG_INFO"("DATA_ID" ASC) STORAGE(ON "MAIN", CLUSTERBTR) ;

CREATE  INDEX "INDEX_GMT_CREATE" ON "HIS_CONFIG_INFO"("GMT_CREATE" ASC) STORAGE(ON "MAIN", CLUSTERBTR) ;

CREATE  INDEX "INDEX_GMT_MODIFIED" ON "HIS_CONFIG_INFO"("GMT_MODIFIED" ASC) STORAGE(ON "MAIN", CLUSTERBTR) ;

CREATE UNIQUE  INDEX "UK_PREMISSIONS" ON "PERMISSIONS"("ROLE" ASC,"RESOURCE" ASC,"ACTION" ASC) STORAGE(ON "MAIN", CLUSTERBTR) ;

CREATE UNIQUE  INDEX "UK_ROLES" ON "ROLES"("USERNAME" ASC,"ROLE" ASC) STORAGE(ON "MAIN", CLUSTERBTR) ;

CREATE UNIQUE  INDEX "UK_TENANT_ID" ON "TENANT_CAPACITY"("TENANT_ID" ASC) STORAGE(ON "MAIN", CLUSTERBTR) ;

CREATE UNIQUE  INDEX "UK_TENANT_INFO" ON "TENANT_INFO"("KP" ASC,"TENANT_ID" ASC) STORAGE(ON "MAIN", CLUSTERBTR) ;