/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.a.a;
import dm.jdbc.desc.Column;
import dm.jdbc.driver.DBError;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.DateFormatOracle;
import dm.jdbc.util.DateUtil;
import dm.jdbc.util.StringUtil;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;

public class DmdbTimestamp
extends Timestamp
implements Serializable {
    private static final long serialVersionUID = 544720274538766252L;
    public static final long MiSeconds_1900_1970 = 2209017600000L;
    public static final int MAX_YEAR = 9999;
    public static final int MIN_YEAR = -4712;
    public static final int OFFSET_YEAR = 0;
    public static final int OFFSET_MONTH = 1;
    public static final int OFFSET_DAY = 2;
    public static final int OFFSET_HOUR = 3;
    public static final int OFFSET_MINUTE = 4;
    public static final int OFFSET_SECOND = 5;
    public static final int OFFSET_MICROSECOND = 6;
    public static final int OFFSET_TIMEZONE = 7;
    public static final int DT_LEN = 8;
    public static final int INVALID_VALUE = Integer.MIN_VALUE;
    public int[] dt = new int[8];
    public int dtype = 16;
    public int scale = 6;
    private static ThreadLocal calendars = new ThreadLocal();

    private static Calendar getCalendar() {
        Calendar calendar = (Calendar)calendars.get();
        if (calendar == null) {
            calendar = Calendar.getInstance(TimeZone.getDefault());
            calendars.set(calendar);
        }
        return calendar;
    }

    private DmdbTimestamp() {
        super(0L);
    }

    private DmdbTimestamp init() {
        super.setTime(this.getTime());
        super.setNanos(this.getNanos());
        return this;
    }

    public static DmdbTimestamp valueOf(byte[] byArray, Column column, a a2) {
        DmdbTimestamp dmdbTimestamp = new DmdbTimestamp();
        dmdbTimestamp.decode(byArray, column, a2.getLocalTimezone(), a2.getDBTimezone());
        return dmdbTimestamp.init();
    }

    public static DmdbTimestamp valueOf(long l2, Column column) {
        DmdbTimestamp dmdbTimestamp = new DmdbTimestamp();
        dmdbTimestamp.setTime(l2);
        dmdbTimestamp.dtype = column.type;
        dmdbTimestamp.scale = column.scale;
        return dmdbTimestamp.init();
    }

    public static DmdbTimestamp valueOf(String string) {
        DmdbTimestamp dmdbTimestamp = new DmdbTimestamp();
        dmdbTimestamp.parseString(string);
        return dmdbTimestamp.init();
    }

    public static DmdbTimestamp valueOf(String string, Column column, a a2) {
        DmdbTimestamp dmdbTimestamp = new DmdbTimestamp();
        String string2 = a2.getFormat(column.type);
        if (StringUtil.isNotEmpty(string2)) {
            dmdbTimestamp.dt = DateFormatOracle.parse(string, string2, a2.getDateLanguage());
            dmdbTimestamp.dtype = column.type;
            dmdbTimestamp.scale = column.scale;
            return dmdbTimestamp.init();
        }
        dmdbTimestamp.parseString(string);
        return dmdbTimestamp.init();
    }

    public static DmdbTimestamp valueOf(java.util.Date date) {
        DmdbTimestamp dmdbTimestamp = new DmdbTimestamp();
        dmdbTimestamp.setTime(date.getTime());
        if (date instanceof Timestamp) {
            dmdbTimestamp.setNanos(((Timestamp)date).getNanos());
        }
        dmdbTimestamp.dtype = 16;
        dmdbTimestamp.scale = 6;
        return dmdbTimestamp.init();
    }

    public static DmdbTimestamp valueOf(LocalDate localDate) {
        DmdbTimestamp dmdbTimestamp = new DmdbTimestamp();
        dmdbTimestamp.dt[0] = localDate.getYear();
        dmdbTimestamp.dt[1] = localDate.getMonthValue();
        dmdbTimestamp.dt[2] = localDate.getDayOfMonth();
        dmdbTimestamp.dt[7] = Integer.MIN_VALUE;
        dmdbTimestamp.dtype = 14;
        dmdbTimestamp.scale = 0;
        return dmdbTimestamp.init();
    }

    public static DmdbTimestamp valueOf(LocalTime localTime) {
        DmdbTimestamp dmdbTimestamp = new DmdbTimestamp();
        dmdbTimestamp.dt[0] = 1900;
        dmdbTimestamp.dt[1] = 1;
        dmdbTimestamp.dt[2] = 1;
        dmdbTimestamp.dt[3] = localTime.getHour();
        dmdbTimestamp.dt[4] = localTime.getMinute();
        dmdbTimestamp.dt[5] = localTime.getSecond();
        dmdbTimestamp.dt[6] = localTime.getNano() / 1000;
        dmdbTimestamp.dt[7] = Integer.MIN_VALUE;
        dmdbTimestamp.dtype = 15;
        dmdbTimestamp.scale = 6;
        return dmdbTimestamp.init();
    }

    public static DmdbTimestamp valueOf(LocalDateTime localDateTime) {
        DmdbTimestamp dmdbTimestamp = new DmdbTimestamp();
        dmdbTimestamp.dt[0] = localDateTime.getYear();
        dmdbTimestamp.dt[1] = localDateTime.getMonthValue();
        dmdbTimestamp.dt[2] = localDateTime.getDayOfMonth();
        dmdbTimestamp.dt[3] = localDateTime.getHour();
        dmdbTimestamp.dt[4] = localDateTime.getMinute();
        dmdbTimestamp.dt[5] = localDateTime.getSecond();
        dmdbTimestamp.dt[6] = localDateTime.getNano() / 1000;
        dmdbTimestamp.dt[7] = Integer.MIN_VALUE;
        dmdbTimestamp.dtype = 16;
        dmdbTimestamp.scale = 6;
        return dmdbTimestamp.init();
    }

    public static DmdbTimestamp valueOf(ZonedDateTime zonedDateTime) {
        DmdbTimestamp dmdbTimestamp = new DmdbTimestamp();
        dmdbTimestamp.dt[0] = zonedDateTime.getYear();
        dmdbTimestamp.dt[1] = zonedDateTime.getMonthValue();
        dmdbTimestamp.dt[2] = zonedDateTime.getDayOfMonth();
        dmdbTimestamp.dt[3] = zonedDateTime.getHour();
        dmdbTimestamp.dt[4] = zonedDateTime.getMinute();
        dmdbTimestamp.dt[5] = zonedDateTime.getSecond();
        dmdbTimestamp.dt[6] = zonedDateTime.getNano() / 1000;
        dmdbTimestamp.dt[7] = zonedDateTime.getOffset().getTotalSeconds() / 60;
        dmdbTimestamp.dtype = 23;
        dmdbTimestamp.scale = 6;
        return dmdbTimestamp.init();
    }

    public static DmdbTimestamp valueOf(OffsetDateTime offsetDateTime) {
        DmdbTimestamp dmdbTimestamp = new DmdbTimestamp();
        dmdbTimestamp.dt[0] = offsetDateTime.getYear();
        dmdbTimestamp.dt[1] = offsetDateTime.getMonthValue();
        dmdbTimestamp.dt[2] = offsetDateTime.getDayOfMonth();
        dmdbTimestamp.dt[3] = offsetDateTime.getHour();
        dmdbTimestamp.dt[4] = offsetDateTime.getMinute();
        dmdbTimestamp.dt[5] = offsetDateTime.getSecond();
        dmdbTimestamp.dt[6] = offsetDateTime.getNano() / 1000;
        dmdbTimestamp.dt[7] = offsetDateTime.getOffset().getTotalSeconds() / 60;
        dmdbTimestamp.dtype = 23;
        dmdbTimestamp.scale = 6;
        return dmdbTimestamp.init();
    }

    public static DmdbTimestamp valueOf(OffsetTime offsetTime) {
        DmdbTimestamp dmdbTimestamp = new DmdbTimestamp();
        dmdbTimestamp.dt[0] = 1900;
        dmdbTimestamp.dt[1] = 1;
        dmdbTimestamp.dt[2] = 1;
        dmdbTimestamp.dt[3] = offsetTime.getHour();
        dmdbTimestamp.dt[4] = offsetTime.getMinute();
        dmdbTimestamp.dt[5] = offsetTime.getSecond();
        dmdbTimestamp.dt[6] = offsetTime.getNano() / 1000;
        dmdbTimestamp.dt[7] = offsetTime.getOffset().getTotalSeconds() / 60;
        dmdbTimestamp.dtype = 22;
        dmdbTimestamp.scale = 6;
        return dmdbTimestamp.init();
    }

    @Override
    public String toString() {
        return this.toString(this.dtype, this.scale);
    }

    private String toString(int n2, int n3) {
        switch (n2) {
            case 14: {
                return String.valueOf(DateUtil.formatYear(this.dt[0])) + "-" + DateUtil.format2(this.dt[1]) + "-" + DateUtil.format2(this.dt[2]);
            }
            case 15: {
                if (n3 > 0) {
                    return String.valueOf(DateUtil.format2(this.dt[3])) + ":" + DateUtil.format2(this.dt[4]) + ":" + DateUtil.format2(this.dt[5]) + "." + DateUtil.formatMilliSecond(this.dt[6], n3);
                }
                return String.valueOf(DateUtil.format2(this.dt[3])) + ":" + DateUtil.format2(this.dt[4]) + ":" + DateUtil.format2(this.dt[5]);
            }
            case 22: {
                if (n3 > 0) {
                    return String.valueOf(DateUtil.format2(this.dt[3])) + ":" + DateUtil.format2(this.dt[4]) + ":" + DateUtil.format2(this.dt[5]) + "." + DateUtil.formatMilliSecond(this.dt[6], n3) + " " + DateUtil.formatTZ(this.dt[7]);
                }
                return String.valueOf(DateUtil.format2(this.dt[3])) + ":" + DateUtil.format2(this.dt[4]) + ":" + DateUtil.format2(this.dt[5]) + " " + DateUtil.formatTZ(this.dt[7]);
            }
            case 16: {
                if (n3 > 0) {
                    return String.valueOf(DateUtil.formatYear(this.dt[0])) + "-" + DateUtil.format2(this.dt[1]) + "-" + DateUtil.format2(this.dt[2]) + " " + DateUtil.format2(this.dt[3]) + ":" + DateUtil.format2(this.dt[4]) + ":" + DateUtil.format2(this.dt[5]) + "." + DateUtil.formatMilliSecond(this.dt[6], n3);
                }
                return String.valueOf(DateUtil.formatYear(this.dt[0])) + "-" + DateUtil.format2(this.dt[1]) + "-" + DateUtil.format2(this.dt[2]) + " " + DateUtil.format2(this.dt[3]) + ":" + DateUtil.format2(this.dt[4]) + ":" + DateUtil.format2(this.dt[5]);
            }
            case 23: {
                if (n3 > 0) {
                    return String.valueOf(DateUtil.formatYear(this.dt[0])) + "-" + DateUtil.format2(this.dt[1]) + "-" + DateUtil.format2(this.dt[2]) + " " + DateUtil.format2(this.dt[3]) + ":" + DateUtil.format2(this.dt[4]) + ":" + DateUtil.format2(this.dt[5]) + "." + DateUtil.formatMilliSecond(this.dt[6], n3) + " " + DateUtil.formatTZ(this.dt[7]);
                }
                return String.valueOf(DateUtil.formatYear(this.dt[0])) + "-" + DateUtil.format2(this.dt[1]) + "-" + DateUtil.format2(this.dt[2]) + " " + DateUtil.format2(this.dt[3]) + ":" + DateUtil.format2(this.dt[4]) + ":" + DateUtil.format2(this.dt[5]) + " " + DateUtil.formatTZ(this.dt[7]);
            }
        }
        return "";
    }

    public String toString(Column column, a a2) {
        String string = a2.getFormat(column.type);
        if (StringUtil.isNotEmpty(string)) {
            return DateFormatOracle.format(this.dt, string, a2.getDateLanguage());
        }
        return this.toString(column.type, column.scale);
    }

    public Date toDate() {
        return this.toDate(null);
    }

    public Date toDate(Calendar calendar) {
        return new Date(this.getTime(calendar));
    }

    public Time toTime() {
        return this.toTime(null);
    }

    public Time toTime(Calendar calendar) {
        return new Time(this.getTime(calendar));
    }

    public Timestamp toTimestamp() {
        return this.toTimestamp(null);
    }

    public Timestamp toTimestamp(Calendar calendar) {
        Timestamp timestamp = new Timestamp(this.getTime(calendar));
        timestamp.setNanos(this.dt[6] * 1000);
        return timestamp;
    }

    public int[] decode(byte[] byArray, Column column, int n2, int n3) {
        this.dt = column.isBdta ? DmdbTimestamp.dmdtDecodeBdta(byArray) : DmdbTimestamp.dmdtDecodeFast(byArray);
        if (column.mask == 4) {
            this.dt = DmdbTimestamp.transformTZ(this.dt, n3, n2);
        }
        this.dt = DmdbTimestamp.roundHalfup(this.dt, column);
        this.dtype = column.type;
        this.scale = column.scale;
        return this.dt;
    }

    private static int[] dmdtDecodeFast(byte[] byArray) {
        int[] nArray = new int[8];
        nArray[7] = Integer.MIN_VALUE;
        if (byArray.length == 3) {
            nArray[0] = ByteUtil.getShort(byArray, 0) & Short.MAX_VALUE;
            if (nArray[0] > 9999) {
                nArray[0] = (short)((short)nArray[0] | 0x8000);
            }
            nArray[1] = (byArray[1] >> 7 & 1) + ((byArray[2] & 7) << 1);
            nArray[2] = (byArray[2] & 0xF8) >> 3 & 0x1F;
        } else if (byArray.length < 8) {
            nArray[3] = (short)(byArray[0] & 0x1F);
            nArray[4] = (short)((byArray[0] >> 5 & 7) + ((byArray[1] & 7) << 3));
            nArray[5] = (short)((byArray[1] >> 3 & 0x1F) + ((byArray[2] & 1) << 5));
            nArray[6] = (byArray[2] >> 1 & 0x7F) + ((byArray[3] & 0xFF) << 7) + ((byArray[4] & 0x1F) << 15);
            if (byArray.length > 5) {
                nArray[7] = ByteUtil.getShort(byArray, 5);
            }
        } else {
            nArray[0] = ByteUtil.getShort(byArray, 0) & Short.MAX_VALUE;
            if (nArray[0] > 9999) {
                nArray[0] = (short)((short)nArray[0] | 0x8000);
            }
            nArray[1] = (byArray[1] >> 7 & 1) + ((byArray[2] & 7) << 1);
            nArray[2] = (byArray[2] & 0xF8) >> 3 & 0x1F;
            nArray[3] = byArray[3] & 0x1F;
            nArray[4] = (byArray[3] >> 5 & 7) + ((byArray[4] & 7) << 3);
            nArray[5] = (byArray[4] >> 3 & 0x1F) + ((byArray[5] & 1) << 5);
            nArray[6] = (byArray[5] >> 1 & 0x7F) + ((byArray[6] & 0xFF) << 7) + ((byArray[7] & 0x1F) << 15);
            if (byArray.length > 8) {
                nArray[7] = ByteUtil.getShort(byArray, 8);
            }
        }
        return nArray;
    }

    private static int[] dmdtDecodeBdta(byte[] byArray) {
        int[] nArray = new int[]{ByteUtil.getShort(byArray, 0), (short)(byArray[2] & 0xFF), (short)(byArray[3] & 0xFF), (short)(byArray[4] & 0xFF), (short)(byArray[5] & 0xFF), (short)(byArray[6] & 0xFF), (byArray[7] & 0xFF) + (byArray[8] << 8) + (byArray[9] << 16), ByteUtil.getShort(byArray, 10)};
        return nArray;
    }

    public byte[] encode() {
        return this.encode(null, null);
    }

    public byte[] encode(Column column, a a2) {
        int[] nArray = this.dt;
        int n2 = this.dtype;
        if (column != null) {
            if (column.mask == 4) {
                nArray = DmdbTimestamp.transformTZ(nArray, a2.getLocalTimezone(), a2.getDBTimezone());
            }
            if (column.type != this.dtype || column.scale != this.scale) {
                nArray = DmdbTimestamp.roundHalfup(nArray, column);
            }
            n2 = column.type;
        }
        if (nArray[0] < -4712 || nArray[0] > 9999) {
            DBError.EC_DATETIME_OVERFLOW.throwz(new Object[0]);
        }
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = nArray[2];
        int n6 = nArray[3];
        int n7 = nArray[4];
        int n8 = nArray[5];
        int n9 = nArray[6];
        int n10 = nArray[7] == Integer.MIN_VALUE && a2 != null ? (int)a2.getLocalTimezone() : nArray[7];
        byte[] byArray = null;
        if (n2 == 14) {
            byArray = new byte[]{(byte)(n3 & 0xFF), n3 >= 0 ? (byte)(n3 >> 8 | (n4 & 1) << 7) : (byte)(n3 >> 8 & ((n4 & 1) << 7 | 0x7F)), (byte)((n4 & 0xE) >> 1 | n5 << 3)};
        } else if (n2 == 16) {
            byArray = new byte[]{(byte)(n3 & 0xFF), n3 >= 0 ? (byte)(n3 >> 8 | (n4 & 1) << 7) : (byte)(n3 >> 8 & ((n4 & 1) << 7 | 0x7F)), (byte)((n4 & 0xE) >> 1 | n5 << 3), (byte)(n6 | (n7 & 7) << 5), (byte)((n7 & 0x38) >> 3 | (n8 & 0x1F) << 3), (byte)((n8 & 0x20) >> 5 | (n9 & 0x7F) << 1), (byte)(n9 >> 7 & 0xFF), (byte)(n9 >> 15 & 0xFF)};
        } else if (n2 == 23) {
            byArray = new byte[10];
            byArray[0] = (byte)(n3 & 0xFF);
            byArray[1] = n3 >= 0 ? (byte)(n3 >> 8 | (n4 & 1) << 7) : (byte)(n3 >> 8 & ((n4 & 1) << 7 | 0x7F));
            byArray[2] = (byte)((n4 & 0xE) >> 1 | n5 << 3);
            byArray[3] = (byte)(n6 | (n7 & 7) << 5);
            byArray[4] = (byte)((n7 & 0x38) >> 3 | (n8 & 0x1F) << 3);
            byArray[5] = (byte)((n8 & 0x20) >> 5 | (n9 & 0x7F) << 1);
            byArray[6] = (byte)(n9 >> 7 & 0xFF);
            byArray[7] = (byte)(n9 >> 15 & 0xFF);
            ByteUtil.setShort(byArray, 8, (short)n10);
        } else if (n2 == 15) {
            byArray = new byte[]{(byte)(n6 | (n7 & 7) << 5), (byte)((n7 & 0x38) >> 3 | (n8 & 0x1F) << 3), (byte)((n8 & 0x20) >> 5 | (n9 & 0x7F) << 1), (byte)(n9 >> 7 & 0xFF), (byte)(n9 >> 15 & 0xFF)};
        } else if (n2 == 22) {
            byArray = new byte[7];
            byArray[0] = (byte)(n6 | (n7 & 7) << 5);
            byArray[1] = (byte)((n7 & 0x38) >> 3 | (n8 & 0x1F) << 3);
            byArray[2] = (byte)((n8 & 0x20) >> 5 | (n9 & 0x7F) << 1);
            byArray[3] = (byte)(n9 >> 7 & 0xFF);
            byArray[4] = (byte)(n9 >> 15 & 0xFF);
            ByteUtil.setShort(byArray, 5, (short)n10);
        }
        return byArray;
    }

    @Override
    public long getTime() {
        return this.getTime(null);
    }

    public long getTime(Calendar calendar) {
        if (calendar == null) {
            calendar = DmdbTimestamp.getCalendar();
        }
        int n2 = this.dt[0];
        int n3 = this.dt[1] - 1;
        int n4 = this.dt[2];
        if (n2 == 0 && n3 == -1 && n4 == 0) {
            n2 = 1970;
            n3 = 0;
            n4 = 1;
        }
        calendar.set(Math.abs(n2), n3, n4, this.dt[3], this.dt[4], this.dt[5]);
        calendar.set(14, this.dt[6] / 1000);
        calendar.set(0, this.dt[0] >= 0 ? 1 : 0);
        long l2 = calendar.getTimeInMillis();
        return l2;
    }

    @Override
    public void setTime(long l2) {
        this.setTime(l2, null);
    }

    public void setTime(long l2, Calendar calendar) {
        super.setTime(l2);
        long l3 = l2 / 1000L * 1000L;
        int n2 = (int)(l2 % 1000L * 1000000L);
        if (n2 < 0) {
            n2 += 1000000000;
            l3 = (l2 / 1000L - 1L) * 1000L;
        }
        if (calendar == null) {
            calendar = DmdbTimestamp.getCalendar();
        }
        calendar.setTimeInMillis(l3);
        this.dt[0] = calendar.get(0) == 1 ? calendar.get(1) : -calendar.get(1);
        this.dt[1] = calendar.get(2) + 1;
        this.dt[2] = calendar.get(5);
        this.dt[3] = calendar.get(11);
        this.dt[4] = calendar.get(12);
        this.dt[5] = calendar.get(13);
        this.dt[6] = n2 / 1000;
        this.dt[7] = Integer.MIN_VALUE;
    }

    @Override
    public int getNanos() {
        return this.dt[6] * 1000;
    }

    @Override
    public void setNanos(int n2) {
        super.setNanos(n2);
        this.dt[6] = n2 / 1000;
    }

    public int[] getDt() {
        return this.dt;
    }

    public int getTimezone() {
        return this.dt[7];
    }

    public void setTimezone(int n2) {
        if (n2 <= -780 || n2 > 840) {
            DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwz(new Object[0]);
        }
        this.dt[7] = n2;
    }

    public int parseString(String string) {
        try {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            boolean bl = false;
            int n12 = Integer.MIN_VALUE;
            String string6 = "000000000";
            if (string == null) {
                DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
            }
            if ((string = string.trim()).startsWith("-", 0)) {
                string = string.substring(1).trim();
                bl = true;
            }
            String[] stringArray = string.split(" ");
            switch (stringArray.length) {
                case 3: {
                    string2 = stringArray[0];
                    string3 = stringArray[1];
                    string5 = stringArray[2];
                    this.dtype = 23;
                    break;
                }
                case 2: {
                    if (stringArray[0].indexOf(":") > 0) {
                        string3 = stringArray[0];
                        string5 = stringArray[1];
                        this.dtype = 22;
                        break;
                    }
                    string2 = stringArray[0];
                    string3 = stringArray[1];
                    this.dtype = 16;
                    break;
                }
                case 1: {
                    if (stringArray[0].indexOf(":") > 0) {
                        string3 = stringArray[0];
                        this.dtype = 15;
                        break;
                    }
                    string2 = stringArray[0];
                    this.dtype = 14;
                    break;
                }
                default: {
                    DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
                }
            }
            if (string2 != null) {
                int n13 = string2.indexOf(45);
                int n14 = string2.indexOf(45, n13 + 1);
                if (n13 < 0 || n14 < 0) {
                    n13 = string.indexOf(46);
                    n14 = string.indexOf(46, n13 + 1);
                }
                if (n13 < 0 || n14 < 0) {
                    n13 = string.indexOf(47);
                    n14 = string.indexOf(47, n13 + 1);
                }
                if (n13 > 0 & n14 > 0 & n14 < string2.length() - 1) {
                    n2 = bl ? 0 - Integer.parseInt(string2.substring(0, n13)) - 1900 : Integer.parseInt(string2.substring(0, n13)) - 1900;
                    if (!DateUtil.checkDate(n2 + 1900, (n3 = Integer.parseInt(string2.substring(n13 + 1, n14)) - 1) + 1, n4 = Integer.parseInt(string2.substring(n14 + 1)))) {
                        DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
                    }
                } else {
                    DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
                }
            }
            if (string3 != null) {
                n9 = string3.indexOf(58);
                n10 = string3.indexOf(58, n9 + 1);
                n11 = string3.indexOf(46, n10 + 1);
                if (n9 > 0 & n10 > 0 & n10 < string3.length() - 1) {
                    n5 = Integer.parseInt(string3.substring(0, n9));
                    n6 = Integer.parseInt(string3.substring(n9 + 1, n10));
                    if (n11 > 0 & n11 < string3.length() - 1) {
                        n7 = Integer.parseInt(string3.substring(n10 + 1, n11));
                        string4 = string3.substring(n11 + 1);
                        if (string4.length() > 9) {
                            DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
                        }
                        if (!Character.isDigit(string4.charAt(0))) {
                            DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
                        }
                        string4 = String.valueOf(string4) + string6.substring(0, 9 - string4.length());
                        n8 = Integer.valueOf(string4.substring(0, 6));
                    } else if (n11 > 0) {
                        DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
                    } else {
                        n7 = Integer.parseInt(string3.substring(n10 + 1));
                    }
                    if (n5 >= 24 || n5 < 0 || n6 >= 60 || n6 < 0 || n7 >= 60 || n7 < 0) {
                        DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
                    }
                } else {
                    DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
                }
            }
            if (string5 != null) {
                boolean bl2 = false;
                if (string5.startsWith("-")) {
                    bl2 = true;
                }
                if (string5.startsWith("-") || string5.startsWith("+")) {
                    string5 = string5.substring(1).trim();
                }
                String[] stringArray2 = string5.split(":");
                short s2 = 0;
                int n15 = 0;
                switch (stringArray2.length) {
                    case 2: {
                        s2 = Short.parseShort(stringArray2[0].trim());
                        n15 = Short.parseShort(stringArray2[1].trim());
                        break;
                    }
                    case 1: {
                        s2 = Short.parseShort(stringArray2[0].trim());
                        break;
                    }
                    default: {
                        DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
                    }
                }
                n12 = (short)(s2 * 60 + n15);
                if (n12 < 0) {
                    DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
                }
                if (bl2) {
                    n12 *= -1;
                }
                if (n12 <= -780 || n12 > 840) {
                    DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
                }
            }
            this.dt[0] = n2 + 1900;
            this.dt[1] = n3 + 1;
            this.dt[2] = n4 == 0 ? 1 : n4;
            this.dt[3] = n5;
            this.dt[4] = n6;
            this.dt[5] = n7;
            this.dt[6] = n8;
            this.dt[7] = n12;
        }
        catch (Exception exception) {
            DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
        }
        this.scale = this.dtype == 14 ? 0 : 6;
        return this.dtype;
    }

    public static int[] transformTZ(int[] nArray, int n2, int n3) {
        int n4 = n2;
        if (nArray[7] != Integer.MIN_VALUE) {
            n4 = nArray[7];
        }
        if (n3 == n4) {
            return nArray;
        }
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        if ((nArray2 = DmdbTimestamp.addMinute(nArray2, n3 - n4))[7] != Integer.MIN_VALUE) {
            nArray2[7] = n3;
        }
        return nArray2;
    }

    private static int[] roundHalfup(int[] nArray, Column column) {
        switch (column.type) {
            case 15: 
            case 16: 
            case 22: 
            case 23: {
                if (column.scale >= 6) break;
                int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
                int n2 = nArray[6];
                int n3 = (int)Math.pow(10.0, 6 - column.scale);
                if ((n2 = Math.round(n2 / n3) * n3) >= 1000000) {
                    DmdbTimestamp.addSecond(nArray2, n2 / 1000000);
                    nArray2[6] = n2 % 1000000;
                } else {
                    nArray2[6] = n2;
                }
                return nArray2;
            }
        }
        return nArray;
    }

    public static int[] addSecond(int[] nArray, int n2) {
        int n3 = nArray[5] + n2;
        int n4 = n3 / 60;
        if ((n3 %= 60) < 0) {
            n3 += 60;
            --n4;
        }
        nArray[5] = n3;
        DmdbTimestamp.addMinute(nArray, n4);
        return nArray;
    }

    public static int[] addMinute(int[] nArray, int n2) {
        int n3 = nArray[4] + n2;
        int n4 = n3 / 60;
        if ((n3 %= 60) < 0) {
            n3 += 60;
            --n4;
        }
        nArray[4] = n3;
        DmdbTimestamp.addHour(nArray, n4);
        return nArray;
    }

    private static int[] addHour(int[] nArray, int n2) {
        int n3 = nArray[3] + n2;
        int n4 = n3 / 24;
        if ((n3 %= 24) < 0) {
            n3 += 24;
            --n4;
        }
        nArray[3] = n3;
        DmdbTimestamp.addDay(nArray, n4);
        return nArray;
    }

    private static int[] addDay(int[] nArray, int n2) {
        int n3 = nArray[2] + n2;
        int n4 = 0;
        while (n3 > (n4 = DateUtil.getDaysOfMonth(nArray[0], nArray[1])) || n3 <= 0) {
            DmdbTimestamp.addMonth(nArray, n3 > n4 ? 1 : -1);
            int n5 = n3 = n3 > n4 ? n3 - n4 : n3 + n4;
        }
        nArray[2] = n3;
        return nArray;
    }

    private static int[] addMonth(int[] nArray, int n2) {
        int n3;
        int n4 = nArray[1] + n2;
        int n5 = n4 / 12;
        if ((n4 %= 12) < 1) {
            n4 += 12;
            --n5;
        }
        if (nArray[2] > (n3 = DateUtil.getDaysOfMonth(nArray[0], n4))) {
            nArray[2] = n3;
        }
        nArray[1] = n4;
        DmdbTimestamp.addYear(nArray, n5);
        return nArray;
    }

    private static int[] addYear(int[] nArray, int n2) {
        nArray[0] = nArray[0] + n2;
        return nArray;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DmdbTimestamp)) {
            return false;
        }
        DmdbTimestamp dmdbTimestamp = (DmdbTimestamp)object;
        return dmdbTimestamp.dtype == this.dtype && dmdbTimestamp.scale == this.scale && Arrays.equals(this.dt, dmdbTimestamp.dt);
    }

    @Override
    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + this.dtype;
        n2 = 31 * n2 + this.scale;
        n2 = 31 * n2 + Arrays.hashCode(this.dt);
        return n2;
    }

    public static void main(String[] stringArray) {
        DmdbTimestamp dmdbTimestamp;
        DmdbTimestamp dmdbTimestamp2 = dmdbTimestamp = DmdbTimestamp.valueOf("2018-09-07 16:09:13.123456");
        System.out.println(dmdbTimestamp2);
    }

    public static /* bridge */ /* synthetic */ Timestamp valueOf(LocalDateTime localDateTime) {
        return DmdbTimestamp.valueOf(localDateTime);
    }

    public static /* bridge */ /* synthetic */ Timestamp valueOf(String string) {
        return DmdbTimestamp.valueOf(string);
    }
}

