/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;

class Row
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int m_colCnt;
    private Object[] m_colValue;
    private Object[] m_colChangedValue;
    private boolean[] m_colChanged;
    private boolean[] m_colOrigNull;
    private boolean m_rowUpdated;
    private boolean m_rowInserted;
    private int m_colInsertedCnt;
    private boolean m_rowDeleted;

    public Row(int n2) {
        this.m_colCnt = n2;
        this.m_colValue = new Object[n2];
        this.m_colChangedValue = new Object[n2];
        this.m_colChanged = new boolean[n2];
        this.m_colOrigNull = new boolean[n2];
        this.m_rowUpdated = false;
        this.m_rowInserted = false;
        this.m_colInsertedCnt = 0;
        this.m_rowDeleted = false;
    }

    public Row(int n2, boolean bl) {
        this(n2);
        this.m_rowInserted = bl;
    }

    public Row(int n2, Object[] objectArray) {
        this(n2);
        System.arraycopy(objectArray, 0, this.m_colValue, 0, n2);
    }

    public Object getColumn(int n2) {
        return this.m_colValue[n2];
    }

    public Object getChangedColumn(int n2) {
        return this.m_colChangedValue[n2];
    }

    public Object[] getOriginalRow() {
        return this.m_colValue;
    }

    public boolean isOriginalNull(int n2) {
        return this.m_colOrigNull[n2];
    }

    public boolean isOriginalWithNull() {
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.m_colCnt) {
            if (this.isOriginalNull(n2)) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    void setOriginalNull(int n2, boolean bl) {
        this.m_colOrigNull[n2] = bl;
    }

    public void setColumnValue(int n2, Object object) {
        this.m_colValue[n2] = object;
        if (this.m_rowInserted) {
            ++this.m_colInsertedCnt;
        }
    }

    public void updateColumnValue(int n2, Object object) {
        this.m_colChanged[n2] = true;
        this.m_colChangedValue[n2] = object;
        if (this.m_rowInserted) {
            ++this.m_colInsertedCnt;
        }
    }

    public boolean isColumnChanged(int n2) {
        return this.m_colChanged[n2];
    }

    public void insertRow() {
        System.arraycopy(this.m_colChangedValue, 0, this.m_colValue, 0, this.m_colCnt);
        this.m_colChanged = null;
        this.m_colChanged = new boolean[this.m_colCnt];
        this.m_colChangedValue = null;
        this.m_colChangedValue = new Object[this.m_colCnt];
        this.m_colInsertedCnt = 0;
    }

    public boolean isRowDeleted() {
        return this.m_rowDeleted;
    }

    public boolean isRowInserted() {
        return this.m_rowInserted;
    }

    public boolean isRowUpdated() {
        if (this.m_rowDeleted || this.m_rowInserted) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.m_colCnt) {
            if (this.m_colChanged[n2]) {
                return true;
            }
            ++n2;
        }
        return this.m_rowUpdated;
    }

    public void cancelRowDeletion() {
        this.m_rowDeleted = false;
    }

    public void cancelRowUpdates() {
        int n2 = 0;
        while (n2 < this.m_colCnt) {
            this.m_colChanged[n2] = false;
            ++n2;
        }
        this.m_colChangedValue = new Object[this.m_colCnt];
        this.m_colInsertedCnt = 0;
    }

    public void setRowUpdated(boolean bl) {
        this.m_rowUpdated = bl;
        if (!bl) {
            this.cancelRowUpdates();
        }
    }

    public void setRowDeleted(boolean bl) {
        this.m_rowDeleted = bl;
    }

    public void setRowInserted(boolean bl) {
        this.m_rowInserted = bl;
    }

    public boolean isRowFullyPopulated() {
        if (!this.m_rowInserted) {
            return false;
        }
        return this.m_colCnt == this.m_colInsertedCnt;
    }

    void setUpdatesOriginal() {
        int n2 = 0;
        while (n2 < this.m_colCnt) {
            if (this.m_colChanged[n2]) {
                this.m_colValue[n2] = this.m_colChangedValue[n2];
                this.m_colChangedValue[n2] = null;
                this.m_colChanged[n2] = false;
            }
            ++n2;
        }
        this.m_rowUpdated = false;
    }

    public Collection toCollection() {
        Vector<Object> vector = new Vector<Object>(this.m_colCnt);
        int n2 = 0;
        while (n2 < this.m_colCnt) {
            vector.add(this.isColumnChanged(n2) ? this.getChangedColumn(n2) : this.getColumn(n2));
            ++n2;
        }
        return vector;
    }

    public Row createCopy() {
        Row row = new Row(this.m_colCnt);
        System.arraycopy(this.m_colValue, 0, row.m_colValue, 0, this.m_colCnt);
        System.arraycopy(this.m_colChangedValue, 0, this.m_colChangedValue, 0, this.m_colCnt);
        System.arraycopy(this.m_colChanged, 0, row.m_colChanged, 0, this.m_colCnt);
        row.m_colInsertedCnt = this.m_colInsertedCnt;
        row.m_rowDeleted = this.m_rowDeleted;
        row.m_rowInserted = this.m_rowInserted;
        row.m_rowUpdated = this.m_rowUpdated;
        return row;
    }
}

