/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.AbstractLob;
import dm.jdbc.desc.Column;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbInputStream;
import dm.jdbc.driver.DmdbOutputStream;
import dm.jdbc.driver.DmdbReader;
import dm.jdbc.driver.DmdbWriter;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicLong;

public class DmdbClob
extends AbstractLob
implements Serializable,
Clob {
    public String data = "";
    public String serverEncoding = null;
    public static AtomicLong IDGenerator = new AtomicLong(0L);

    @Override
    public long getID() {
        if (this.ID < 0L) {
            this.ID = IDGenerator.incrementAndGet();
        }
        return this.ID;
    }

    protected DmdbClob(byte[] byArray, DmdbConnection dmdbConnection, Column column, boolean bl) {
        super(byArray, (byte)1, dmdbConnection, column);
        this.serverEncoding = dmdbConnection.getServerEncoding();
        if (this.storageType == 1) {
            int n2 = this.getHeadSize();
            this.data = ByteUtil.getString(byArray, n2, (int)this.bytesLength, this.serverEncoding);
            this.length = this.data.length();
        } else if (bl) {
            this.loadAllData();
        }
    }

    protected DmdbClob(String string, DmdbConnection dmdbConnection) {
        super((byte)0, dmdbConnection);
        this.serverEncoding = dmdbConnection.getServerEncoding();
        this.data = string;
        this.length = this.data.length();
    }

    public static DmdbClob newInstance(byte[] byArray, DmdbConnection dmdbConnection, Column column, boolean bl) {
        return new DmdbClob(byArray, dmdbConnection, column, bl);
    }

    public static DmdbClob newInstance(String string, DmdbConnection dmdbConnection) {
        return new DmdbClob(string, dmdbConnection);
    }

    public static DmdbClob getEmptyClob() {
        try {
            return new DmdbClob("", new DmdbConnection(null));
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public String do_getSubString(long l2, int n2) {
        long l3;
        this.checkFreed();
        if (l2 < 1L || n2 < 0) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        if ((l3 = this.do_length() - --l2) < 0L) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        n2 = (int)((long)n2 > l3 ? l3 : (long)n2);
        if (this.local || this.storageType == 1 || this.fetchAll) {
            if (l2 > this.do_length()) {
                DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
            }
            return this.data.substring((int)l2, (int)l2 + n2);
        }
        this.connection.checkClosed();
        return this.connection.dbAccess.a(this, (int)l2, n2);
    }

    public DmdbReader do_getCharacterStream() {
        this.checkFreed();
        return new DmdbReader(this);
    }

    public DmdbInputStream do_getAsciiStream() {
        this.checkFreed();
        return new DmdbInputStream(this, 2);
    }

    public DmdbInputStream do_getBinaryStream() {
        this.checkFreed();
        return new DmdbInputStream(this, 1);
    }

    public long do_position(String string, long l2) {
        long l3;
        this.checkFreed();
        if (l2 < 1L) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        if (StringUtil.isEmpty(string)) {
            return -1L;
        }
        if (this.local || this.storageType == 1 || this.fetchAll) {
            if ((long)string.length() > this.do_length() - l2 + 1L) {
                return -1L;
            }
            l3 = this.data.indexOf(string, (int)l2);
        } else {
            String string2 = this.do_getSubString(l2, (int)(this.do_length() - l2 + 1L));
            if (string2.length() < string.length()) {
                return -1L;
            }
            l3 = string2.indexOf(string);
        }
        if (l3 >= 0L) {
            ++l3;
        }
        return l3;
    }

    public long do_position(Clob clob, long l2) {
        return this.do_position(clob.getSubString(1L, (int)clob.length()), l2);
    }

    public int do_setString(long l2, String string, int n2, int n3) {
        this.checkFreed();
        if (l2 < 1L || n2 < 0 || n3 < 0 || n2 + n3 > string.length()) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        if (!this.updateable) {
            DBError.ECJDBC_RESULTSET_IS_READ_ONLY.throwz(new Object[0]);
        }
        string = string.substring(n2, n2 + n3);
        --l2;
        int n4 = 0;
        if (this.local || this.fetchAll) {
            if (l2 > this.do_length()) {
                DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
            }
            this.setLocalData((int)l2, string);
            n4 = string.length();
        } else {
            this.connection.checkClosed();
            int n5 = this.connection.dbAccess.a(this, l2, string, this.serverEncoding);
            if (this.storageType == 1) {
                this.setLocalData((int)l2, string);
            }
            n4 = n5;
        }
        this.modify = true;
        return n4;
    }

    public int do_setString(long l2, String string) {
        return this.do_setString(l2, string, 0, string.length());
    }

    public DmdbOutputStream do_setAsciiStream(long l2) {
        this.checkFreed();
        if (this.compatibleOracle && l2 == 0L) {
            l2 = 1L;
        }
        if (l2 < 1L) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        return new DmdbOutputStream(this, l2, 2);
    }

    public DmdbOutputStream getAsciiOutputStream() {
        return this.do_setAsciiStream(1L);
    }

    public DmdbOutputStream getAsciiOutputStream(long l2) {
        return this.do_setAsciiStream(l2);
    }

    public DmdbWriter do_setCharacterStream(long l2) {
        this.checkFreed();
        if (this.compatibleOracle && l2 == 0L) {
            l2 = 1L;
        }
        if (l2 < 1L) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        return new DmdbWriter(this, l2);
    }

    public void do_truncate(long l2) {
        this.checkFreed();
        if (l2 < 0L) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        if (!this.updateable) {
            DBError.ECJDBC_RESULTSET_IS_READ_ONLY.throwz(new Object[0]);
        }
        if (this.local || this.fetchAll) {
            if (l2 > this.do_length()) {
                return;
            }
            this.data = this.data.substring(0, (int)l2);
            this.length = this.data.length();
        } else {
            this.connection.checkClosed();
            this.length = this.connection.dbAccess.a(this, l2);
            if (this.storageType == 1) {
                this.data = this.data.substring(0, (int)this.length);
            }
        }
        this.modify = true;
    }

    @Override
    public void do_free() {
        super.do_free();
        this.data = null;
    }

    public DmdbReader do_getCharacterStream(long l2, long l3) {
        this.checkFreed();
        return new DmdbReader(this, l2, l3);
    }

    @Override
    protected void loadAllData() {
        this.checkFreed();
        if (this.local || this.storageType == 1 || this.fetchAll) {
            return;
        }
        this.data = this.do_getSubString(1L, (int)this.do_length());
        this.length = this.data.length();
        this.fetchAll = true;
    }

    private void setLocalData(int n2, String string) {
        this.data = (long)(n2 + string.length()) >= this.length ? String.valueOf(this.data.substring(0, n2)) + string : String.valueOf(this.data.substring(0, n2)) + string + this.data.substring(n2 + string.length(), this.data.length());
        this.length = this.data.length();
    }

    public byte[] getBytes(long l2, int n2) {
        String string = this.do_getSubString(l2, n2);
        return ByteUtil.fromString(string, this.serverEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_length();
            }
            return this.filterChain.reset().Clob_length(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSubString(long l2, int n2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getSubString(l2, n2);
            }
            return this.filterChain.reset().Clob_getSubString(this, l2, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getCharacterStream();
            }
            return this.filterChain.reset().Clob_getCharacterStream(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream() {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getAsciiStream();
            }
            return this.filterChain.reset().Clob_getAsciiStream(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(String string, long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_position(string, l2);
            }
            return this.filterChain.reset().Clob_position(this, string, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(Clob clob, long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_position(clob, l2);
            }
            return this.filterChain.reset().Clob_position(this, clob, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setString(long l2, String string) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_setString(l2, string);
            }
            return this.filterChain.reset().Clob_setString(this, l2, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setString(long l2, String string, int n2, int n3) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_setString(l2, string, n2, n3);
            }
            return this.filterChain.reset().Clob_setString(this, l2, string, n2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream setAsciiStream(long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_setAsciiStream(l2);
            }
            return this.filterChain.reset().Clob_setAsciiStream(this, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer setCharacterStream(long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_setCharacterStream(l2);
            }
            return this.filterChain.reset().Clob_setCharacterStream(this, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(long l2) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_truncate(l2);
            } else {
                this.filterChain.reset().Clob_truncate(this, l2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free() {
        if (this.connection == null) {
            return;
        }
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_free();
            } else {
                this.filterChain.reset().Clob_free(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(long l2, long l3) {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getCharacterStream(l2, l3);
            }
            return this.filterChain.reset().Clob_getCharacterStream(this, l2, l3);
        }
    }
}

