/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.convert.DB2J;
import dm.jdbc.desc.Column;
import dm.jdbc.desc.TypeData;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbArray;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbRef;
import dm.jdbc.driver.DmdbSQLXML;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class DmdbArrayDataResultSet
implements ResultSet {
    private DmdbArray m_array = null;
    private long m_startIndex = 1L;
    private int m_rowCount = 0;
    private int m_curRowNum = (int)(this.m_startIndex - 1L);
    private boolean m_isClosed = false;
    private boolean m_wasPrivColNull = false;
    private int m_direction = 1000;
    private int m_fetchSize = -1;
    private DmdbConnection m_conn = null;

    public DmdbArrayDataResultSet(DmdbArray dmdbArray) {
        this.m_array = dmdbArray;
        this.m_rowCount = this.m_array.m_arrData.length;
        this.m_startIndex = 1L;
        this.m_curRowNum = (int)(this.m_startIndex - 1L);
        this.m_conn = this.m_array.m_arrDesc.getItemDesc().m_conn;
    }

    public DmdbArrayDataResultSet(DmdbArray dmdbArray, long l2, int n2) {
        this(dmdbArray);
        this.m_startIndex = l2;
        this.m_rowCount = this.m_rowCount < n2 ? this.m_rowCount : n2;
        this.m_curRowNum = (int)(this.m_startIndex - 1L);
    }

    private void checkClose() {
        if (this.m_isClosed) {
            DBError.ECJDBC_RESULTSET_CLOSED.throwz(new Object[0]);
        }
    }

    private void checkCurrentRow() {
        this.checkClose();
        if ((long)this.m_curRowNum < this.m_startIndex && this.m_curRowNum > this.m_rowCount) {
            DBError.ECJDBC_CURSOR_NOT_IN_RESULTSET.throwz(new Object[0]);
        }
    }

    private boolean checkIsNull(TypeData typeData) {
        this.m_wasPrivColNull = typeData.m_dataBuf == null && typeData.m_dumyData == null;
        return this.m_wasPrivColNull;
    }

    private void release() {
        this.m_array = null;
        this.m_rowCount = 0;
        this.m_startIndex = 1L;
        this.m_isClosed = true;
    }

    private void checkUpdatable() {
        DBError.ECJDBC_RESULTSET_IS_READ_ONLY.throwz(new Object[0]);
    }

    @Override
    public boolean next() {
        this.checkClose();
        if (this.m_rowCount > this.m_curRowNum) {
            ++this.m_curRowNum;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        if (this.m_isClosed) {
            return;
        }
        this.release();
    }

    @Override
    public boolean wasNull() {
        return this.m_wasPrivColNull;
    }

    @Override
    public String getString(int n2) {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, n2, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof String) {
            return (String)typeData.m_dumyData;
        }
        Column column = this.m_array.getDataDesc(this.m_curRowNum, n2);
        return DB2J.toString(typeData.m_dataBuf, column, this.m_conn);
    }

    @Override
    public boolean getBoolean(int n2) {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, n2, null);
        if (this.checkIsNull(typeData)) {
            return false;
        }
        if (typeData.m_dumyData instanceof Boolean) {
            return (Boolean)typeData.m_dumyData;
        }
        Column column = this.m_array.getDataDesc(this.m_curRowNum, n2);
        return DB2J.toBoolean(typeData.m_dataBuf, column, this.m_conn);
    }

    @Override
    public byte getByte(int n2) {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, n2, null);
        if (this.checkIsNull(typeData)) {
            return 0;
        }
        if (typeData.m_dumyData instanceof Byte) {
            return (Byte)typeData.m_dumyData;
        }
        Column column = this.m_array.getDataDesc(this.m_curRowNum, n2);
        return DB2J.toByte(typeData.m_dataBuf, column, this.m_conn);
    }

    @Override
    public short getShort(int n2) {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, n2, null);
        if (this.checkIsNull(typeData)) {
            return 0;
        }
        if (typeData.m_dumyData instanceof Short) {
            return (Short)typeData.m_dumyData;
        }
        Column column = this.m_array.getDataDesc(this.m_curRowNum, n2);
        return DB2J.toShort(typeData.m_dataBuf, column, this.m_conn);
    }

    @Override
    public int getInt(int n2) {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, n2, null);
        if (this.checkIsNull(typeData)) {
            return 0;
        }
        if (typeData.m_dumyData instanceof Integer) {
            return (Integer)typeData.m_dumyData;
        }
        Column column = this.m_array.getDataDesc(this.m_curRowNum, n2);
        return DB2J.toInt(typeData.m_dataBuf, column, this.m_conn);
    }

    @Override
    public long getLong(int n2) {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, n2, null);
        if (this.checkIsNull(typeData)) {
            return 0L;
        }
        if (typeData.m_dumyData instanceof Long) {
            return (Long)typeData.m_dumyData;
        }
        Column column = this.m_array.getDataDesc(this.m_curRowNum, n2);
        return DB2J.toLong(typeData.m_dataBuf, column, this.m_conn);
    }

    @Override
    public float getFloat(int n2) {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, n2, null);
        if (this.checkIsNull(typeData)) {
            return 0.0f;
        }
        if (typeData.m_dumyData instanceof Float) {
            return ((Float)typeData.m_dumyData).longValue();
        }
        Column column = this.m_array.getDataDesc(this.m_curRowNum, n2);
        return DB2J.toFloat(typeData.m_dataBuf, column, this.m_conn);
    }

    @Override
    public double getDouble(int n2) {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, n2, null);
        if (this.checkIsNull(typeData)) {
            return 0.0;
        }
        if (typeData.m_dumyData instanceof Double) {
            return (Double)typeData.m_dumyData;
        }
        Column column = this.m_array.getDataDesc(this.m_curRowNum, n2);
        return DB2J.toDouble(typeData.m_dataBuf, column, this.m_conn);
    }

    @Override
    public BigDecimal getBigDecimal(int n2, int n3) {
        BigDecimal bigDecimal = this.getBigDecimal(n2);
        if (bigDecimal == null) {
            return null;
        }
        return bigDecimal.setScale(n3, 4);
    }

    @Override
    public byte[] getBytes(int n2) {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, n2, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof byte[]) {
            return (byte[])typeData.m_dumyData;
        }
        Column column = this.m_array.getDataDesc(this.m_curRowNum, n2);
        return DB2J.toBytes(typeData.m_dataBuf, column, this.m_conn);
    }

    @Override
    public Date getDate(int n2) {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, n2, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof Date) {
            return (Date)typeData.m_dumyData;
        }
        Column column = this.m_array.getDataDesc(this.m_curRowNum, n2);
        return DB2J.toDate(typeData.m_dataBuf, column, this.m_conn, null);
    }

    @Override
    public Time getTime(int n2) {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, n2, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof Time) {
            return (Time)typeData.m_dumyData;
        }
        Column column = this.m_array.getDataDesc(this.m_curRowNum, n2);
        return DB2J.toTime(typeData.m_dataBuf, column, this.m_conn, null);
    }

    @Override
    public Timestamp getTimestamp(int n2) {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, n2, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof Timestamp) {
            return (Timestamp)typeData.m_dumyData;
        }
        Column column = this.m_array.getDataDesc(this.m_curRowNum, n2);
        return DB2J.toTimestamp(typeData.m_dataBuf, column, this.m_conn, null);
    }

    @Override
    public InputStream getAsciiStream(int n2) {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, n2, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        Column column = this.m_array.getDataDesc(this.m_curRowNum, n2);
        return DB2J.toAsciiStream(typeData.m_dataBuf, column, this.m_conn);
    }

    @Override
    public InputStream getUnicodeStream(int n2) {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, n2, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        Column column = this.m_array.getDataDesc(this.m_curRowNum, n2);
        return DB2J.toUnicodeStream(typeData.m_dataBuf, column, this.m_conn);
    }

    @Override
    public InputStream getBinaryStream(int n2) {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, n2, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        Column column = this.m_array.getDataDesc(this.m_curRowNum, n2);
        return DB2J.toBinaryStream(typeData.m_dataBuf, column, this.m_conn);
    }

    @Override
    public String getString(String string) {
        return this.getString(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(String string) {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(String string) {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public short getShort(String string) {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public int getInt(String string) {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(String string) {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public float getFloat(String string) {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public double getDouble(String string) {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n2) {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public byte[] getBytes(String string) {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Date getDate(String string) {
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Time getTime(String string) {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(String string) {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(String string) {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    public InputStream getUnicodeStream(String string) {
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public InputStream getBinaryStream(String string) {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public SQLWarning getWarnings() {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public void clearWarnings() {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public String getCursorName() {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public ResultSetMetaData getMetaData() {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public Object getObject(int n2) {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, n2, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        return typeData.m_dumyData;
    }

    @Override
    public Object getObject(String string) {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public int findColumn(String string) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return 0;
    }

    @Override
    public Reader getCharacterStream(int n2) {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, n2, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        Column column = this.m_array.getDataDesc(this.m_curRowNum, n2);
        return DB2J.toCharacterStream(typeData.m_dataBuf, column, this.m_conn);
    }

    @Override
    public Reader getCharacterStream(String string) {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n2) {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, n2, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof BigDecimal) {
            return (BigDecimal)typeData.m_dumyData;
        }
        Column column = this.m_array.getDataDesc(this.m_curRowNum, n2);
        return DB2J.toBigDecimal(typeData.m_dataBuf, column, this.m_conn);
    }

    @Override
    public BigDecimal getBigDecimal(String string) {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public boolean isBeforeFirst() {
        return this.m_curRowNum + 1 <= 0;
    }

    @Override
    public boolean isAfterLast() {
        return this.m_curRowNum + 1 > this.m_rowCount;
    }

    @Override
    public boolean isFirst() {
        return this.m_curRowNum + 1 == 1;
    }

    @Override
    public boolean isLast() {
        return this.m_curRowNum + 1 == this.m_rowCount;
    }

    @Override
    public void beforeFirst() {
        this.checkClose();
        if (this.m_rowCount <= 0) {
            return;
        }
        this.m_curRowNum = -1;
    }

    @Override
    public void afterLast() {
        this.checkClose();
        if (this.m_rowCount <= 0) {
            return;
        }
        this.m_curRowNum = this.m_rowCount;
    }

    @Override
    public boolean first() {
        this.checkClose();
        if (this.m_rowCount > 0) {
            this.m_curRowNum = 0;
            return true;
        }
        return false;
    }

    @Override
    public boolean last() {
        this.checkClose();
        if (this.m_rowCount > 0) {
            this.m_curRowNum = this.m_rowCount - 1;
            return true;
        }
        return false;
    }

    @Override
    public int getRow() {
        return this.m_curRowNum + 1;
    }

    @Override
    public boolean absolute(int n2) {
        this.checkClose();
        if (Math.abs(n2) > this.m_rowCount || n2 == 0) {
            return false;
        }
        if (n2 < 0) {
            this.m_curRowNum = n2 + this.m_rowCount;
            return true;
        }
        this.m_curRowNum = n2 - 1;
        return true;
    }

    @Override
    public boolean relative(int n2) {
        this.checkClose();
        if (n2 == 0) {
            return !this.isBeforeFirst() && !this.isAfterLast();
        }
        int n3 = this.m_curRowNum + n2;
        if (n3 + 1 > this.m_rowCount || n3 + 1 < 1) {
            return false;
        }
        this.m_curRowNum = n3;
        return true;
    }

    @Override
    public boolean previous() {
        this.checkClose();
        int n2 = this.m_curRowNum - 1;
        if (n2 < 0 || n2 >= this.m_rowCount) {
            return false;
        }
        this.m_curRowNum = n2;
        return true;
    }

    @Override
    public void setFetchDirection(int n2) {
        this.m_direction = n2;
    }

    @Override
    public int getFetchDirection() {
        return this.m_direction;
    }

    @Override
    public void setFetchSize(int n2) {
        this.m_fetchSize = n2;
    }

    @Override
    public int getFetchSize() {
        return this.m_fetchSize;
    }

    @Override
    public int getType() {
        return 1003;
    }

    @Override
    public int getConcurrency() {
        return 1007;
    }

    @Override
    public boolean rowUpdated() {
        this.checkUpdatable();
        return false;
    }

    @Override
    public boolean rowInserted() {
        this.checkUpdatable();
        return false;
    }

    @Override
    public boolean rowDeleted() {
        this.checkUpdatable();
        return false;
    }

    @Override
    public void updateNull(int n2) {
        this.checkUpdatable();
    }

    @Override
    public void updateBoolean(int n2, boolean bl) {
        this.checkUpdatable();
    }

    @Override
    public void updateByte(int n2, byte by) {
        this.checkUpdatable();
    }

    @Override
    public void updateShort(int n2, short s2) {
        this.checkUpdatable();
    }

    @Override
    public void updateInt(int n2, int n3) {
        this.checkUpdatable();
    }

    @Override
    public void updateLong(int n2, long l2) {
        this.checkUpdatable();
    }

    @Override
    public void updateFloat(int n2, float f2) {
        this.checkUpdatable();
    }

    @Override
    public void updateDouble(int n2, double d2) {
        this.checkUpdatable();
    }

    @Override
    public void updateBigDecimal(int n2, BigDecimal bigDecimal) {
        this.checkUpdatable();
    }

    @Override
    public void updateString(int n2, String string) {
        this.checkUpdatable();
    }

    @Override
    public void updateBytes(int n2, byte[] byArray) {
        this.checkUpdatable();
    }

    @Override
    public void updateDate(int n2, Date date) {
        this.checkUpdatable();
    }

    @Override
    public void updateTime(int n2, Time time) {
        this.checkUpdatable();
    }

    @Override
    public void updateTimestamp(int n2, Timestamp timestamp) {
        this.checkUpdatable();
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, int n3) {
        this.checkUpdatable();
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, int n3) {
        this.checkUpdatable();
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, int n3) {
        this.checkUpdatable();
    }

    @Override
    public void updateObject(int n2, Object object, int n3) {
        this.checkUpdatable();
    }

    @Override
    public void updateObject(int n2, Object object) {
        this.checkUpdatable();
    }

    @Override
    public void updateNull(String string) {
        this.updateNull(this.findColumn(string));
    }

    @Override
    public void updateBoolean(String string, boolean bl) {
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public void updateByte(String string, byte by) {
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public void updateShort(String string, short s2) {
        this.updateShort(this.findColumn(string), s2);
    }

    @Override
    public void updateInt(String string, int n2) {
        this.updateInt(this.findColumn(string), n2);
    }

    @Override
    public void updateLong(String string, long l2) {
        this.updateLong(this.findColumn(string), l2);
    }

    @Override
    public void updateFloat(String string, float f2) {
        this.updateFloat(this.findColumn(string), f2);
    }

    @Override
    public void updateDouble(String string, double d2) {
        this.updateDouble(this.findColumn(string), d2);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateString(String string, String string2) {
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) {
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public void updateDate(String string, Date date) {
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public void updateTime(String string, Time time) {
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n2) {
        this.updateAsciiStream(this.findColumn(string), inputStream, n2);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n2) {
        this.updateBinaryStream(this.findColumn(string), inputStream, n2);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n2) {
        this.updateCharacterStream(this.findColumn(string), reader, n2);
    }

    @Override
    public void updateObject(String string, Object object, int n2) {
        this.updateObject(this.findColumn(string), object, n2);
    }

    @Override
    public void updateObject(String string, Object object) {
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public void insertRow() {
        this.checkUpdatable();
    }

    @Override
    public void updateRow() {
        this.checkUpdatable();
    }

    @Override
    public void deleteRow() {
        this.checkUpdatable();
    }

    @Override
    public void refreshRow() {
        this.checkUpdatable();
    }

    @Override
    public void cancelRowUpdates() {
        this.checkUpdatable();
    }

    @Override
    public void moveToInsertRow() {
        this.checkUpdatable();
    }

    @Override
    public void moveToCurrentRow() {
        this.checkUpdatable();
    }

    @Override
    public Statement getStatement() {
        this.checkUpdatable();
        return null;
    }

    public Object getObject(int n2, Map map) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public Ref getRef(int n2) {
        Object object = this.getObject(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof SQLData || object instanceof Struct) {
            DmdbRef dmdbRef = new DmdbRef(object);
            return dmdbRef;
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return null;
    }

    @Override
    public Blob getBlob(int n2) {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, n2, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof Blob) {
            return (Blob)typeData.m_dumyData;
        }
        Column column = this.m_array.getDataDesc(this.m_curRowNum, n2);
        return DB2J.toBlob(typeData.m_dataBuf, column, this.m_conn);
    }

    @Override
    public Clob getClob(int n2) {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, n2, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof Clob) {
            return (Clob)typeData.m_dumyData;
        }
        Column column = this.m_array.getDataDesc(this.m_curRowNum, n2);
        return DB2J.toClob(typeData.m_dataBuf, column, this.m_conn);
    }

    @Override
    public Array getArray(int n2) {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, n2, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof DmdbArray) {
            return (Array)typeData.m_dumyData;
        }
        Column column = this.m_array.getDataDesc(this.m_curRowNum, n2);
        return DB2J.toArray(typeData.m_dataBuf, column, this.m_conn);
    }

    public Object getObject(String string, Map map) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public Ref getRef(String string) {
        return this.getRef(this.findColumn(string));
    }

    @Override
    public Blob getBlob(String string) {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public Clob getClob(String string) {
        return this.getClob(this.findColumn(string));
    }

    @Override
    public Array getArray(String string) {
        return this.getArray(this.findColumn(string));
    }

    @Override
    public Date getDate(int n2, Calendar calendar) {
        Date date = this.getDate(n2);
        if (date == null) {
            return null;
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.clear();
        calendar.setTime(date);
        return new Date(calendar.getTimeInMillis());
    }

    @Override
    public Date getDate(String string, Calendar calendar) {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public Time getTime(int n2, Calendar calendar) {
        Time time = this.getTime(n2);
        if (time == null) {
            return null;
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.clear();
        calendar.setTimeInMillis(time.getTime());
        return new Time(calendar.getTimeInMillis());
    }

    @Override
    public Time getTime(String string, Calendar calendar) {
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) {
        Timestamp timestamp = this.getTimestamp(n2);
        if (timestamp == null) {
            return null;
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.clear();
        calendar.setTimeInMillis(timestamp.getTime());
        return new Timestamp(calendar.getTimeInMillis());
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public URL getURL(int n2) {
        String string = this.getString(n2);
        if (string == null) {
            return null;
        }
        try {
            return new URL(string);
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(exception);
            return null;
        }
    }

    @Override
    public URL getURL(String string) {
        return this.getURL(this.findColumn(string));
    }

    @Override
    public void updateRef(int n2, Ref ref) {
        this.checkUpdatable();
    }

    @Override
    public void updateRef(String string, Ref ref) {
        this.updateRef(this.findColumn(string), ref);
    }

    @Override
    public void updateBlob(int n2, Blob blob) {
        this.checkUpdatable();
    }

    @Override
    public void updateBlob(String string, Blob blob) {
        this.updateBlob(this.findColumn(string), blob);
    }

    @Override
    public void updateClob(int n2, Clob clob) {
        this.checkUpdatable();
    }

    @Override
    public void updateClob(String string, Clob clob) {
        this.updateClob(this.findColumn(string), clob);
    }

    @Override
    public void updateArray(int n2, Array array) {
        this.checkUpdatable();
    }

    @Override
    public void updateArray(String string, Array array) {
        this.updateArray(this.findColumn(string), array);
    }

    public Object unwrap(Class clazz) {
        return clazz.cast(this);
    }

    public boolean isWrapperFor(Class clazz) {
        return clazz.isInstance(this);
    }

    @Override
    public RowId getRowId(int n2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public RowId getRowId(String string) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public void updateRowId(int n2, RowId rowId) {
        this.checkUpdatable();
    }

    @Override
    public void updateRowId(String string, RowId rowId) {
        this.updateRowId(this.findColumn(string), rowId);
    }

    @Override
    public int getHoldability() {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return this.m_conn.resultSetHoldability;
    }

    @Override
    public boolean isClosed() {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return false;
    }

    @Override
    public void updateNString(int n2, String string) {
        this.updateString(n2, string);
    }

    @Override
    public void updateNString(String string, String string2) {
        this.updateString(string, string2);
    }

    @Override
    public void updateNClob(int n2, NClob nClob) {
        this.updateClob(n2, (Clob)nClob);
    }

    @Override
    public void updateNClob(String string, NClob nClob) {
        this.updateClob(string, (Clob)nClob);
    }

    @Override
    public NClob getNClob(int n2) {
        return (NClob)this.getClob(n2);
    }

    @Override
    public NClob getNClob(String string) {
        return (NClob)this.getClob(string);
    }

    @Override
    public SQLXML getSQLXML(int n2) {
        String string = this.getString(n2);
        DmdbSQLXML dmdbSQLXML = new DmdbSQLXML();
        dmdbSQLXML.setString(string);
        return dmdbSQLXML;
    }

    @Override
    public SQLXML getSQLXML(String string) {
        return this.getSQLXML(this.findColumn(string));
    }

    @Override
    public void updateSQLXML(int n2, SQLXML sQLXML) {
        this.checkUpdatable();
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) {
        this.updateSQLXML(this.findColumn(string), sQLXML);
    }

    @Override
    public String getNString(int n2) {
        return this.getString(n2);
    }

    @Override
    public String getNString(String string) {
        return this.getString(string);
    }

    @Override
    public Reader getNCharacterStream(int n2) {
        return this.getCharacterStream(n2);
    }

    @Override
    public Reader getNCharacterStream(String string) {
        return this.getCharacterStream(string);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader, long l2) {
        this.updateCharacterStream(n2, reader, l2);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l2) {
        this.updateCharacterStream(string, reader, l2);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, long l2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, long l2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, long l2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream, long l2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateClob(int n2, Reader reader, long l2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateClob(String string, Reader reader, long l2) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateNClob(int n2, Reader reader, long l2) {
        this.updateClob(n2, reader, l2);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l2) {
        this.updateClob(string, reader, l2);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader) {
        this.updateCharacterStream(n2, reader);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) {
        this.updateCharacterStream(string, reader);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateClob(int n2, Reader reader) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateClob(String string, Reader reader) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateNClob(int n2, Reader reader) {
        this.updateClob(n2, reader);
    }

    @Override
    public void updateNClob(String string, Reader reader) {
        this.updateClob(string, reader);
    }

    public Object getObject(int n2, Class clazz) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    public Object getObject(String string, Class clazz) {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }
}

