/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.trace.properties;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartRequest;

@ConfigurationProperties(prefix="hussar.log.trace")
public class TraceProperties {
    private boolean enabledParamsPrint = false;
    private List<Class<?>> excludeParamClasses = new ArrayList();
    private static List<Class<?>> defaultParamClasses = new ArrayList();

    public boolean isEnabledParamsPrint() {
        return this.enabledParamsPrint;
    }

    public void setEnabledParamsPrint(boolean enabledParamsPrint) {
        this.enabledParamsPrint = enabledParamsPrint;
    }

    public List<Class<?>> getExcludeParamClasses() {
        ArrayList excludeParamClassList = new ArrayList();
        excludeParamClassList.addAll(defaultParamClasses);
        if (!HussarUtils.isEmpty(this.excludeParamClasses)) {
            excludeParamClassList.addAll(this.excludeParamClasses);
        }
        return excludeParamClassList.stream().distinct().collect(Collectors.toList());
    }

    public void setExcludeParamClasses(List<Class<?>> excludeParamClasses) {
        this.excludeParamClasses = excludeParamClasses;
    }

    public boolean validExcludeParamClass(Class<?> subClz) {
        List<Class<?>> paramClasses = this.getExcludeParamClasses();
        if (HussarUtils.isEmpty(paramClasses)) {
            return false;
        }
        boolean anyMatch = paramClasses.stream().anyMatch(clz -> clz.isAssignableFrom(subClz));
        return anyMatch;
    }

    static {
        defaultParamClasses.add(HttpServletRequest.class);
        defaultParamClasses.add(HttpServletResponse.class);
        defaultParamClasses.add(MultipartRequest.class);
        defaultParamClasses.add(MultipartFile.class);
    }
}

