/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.trace.utils;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class IpUtils {
    public static final String UN_KNOWN = "unknown";
    public static final String LOCAL_IP = "127.0.0.1";
    public static final String LOCAL_IP_V6 = "0:0:0:0:0:0:0:1";

    public static boolean ipCheck(String text) {
        if (text != null && !text.isEmpty()) {
            String regex = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$";
            return text.matches(regex);
        }
        return false;
    }

    public static String getIp(HttpServletRequest request) {
        String ip = request.getHeader("X-Real-IP");
        if (StringUtils.isBlank((CharSequence)ip) || UN_KNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Requested-For");
        }
        if (StringUtils.isBlank((CharSequence)ip) || UN_KNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Forwarded-For");
        }
        if (StringUtils.isBlank((CharSequence)ip) || UN_KNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || UN_KNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || UN_KNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || UN_KNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (StringUtils.isBlank((CharSequence)ip) || UN_KNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        String string = ip = StringUtils.isBlank((CharSequence)ip) ? null : ip.split(",")[0];
        return LOCAL_IP_V6.equals(ip) ? LOCAL_IP : (IpUtils.ipCheck(ip) ? ip : UN_KNOWN);
    }
}

