/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.trace.aspect;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.support.service.GetLoginUserService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.log.core.LogMessageThreadLocal;
import com.jxdinfo.hussar.support.log.core.TraceId;
import com.jxdinfo.hussar.support.log.core.TraceMessage;
import com.jxdinfo.hussar.support.log.core.util.GfJsonUtil;
import com.jxdinfo.hussar.support.log.trace.utils.IpUtils;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class AbstractLogTraceAspect {
    private static final Logger log = LoggerFactory.getLogger(AbstractLogTraceAspect.class);

    public Object aroundExecute(MethodInvocation invocation, GetLoginUserService getLoginUserService) throws Throwable {
        TraceMessage traceMessage = (TraceMessage)LogMessageThreadLocal.logMessageThreadLocal.get();
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String traceId = (String)TraceId.logTraceID.get();
        if (traceMessage == null || traceId == null) {
            traceMessage = new TraceMessage();
            traceMessage.getPositionNum().set(0);
        }
        traceMessage.setTraceId(traceId);
        String methodName = invocation.getMethod().toString();
        traceMessage.setMessageType(methodName);
        traceMessage.setPosition("<");
        traceMessage.getPositionNum().incrementAndGet();
        traceMessage.setClientIp(IpUtils.getIp(request));
        LogMessageThreadLocal.logMessageThreadLocal.set((Object)traceMessage);
        log.info("TRACE:" + GfJsonUtil.toJSONString((Object)traceMessage));
        if (AnnotatedElementUtils.hasAnnotation(invocation.getThis().getClass(), Controller.class)) {
            if (HussarUtils.isNotEmpty((Object)getLoginUserService) && HussarUtils.isNotEmpty((Object)getLoginUserService.getCurrentUserDetail()) && HussarUtils.isNotEmpty((Object)getLoginUserService.getCurrentUserDetail().getUserName())) {
                log.info("\u8bf7\u6c42\u8def\u5f84:{},\u5f53\u524d\u64cd\u4f5c\u4eba\uff1a{}\uff0c\u65b9\u6cd5\u540d\uff1a{}", new Object[]{request.getRequestURI(), getLoginUserService.getCurrentUserDetail().getUserName(), methodName});
            } else {
                log.info("\u8bf7\u6c42\u8def\u5f84:{},\u65b9\u6cd5\u540d\uff1a{}", (Object)request.getRequestURI(), (Object)methodName);
            }
        }
        try {
            Object proceed = invocation.proceed();
            if (proceed instanceof ApiResponse) {
                ApiResponse apiResponse = (ApiResponse)proceed;
                traceMessage.setMessageType(methodName);
                traceMessage.setPosition(">");
                traceMessage.getPositionNum().incrementAndGet();
                if (apiResponse.getCode() == ResultCode.SUCCESS.getCode()) {
                    log.info("\u8bf7\u6c42\u8def\u5f84\uff1a{}\u6210\u529f,\u8fd4\u56de\u7ed3\u679c[{}]", (Object)request.getRequestURI(), proceed);
                } else {
                    log.error("\u8bf7\u6c42\u8def\u5f84\uff1a{}\u5931\u8d25,\u5f02\u5e38\u7801[{}]\u4fe1\u606f[{}]", new Object[]{request.getRequestURI(), apiResponse.getCode(), apiResponse.getMsg()});
                }
            }
            log.info("TRACE:" + GfJsonUtil.toJSONString((Object)traceMessage));
            return proceed;
        }
        catch (Exception e) {
            traceMessage.setMessageType(methodName);
            traceMessage.setPosition(">");
            traceMessage.getPositionNum().incrementAndGet();
            log.info("TRACE:" + GfJsonUtil.toJSONString((Object)traceMessage));
            throw e;
        }
    }
}

