/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.collect;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.support.log.InitConfig;
import com.jxdinfo.hussar.support.log.client.ElasticLowerClient;
import com.jxdinfo.hussar.support.log.collect.BaseLogCollect;
import com.jxdinfo.hussar.support.log.core.AbstractClient;
import com.jxdinfo.hussar.support.log.core.dto.RunLogCompressMessage;
import com.jxdinfo.hussar.support.log.core.exception.LogQueueConnectException;
import com.jxdinfo.hussar.support.log.core.util.GfJsonUtil;
import com.jxdinfo.hussar.support.log.core.util.LZ4Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class CacheLogCollect
extends BaseLogCollect {
    private final Logger logger = LoggerFactory.getLogger(CacheLogCollect.class);
    private final AbstractClient client;
    private final boolean compressor;
    private final String RUN_THREAD = "run";
    private final String TRACE_THREAD = "trace";

    public CacheLogCollect(ElasticLowerClient elasticLowerClient, AbstractClient client, ApplicationEventPublisher applicationEventPublisher, boolean compressor) {
        this.elasticLowerClient = elasticLowerClient;
        this.client = client;
        this.applicationEventPublisher = applicationEventPublisher;
        this.compressor = compressor;
    }

    public void cacheStart() {
        HashMap<String, Thread> map = new HashMap<String, Thread>();
        map.put("run", this.startRunLogThread());
        map.put("trace", this.startTraceLogThread());
        this.scheduledThreadPoolExecutor.scheduleWithFixedDelay(() -> {
            Thread runLog = (Thread)map.get("run");
            try {
                boolean runLogThreadAlive = runLog.isAlive();
                if (!runLogThreadAlive) {
                    throw new NullPointerException("runLogThread alive false");
                }
            }
            catch (Exception ex) {
                System.out.println("runLogThread \u91cd\u542f\u7ebf\u7a0b");
                runLog = this.startRunLogThread();
                map.put("run", runLog);
            }
            Thread traceLog = (Thread)map.get("trace");
            try {
                boolean traceLogThreadAlive = traceLog.isAlive();
                if (!traceLogThreadAlive) {
                    throw new NullPointerException("traceLogThread alive false");
                }
            }
            catch (Exception ex) {
                this.logger.warn("traceLogThread \u91cd\u542f\u7ebf\u7a0b");
                traceLog = this.startTraceLogThread();
                map.put("trace", traceLog);
            }
        }, 10L, 30L, TimeUnit.SECONDS);
        this.logger.info("CacheLogCollect is starting!");
    }

    private Thread startRunLogThread() {
        Thread runLogThread = new Thread(() -> this.collectRunningLog(this.compressor ? "hussar_log_list_compress" : "hussar_log_list"));
        runLogThread.start();
        return runLogThread;
    }

    private Thread startTraceLogThread() {
        Thread traceLogThread = new Thread(() -> this.collectTraceLog(this.compressor ? "hussar_log_trace_list_compress" : "hussar_log_trace_list"));
        traceLogThread.start();
        return traceLogThread;
    }

    private void collectRunningLog(String logKey) {
        while (true) {
            List<String> logs = new ArrayList(InitConfig.MAX_SEND_SIZE);
            try {
                Thread.sleep(InitConfig.MAX_INTERVAL);
            }
            catch (InterruptedException e) {
                this.logger.error("", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            try {
                long startTime = System.currentTimeMillis();
                logs = this.client.getMessage(logKey, InitConfig.MAX_SEND_SIZE);
                int size = logs.size();
                long endTime = System.currentTimeMillis();
                if (size <= 0) continue;
                this.logger.debug("RunLog\u65e5\u5fd7\u83b7\u53d6\u8017\u65f6\uff1a{} \u65e5\u5fd7\u6761\u6570\uff1a{}", (Object)(endTime - startTime), (Object)size);
                if (this.logger.isDebugEnabled()) {
                    logs.forEach(log -> this.logger.debug(log));
                }
                logs = this.decompressor(logs);
                super.sendLog(super.getRunLogIndex(), logs);
                this.publisherMonitorEvent(logs);
                continue;
            }
            catch (LogQueueConnectException e) {
                this.logger.error("\u4ece\u7f13\u5b58\u961f\u5217\u62c9\u53d6\u65e5\u5fd7\u5931\u8d25\uff01", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void collectTraceLog(String logKey) {
        while (true) {
            List<String> logs = new ArrayList(InitConfig.MAX_SEND_SIZE);
            try {
                Thread.sleep(InitConfig.MAX_INTERVAL);
            }
            catch (InterruptedException e) {
                this.logger.error("", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            try {
                long startTime = System.currentTimeMillis();
                logs = this.client.getMessage(logKey, InitConfig.MAX_SEND_SIZE);
                long endTime = System.currentTimeMillis();
                int size = logs.size();
                if (size <= 0) continue;
                this.logger.debug("TraceLog\u65e5\u5fd7\u83b7\u53d6\u8017\u65f6\uff1a{} \u65e5\u5fd7\u6761\u6570\uff1a{}", (Object)(endTime - startTime), (Object)size);
                if (this.logger.isDebugEnabled()) {
                    logs.forEach(log -> this.logger.debug(log));
                }
                logs = this.decompressor(logs);
                super.sendTraceLogList(super.getTraceLogIndex(), logs);
                continue;
            }
            catch (LogQueueConnectException e) {
                this.logger.error("\u4ece\u7f13\u5b58\u961f\u5217\u62c9\u53d6\u65e5\u5fd7\u5931\u8d25\uff01", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private List<String> decompressor(List<String> logs) {
        if (!this.compressor) {
            return logs;
        }
        int size = logs.size();
        ArrayList<String> list = new ArrayList<String>();
        if (logs != null && logs.size() > 0) {
            for (int i = 0; i < logs.size(); ++i) {
                String r = logs.get(i);
                try {
                    RunLogCompressMessage message = (RunLogCompressMessage)JSON.parseObject((String)r, RunLogCompressMessage.class);
                    byte[] bytes = LZ4Util.decompressorByte((byte[])message.getBody(), (int)message.getLength());
                    String json = new String(bytes);
                    list.addAll(GfJsonUtil.parseArray((String)json, String.class));
                    continue;
                }
                catch (Exception e) {
                    this.logger.error("\u89e3\u6790\u65e5\u5fd7\u5931\u8d25\uff01", (Throwable)e);
                }
            }
        }
        return list;
    }
}

