/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log;

import com.jxdinfo.hussar.support.log.InitConfig;
import com.jxdinfo.hussar.support.log.client.ElasticLowerClient;
import com.jxdinfo.hussar.support.log.collect.CacheLogCollect;
import com.jxdinfo.hussar.support.log.collect.MqLogCollect;
import com.jxdinfo.hussar.support.log.core.AbstractClient;
import com.jxdinfo.hussar.support.log.core.support.properties.LogProperties;
import com.jxdinfo.hussar.support.log.util.IndexUtil;
import com.jxdinfo.hussar.support.mq.HussarMQManager;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;

public class CollectStartBean
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(CollectStartBean.class);
    @Autowired
    private ElasticLowerClient elasticLowerClient;
    @Autowired(required=false)
    private AbstractClient cacheClient;
    @Autowired(required=false)
    private HussarMQManager hussarMQManager;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Autowired(required=false)
    private LogProperties logProperties;
    @Value(value="${hussar.log.redis.compressor:false}")
    private Boolean compressor;

    private void serverStart() {
        LogProperties.Mode mode = Optional.ofNullable(this.logProperties).map(LogProperties::getMode).orElse(LogProperties.Mode.CACHE);
        if (mode == LogProperties.Mode.CACHE) {
            CacheLogCollect logCollect = new CacheLogCollect(this.elasticLowerClient, this.cacheClient, this.applicationEventPublisher, this.compressor);
            logCollect.cacheStart();
        } else if (mode == LogProperties.Mode.MQ) {
            MqLogCollect mqLogCollect = new MqLogCollect(this.elasticLowerClient, this.applicationEventPublisher, this.hussarMQManager);
            mqLogCollect.mqStart();
        } else {
            throw new IllegalStateException("Unsupported log mode: " + mode);
        }
    }

    public void afterPropertiesSet() {
        try {
            this.autoCreatIndice();
            this.serverStart();
        }
        catch (Exception e) {
            logger.error("hussarlog server starting failed!", (Throwable)e);
        }
    }

    private void autoCreatIndice() {
        long epochMillis = System.currentTimeMillis();
        String runLogIndex = IndexUtil.getRunLogIndex(epochMillis);
        String traceLogIndex = IndexUtil.getTraceLogIndex(epochMillis);
        if ("day".equals(InitConfig.ES_INDEX_MODEL)) {
            this.creatIndiceLog(runLogIndex);
            this.creatIndiceTrace(traceLogIndex);
        } else {
            for (int a = 0; a < 24; ++a) {
                String hour = String.format("%02d", a);
                this.creatIndiceLog(runLogIndex + hour);
                this.creatIndiceTrace(traceLogIndex + hour);
            }
        }
    }

    private void creatIndiceLog(String index) {
        if (!this.elasticLowerClient.existIndice(index)) {
            this.elasticLowerClient.creatIndice(index);
        }
    }

    private void creatIndiceTrace(String index) {
        if (!this.elasticLowerClient.existIndice(index)) {
            this.elasticLowerClient.creatIndiceTrace(index);
        }
    }
}

