/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.log.core.support.vo.WarnClientVo;
import com.jxdinfo.hussar.support.log.enums.WarnClientEnum;
import com.jxdinfo.hussar.support.log.rule.entity.LogWarnRule;
import com.jxdinfo.hussar.support.log.rule.service.LogWarnRuleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="logWarnRule", tags={"\u65e5\u5fd7\u544a\u8b66\u89c4\u5219"})
@RequestMapping(value={"/logWarnRule"})
@RestController
@AuditLog(moduleName="\u65e5\u5fd7\u544a\u8b66\u89c4\u5219")
public class LogWarnRuleController {
    @Autowired
    private LogWarnRuleService logWarnRuleService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u65e5\u5fd7\u544a\u8b66\u89c4\u5219", notes="\u5206\u9875\u67e5\u8be2\u65e5\u5fd7\u544a\u8b66\u89c4\u5219")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="logWarnRule", value="\u544a\u8b66\u89c4\u5219\u5b9e\u4f53", required=true, paramType="query")})
    @GetMapping(value={"/list"})
    @AuditLog(eventDesc="\u5206\u9875\u67e5\u8be2\u65e5\u5fd7\u544a\u8b66\u89c4\u5219", evnetType=AuditEventType.QUERY, eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE)
    public ApiResponse<Page<LogWarnRule>> getList(Page<LogWarnRule> page, LogWarnRule logWarnRule) {
        return ApiResponse.success(this.logWarnRuleService.getWarnRulePage(page, logWarnRule));
    }

    @ApiOperation(value="\u4fdd\u5b58\u65e5\u5fd7\u544a\u8b66\u89c4\u5219", notes="\u4fdd\u5b58\u65e5\u5fd7\u544a\u8b66\u89c4\u5219")
    @PostMapping(value={"/save"})
    @AuditLog(eventDesc="\u4fdd\u5b58\u65e5\u5fd7\u544a\u8b66\u89c4\u5219", evnetType=AuditEventType.INSERT, eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE)
    public ApiResponse<Boolean> saveLogWarnRule(@ApiParam(value="\u5f85\u4fdd\u5b58\u65e5\u5fd7\u544a\u8b66\u89c4\u5219") @RequestBody LogWarnRule logWarnRule) {
        return ApiResponse.success((Object)this.logWarnRuleService.saveWarnRule(logWarnRule));
    }

    @ApiOperation(value="\u5220\u9664\u65e5\u5fd7\u544a\u8b66\u89c4\u5219", notes="\u5220\u9664\u65e5\u5fd7\u544a\u8b66\u89c4\u5219")
    @PostMapping(value={"/delete"})
    @AuditLog(eventDesc="\u5220\u9664\u65e5\u5fd7\u544a\u8b66\u89c4\u5219", evnetType=AuditEventType.DELETE, eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE)
    public ApiResponse<Boolean> deleteLogWarnRule(@ApiParam(value="\u89c4\u5219id") @RequestBody Long ruleId) {
        return ApiResponse.success((Object)this.logWarnRuleService.deleteWarnRule(ruleId));
    }

    @ApiOperation(value="\u83b7\u53d6\u544a\u8b66\u5e73\u53f0", notes="\u83b7\u53d6\u544a\u8b66\u5e73\u53f0")
    @GetMapping(value={"/getWarnClients"})
    @AuditLog(eventDesc="\u83b7\u53d6\u544a\u8b66\u5e73\u53f0", evnetType=AuditEventType.QUERY, eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE)
    public ApiResponse<List<WarnClientVo>> getWarnClients() {
        return ApiResponse.success(WarnClientEnum.getClientMaps());
    }

    @ApiOperation(value="\u83b7\u53d6\u65e5\u5fd7\u544a\u8b66\u89c4\u5219\u8be6\u60c5", notes="\u83b7\u53d6\u65e5\u5fd7\u544a\u8b66\u89c4\u5219\u8be6\u60c5")
    @GetMapping(value={"/getDetail"})
    @AuditLog(eventDesc="\u83b7\u53d6\u65e5\u5fd7\u544a\u8b66\u89c4\u5219\u8be6\u60c5", evnetType=AuditEventType.QUERY, eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE)
    public ApiResponse<LogWarnRule> getDetails(@ApiParam(value="\u89c4\u5219id") Long ruleId) {
        if (HussarUtils.isEmpty((Object)ruleId)) {
            throw new HussarException("\u65e5\u5fd7\u544a\u8b66\u89c4\u5219id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ApiResponse.success((Object)this.logWarnRuleService.getById(ruleId));
    }
}

