/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.client;

import com.jxdinfo.hussar.support.log.CollectStartBean;
import com.jxdinfo.hussar.support.log.InitConfig;
import com.jxdinfo.hussar.support.log.client.ElasticLowerClient;
import com.jxdinfo.hussar.support.log.controller.AutoDeleteLogs;
import com.jxdinfo.hussar.support.log.core.AbstractClient;
import com.jxdinfo.hussar.support.log.core.cache.CacheClient;
import com.jxdinfo.hussar.support.log.core.support.properties.LogProperties;
import com.jxdinfo.hussar.support.log.properties.LogEsProperties;
import java.time.ZoneId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;

@Configuration
@Order(value=1)
@ConditionalOnProperty(prefix="hussar.log", value={"enable"}, havingValue="true")
public class ClientConfig
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(CollectStartBean.class);
    @Autowired
    private final LogProperties logProperties;
    @Autowired
    private final LogEsProperties logEsProperties;

    public ClientConfig(LogProperties logProperties, LogEsProperties logEsProperties) {
        this.logProperties = logProperties;
        this.logEsProperties = logEsProperties;
    }

    @Bean(value={"cacheClient"})
    public AbstractClient initCacheClient() {
        return new CacheClient();
    }

    @Bean
    public AutoDeleteLogs autoDeleteLogs() {
        return new AutoDeleteLogs();
    }

    @Bean
    public ElasticLowerClient initElasticLowerClient() {
        String esHosts = this.logEsProperties.getHosts();
        if (StringUtils.isEmpty((Object)esHosts)) {
            logger.error("can not find esHosts config ! please check the application.properties(hussar.log.es.esHosts) ");
            return null;
        }
        ElasticLowerClient elasticLowerClient = ElasticLowerClient.getInstance(esHosts, this.logEsProperties.getUserName(), this.logEsProperties.getPassword(), this.logEsProperties.isTrustSelfSigned(), this.logEsProperties.isHostnameVerification());
        String esVersion = elasticLowerClient.getVersion();
        logger.info("es \u521d\u59cb\u5316\u6210\u529f\uff01Elastic \u7248\u672c\uff1a{}", (Object)esVersion);
        return elasticLowerClient;
    }

    private void loadConfig() {
        InitConfig.MAX_SEND_SIZE = this.logProperties.getMaxSendSize();
        InitConfig.MAX_INTERVAL = this.logProperties.getInterval();
        InitConfig.ES_INDEX_SHARDS = this.logEsProperties.getShards();
        InitConfig.ES_INDEX_REPLICAS = this.logEsProperties.getReplicas();
        InitConfig.ES_REFRESH_INTERVAL = this.logEsProperties.getRefreshInterval();
        InitConfig.ES_INDEX_MODEL = this.logEsProperties.getIndexModel();
        String zoneId = this.logEsProperties.getIndexZoneId();
        try {
            ZoneId.of(zoneId);
            InitConfig.ES_INDEX_ZONE_ID = zoneId;
        }
        catch (Exception e) {
            logger.error("Please check config 'hussar.log.es.index-zoneId', the value '{}' is invalid, use default value '{}'!", (Object)zoneId, (Object)InitConfig.ES_INDEX_ZONE_ID);
        }
        InitConfig.keepDays = this.logProperties.getLogKeepDays();
        InitConfig.traceKeepDays = this.logProperties.getTraceKeepDays();
        InitConfig.MAX_RESULT = this.logEsProperties.getMaxResult();
        logger.info("maxSendSize:" + InitConfig.MAX_SEND_SIZE);
        logger.info("interval:" + InitConfig.MAX_INTERVAL);
    }

    public void afterPropertiesSet() throws Exception {
        try {
            this.loadConfig();
            logger.info("load config success!");
        }
        catch (Exception e) {
            logger.error("hussarlog load config success failed!", (Throwable)e);
        }
    }
}

