/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.monitor;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.log.client.ElasticLowerClient;
import com.jxdinfo.hussar.support.log.core.AbstractClient;
import com.jxdinfo.hussar.support.log.core.dto.RunLogMessage;
import com.jxdinfo.hussar.support.log.core.support.dto.LogMonitorTextMessage;
import com.jxdinfo.hussar.support.log.core.support.properties.LogProperties;
import com.jxdinfo.hussar.support.log.monitor.LogMonitorEvent;
import com.jxdinfo.hussar.support.log.monitor.LogMonitorRuleConfig;
import com.jxdinfo.hussar.support.log.monitor.WaningMessageSend;
import com.jxdinfo.hussar.support.log.rule.entity.LogWarnRule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class LogMonitorListener
implements ApplicationListener<LogMonitorEvent> {
    private static final String WARNING_NOTICE = ":WARNING:NOTICE";
    private static final String KEY_NX = ":NX";
    private static final Logger logger = LoggerFactory.getLogger(LogMonitorListener.class);
    @Autowired
    private LogMonitorRuleConfig logMonitorRuleConfig;
    @Autowired
    private AbstractClient cacheClient;
    @Autowired
    private LogProperties logProperties;
    @Autowired
    private ElasticLowerClient elasticLowerClient;

    private static String getKey(String appName, String env, String tenantCode, String className) {
        String key = "hussarLog:monitor:" + appName;
        if (!HussarUtils.isEmpty((Object)env)) {
            key = key + ":" + env;
        }
        if (!HussarUtils.isEmpty((Object)tenantCode)) {
            key = key + ":" + tenantCode;
        }
        if (!HussarUtils.isEmpty((Object)className)) {
            key = key + ":" + className;
        }
        return key;
    }

    @Async
    public void onApplicationEvent(LogMonitorEvent event) {
        List<RunLogMessage> errorLogs = event.getLogs();
        this.parserLogMessage(errorLogs);
    }

    public void parserLogMessage(List<RunLogMessage> logMessages) {
        logMessages.forEach(runLogMessage -> {
            List<LogWarnRule> monitorRuleConfig = this.logMonitorRuleConfig.getMonitorRuleConfig(runLogMessage.getAppName(), runLogMessage.getEnv());
            if (monitorRuleConfig != null) {
                this.enforcementRules(monitorRuleConfig, (RunLogMessage)runLogMessage);
            }
        });
    }

    public void enforcementRules(List<LogWarnRule> rules, RunLogMessage runLogMessage) {
        for (int i = 0; i < rules.size(); ++i) {
            String tenantCode;
            LogWarnRule warningRule = rules.get(i);
            String className = warningRule.getClassName();
            String serverName = warningRule.getServerName();
            String env = warningRule.getServerEnv();
            String string = tenantCode = HussarUtils.isEmpty((Object)warningRule.getTenantCode()) ? "0" : warningRule.getTenantCode();
            if (HussarUtils.isNotEmpty((Object)runLogMessage.getTenantCode()) && !tenantCode.equals(runLogMessage.getTenantCode()) || this.containsClassName(className, runLogMessage.getClassName())) continue;
            String errorContent = this.getErrorContent(runLogMessage.getContent());
            String cn = StringUtils.isEmpty((Object)className) ? "" : runLogMessage.getClassName();
            this.statisticAlnalysis(LogMonitorListener.getKey(serverName, tenantCode, env, className), warningRule, errorContent, cn);
        }
    }

    private boolean containsClassName(String cn, String mcn) {
        int b;
        if (StringUtils.isEmpty((Object)cn)) {
            return false;
        }
        int a = cn.length();
        int n = b = StringUtils.isEmpty((Object)mcn) ? 0 : mcn.length();
        if (a > b) {
            return true;
        }
        for (int i = 0; i < a; ++i) {
            if (cn.charAt(i) == mcn.charAt(i)) continue;
            return true;
        }
        return false;
    }

    private void statisticAlnalysis(String key, LogWarnRule rule, String errorContent, String className) {
        long startTime;
        long endTime;
        String time = this.cacheClient.hget(key, "time");
        if (StringUtils.isEmpty((Object)time)) {
            time = String.valueOf(System.currentTimeMillis());
            this.cacheClient.hset(key, "time", time);
        }
        if ((endTime = (startTime = Long.parseLong(time)) + (long)(rule.getTimeInterval() * 1000)) > System.currentTimeMillis()) {
            Long incr = this.cacheClient.hincrby(key, "count", 1);
            if (incr >= (long)rule.getErrorNum().intValue() && !this.cacheClient.existsKey(key + WARNING_NOTICE)) {
                this.earlyWarning(rule, incr, key, errorContent, className);
                this.cacheClient.del(key);
            }
        } else {
            this.cacheClient.hdel(key, new String[]{"time", "count"});
            this.cacheClient.hincrby(key, "count", 1);
            this.cacheClient.hset(key, "time", String.valueOf(System.currentTimeMillis()));
        }
    }

    private void earlyWarning(LogWarnRule rule, long count, String key, String errorContent, String className) {
        LogMonitorTextMessage logMonitorTextMessage = new LogMonitorTextMessage.Builder(rule.getServerName(), rule.getServerEnv()).className(rule.getClassName()).ruleName(rule.getRuleName()).errorCount((long)rule.getErrorNum().intValue()).time((long)rule.getTimeInterval().intValue()).count(Long.valueOf(count)).monitorUrl(this.getMonitorMessageURL(rule, className)).errorContent(errorContent).tenantCode(rule.getTenantCode()).build();
        if (!StringUtils.isEmpty((Object)rule.getReceiver())) {
            String[] split = rule.getReceiver().split(",");
            ArrayList<String> receivers = new ArrayList<String>(Arrays.asList(split));
            if (receivers.contains("all") || receivers.contains("ALL")) {
                logMonitorTextMessage.setAtAll(true);
                receivers.remove("all");
                receivers.remove("ALL");
            }
            logMonitorTextMessage.setAtMobiles(receivers);
        }
        String warningKey = key + WARNING_NOTICE;
        logger.info(logMonitorTextMessage.getText());
        WaningMessageSend.send(rule, logMonitorTextMessage);
        this.sendMesageES(rule, count, errorContent);
        this.cacheClient.set(warningKey, warningKey);
        this.cacheClient.expireAt(warningKey, Long.valueOf(Long.parseLong(String.valueOf(rule.getTimeInterval()))));
    }

    private void sendMesageES(LogWarnRule rule, long count, String errorContent) {
        try {
            JSONObject object = (JSONObject)JSONObject.toJSON((Object)((Object)rule));
            object.put("count", (Object)count);
            object.put("dataTime", (Object)System.currentTimeMillis());
            object.put("errorContent", (Object)errorContent);
            String index = HussarUtils.isNotEmpty((Object)rule.getTenantCode()) ? "hussar_log_monitor_message_key_" + rule.getTenantCode().toLowerCase() : "hussar_log_monitor_message_key";
            if (!this.elasticLowerClient.existIndice(index)) {
                this.elasticLowerClient.creatIndiceNomal(index);
            }
            this.elasticLowerClient.insertListComm(Collections.singletonList(object.toJSONString()), index);
            logger.info("monitor message insert es success");
        }
        catch (IOException e) {
            logger.error("monitor message insert es failed!", (Throwable)e);
        }
    }

    private String getMonitorMessageURL(LogWarnRule rule, String className) {
        int time = rule.getTimeInterval() * 1000;
        long currentTime = System.currentTimeMillis();
        long startTime = currentTime - (long)time;
        String builder = this.logProperties.getUrl() + "/?appName=" + rule.getServerName() + "&env=" + rule.getServerEnv() + "&className=" + className + "&logLevel=ERROR&time=" + startTime + "," + currentTime;
        return builder;
    }

    private String getErrorContent(String content) {
        if (content == null) {
            return "";
        }
        int length = 200;
        if (content.length() <= length) {
            return content;
        }
        return content.substring(0, length);
    }
}

