/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.collect;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.log.InitConfig;
import com.jxdinfo.hussar.support.log.cache.AppNameCache;
import com.jxdinfo.hussar.support.log.client.ElasticLowerClient;
import com.jxdinfo.hussar.support.log.core.dto.RunLogMessage;
import com.jxdinfo.hussar.support.log.core.util.ThreadPoolUtil;
import com.jxdinfo.hussar.support.log.monitor.LogMonitorEvent;
import com.jxdinfo.hussar.support.log.util.IndexUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class BaseLogCollect {
    public ThreadPoolExecutor threadPoolExecutor = ThreadPoolUtil.getPool();
    public ElasticLowerClient elasticLowerClient;
    protected ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
    protected ApplicationEventPublisher applicationEventPublisher;
    private final Logger logger = LoggerFactory.getLogger(BaseLogCollect.class);

    public String getRunLogIndex() {
        if ("day".equals(InitConfig.ES_INDEX_MODEL)) {
            return IndexUtil.getRunLogIndex(System.currentTimeMillis());
        }
        return IndexUtil.getRunLogIndexWithHour(System.currentTimeMillis());
    }

    public String getTraceLogIndex() {
        if ("day".equals(InitConfig.ES_INDEX_MODEL)) {
            return IndexUtil.getTraceLogIndex(System.currentTimeMillis());
        }
        return IndexUtil.getTraceLogIndexWithHour(System.currentTimeMillis());
    }

    public void sendLog(String index, List<String> sendList) {
        try {
            if (sendList.size() > 0) {
                this.elasticLowerClient.insertListLog(sendList, index);
            }
        }
        catch (Exception e) {
            this.logger.error("logList insert es failed!", (Throwable)e);
        }
    }

    public void sendTraceLogList(String index, List<String> sendTraceLogList) {
        try {
            if (sendTraceLogList.size() > 0) {
                this.elasticLowerClient.insertListTrace(sendTraceLogList, index);
            }
        }
        catch (Exception e) {
            this.logger.error("traceLogList insert es failed!", (Throwable)e);
        }
    }

    protected void publisherMonitorEvent(List<String> logs) {
        int size = logs.size();
        if (size > 0) {
            try {
                ArrayList<RunLogMessage> errorLogs = new ArrayList<RunLogMessage>();
                for (String logString : logs) {
                    RunLogMessage runLogMessage = (RunLogMessage)JSON.parseObject((String)logString, RunLogMessage.class);
                    if (HussarUtils.isEmpty((Object)runLogMessage)) continue;
                    AppNameCache.appName.computeIfAbsent(runLogMessage.getAppName(), k -> new HashSet()).add(runLogMessage.getEnv());
                    if (!"ERROR".equalsIgnoreCase(runLogMessage.getLogLevel())) continue;
                    errorLogs.add(runLogMessage);
                }
                logs = null;
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new LogMonitorEvent(this, errorLogs));
            }
            catch (Exception e) {
                this.logger.error("publisherMonitorEvent error!", (Throwable)e);
            }
        }
    }
}

