/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.log.InitConfig;
import com.jxdinfo.hussar.support.log.cache.AppNameCache;
import com.jxdinfo.hussar.support.log.client.ElasticLowerClient;
import com.jxdinfo.hussar.support.log.controller.Result;
import com.jxdinfo.hussar.support.log.controller.vo.LoginVO;
import com.jxdinfo.hussar.support.log.core.AbstractClient;
import com.jxdinfo.hussar.support.log.core.LogMessage;
import com.jxdinfo.hussar.support.log.core.constant.LogMessageConstant;
import com.jxdinfo.hussar.support.log.core.util.GfJsonUtil;
import com.jxdinfo.hussar.support.log.util.IndexUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.elasticsearch.client.ResponseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
public class MainController {
    private final Logger logger = LoggerFactory.getLogger(MainController.class);
    @Autowired
    private AbstractClient cacheClient;
    @Autowired
    private ElasticLowerClient elasticLowerClient;

    @RequestMapping(value={"/login", "/husssarLogServer/login"})
    public Result login(@RequestBody LoginVO login, HttpServletRequest request) {
        if (StringUtils.isEmpty((Object)InitConfig.loginUsername)) {
            request.getSession().setAttribute("token", new Object());
            return new Result();
        }
        if (InitConfig.loginUsername.equals(login.getUsername()) && InitConfig.loginPassword.equals(login.getPassword())) {
            request.getSession().setAttribute("token", new Object());
            return new Result();
        }
        request.getSession().removeAttribute("token");
        return Result.INVALID_LOGIN;
    }

    @RequestMapping(value={"/logout", "/hussarlogServer/logout"})
    public void login(HttpServletRequest request) {
        request.getSession().removeAttribute("token");
    }

    @RequestMapping(value={"/getlog", "/hussarlogServer/getlog"})
    public Result getlog(Integer maxSendSize, String logKey) {
        if (maxSendSize == null) {
            maxSendSize = 500;
        }
        Result result = new Result();
        try {
            List logs = this.cacheClient.getMessage(logKey, maxSendSize.intValue());
            if (logs != null && logs.size() > 0) {
                this.logger.debug("get logs success size:" + logs.size());
                result.setCode(200);
                result.setMessage("get logs success!");
                result.setLogs(logs);
                return result;
            }
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            result.setCode(500);
            result.setMessage("get logs error! :" + e.getMessage());
        }
        result.setCode(404);
        result.setMessage("get no logs!");
        return result;
    }

    @RequestMapping(value={"/sendLog", "/hussarlogServer/sendLog"})
    public Result sendLog(@RequestBody List<LogMessage> logs, String logKey) {
        Result result = new Result();
        if ("redis".equals(InitConfig.START_MODEL)) {
            try {
                ArrayList logStr = new ArrayList();
                logs.forEach(log -> logStr.add(GfJsonUtil.toJSONString((Object)log)));
                this.cacheClient.putMessageList(logKey, logStr);
            }
            catch (Exception e) {
                result.setCode(500);
                result.setMessage("send logs error! :" + e.getMessage());
            }
            result.setCode(200);
            result.setMessage("send logs! success");
        } else {
            result.setCode(500);
            result.setMessage("send logs error! rest model only support redis model");
        }
        return result;
    }

    @RequestMapping(value={"/queryAppName", "/hussarlog/queryAppName"})
    public String queryAppName(@RequestBody String queryStr) {
        String[] indexs = new String[InitConfig.keepDays];
        for (int i = 0; i < InitConfig.keepDays; ++i) {
            indexs[i] = IndexUtil.getRunLogIndex(System.currentTimeMillis() - (long)i * 86400000L) + "*";
        }
        List<String> reindexs = this.elasticLowerClient.getExistIndices(indexs);
        String indexStr = String.join((CharSequence)",", reindexs);
        if ("".equals(indexStr)) {
            return "";
        }
        String url = "/" + indexStr + "/_search?from=0&size=0";
        this.logger.debug("queryURL:" + url);
        this.logger.debug("queryStr:" + queryStr);
        try {
            return this.elasticLowerClient.get(url, queryStr);
        }
        catch (Exception e) {
            if (e instanceof ResponseException && queryStr.contains("appNameWithEnv")) {
                queryStr = queryStr.replaceAll("appNameWithEnv", "appName");
                this.logger.debug("queryURL:" + url);
                this.logger.debug("queryStr:" + queryStr);
                try {
                    return this.elasticLowerClient.get(url, queryStr);
                }
                catch (Exception ex) {
                    this.logger.error("queryAppName fail!", (Throwable)ex);
                    return "";
                }
            }
            this.logger.error("queryAppName fail!", (Throwable)e);
            return "";
        }
    }

    @RequestMapping(value={"/queryAppNames", "/hussarlog/queryAppNames"})
    public Set<String> queryAppNames(@RequestBody String queryStr) {
        String[] indexs = new String[InitConfig.keepDays];
        for (int i = 0; i < InitConfig.keepDays; ++i) {
            indexs[i] = IndexUtil.getRunLogIndex(System.currentTimeMillis() - (long)i * 86400000L) + "*";
        }
        List<String> reindexs = this.elasticLowerClient.getExistIndices(indexs);
        String indexStr = String.join((CharSequence)",", reindexs);
        if ("".equals(indexStr)) {
            return Collections.emptySet();
        }
        String url = "/" + indexStr + "/_search?from=0&size=0";
        this.logger.debug("queryURL:" + url);
        this.logger.debug("queryStr:" + queryStr);
        HashSet<String> appNameSet = new HashSet<String>();
        boolean isQueryWithEnv = queryStr.contains("appNameWithEnv");
        TreeSet<String> appNameWithEnvSet = new TreeSet<String>(this.queryAppNameWithEnvSet(url, queryStr, appNameSet, isQueryWithEnv));
        if (isQueryWithEnv) {
            queryStr = queryStr.replaceAll("appNameWithEnv", "appName");
            this.logger.debug("queryURL:" + url);
            this.logger.debug("queryStr:" + queryStr);
            appNameWithEnvSet.addAll(this.queryAppNameWithEnvSet(url, queryStr, appNameSet, false));
        }
        return appNameWithEnvSet;
    }

    @RequestMapping(value={"/clientQuery", "/hussarlog/clientQuery"})
    public String clientQuery(@RequestBody String queryStr, String size, String from, String clientStartDate, String clientEndDate, String trace) {
        Long clientStartDateTime = 0L;
        try {
            clientStartDateTime = Long.valueOf(clientStartDate);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (clientStartDateTime <= 0L) {
            clientStartDateTime = System.currentTimeMillis();
        }
        Long clientEndDateTime = 0L;
        try {
            clientEndDateTime = Long.valueOf(clientEndDate);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (clientEndDateTime <= 0L) {
            clientEndDateTime = System.currentTimeMillis();
        }
        LinkedHashSet<String> indexSet = new LinkedHashSet<String>();
        while (clientStartDateTime <= clientEndDateTime) {
            indexSet.add(("true".equalsIgnoreCase(trace) ? IndexUtil.getTraceLogIndex(clientStartDateTime) : IndexUtil.getRunLogIndex(clientStartDateTime)) + "*");
            clientStartDateTime = clientStartDateTime + 86400000L;
        }
        indexSet.add(("true".equalsIgnoreCase(trace) ? IndexUtil.getTraceLogIndex(clientEndDateTime) : IndexUtil.getRunLogIndex(clientEndDateTime)) + "*");
        List<String> existIndices = this.elasticLowerClient.getExistIndices(indexSet.toArray(new String[0]));
        String indexStr = String.join((CharSequence)",", existIndices);
        if ("".equals(indexStr)) {
            return "";
        }
        String url = "/" + indexStr + "/_search?from=" + from + "&size=" + size;
        this.logger.debug("queryURL:" + url);
        this.logger.debug("queryStr:" + queryStr);
        try {
            return this.elasticLowerClient.get(url, queryStr);
        }
        catch (Exception e) {
            if (e instanceof ResponseException && (queryStr.contains(",{\"seq\":\"desc\"}") || queryStr.contains(",{\"seq\":\"asc\"}"))) {
                queryStr = queryStr.replace(",{\"seq\":\"desc\"}", "");
                queryStr = queryStr.replace(",{\"seq\":\"asc\"}", "");
                this.logger.debug("queryURL:" + url);
                this.logger.debug("queryStr:" + queryStr);
                try {
                    return this.elasticLowerClient.get(url, queryStr);
                }
                catch (Exception ex) {
                    this.logger.error("clientQuery fail!", (Throwable)ex);
                    return "";
                }
            }
            this.logger.error("clientQuery fail!", (Throwable)e);
            return "";
        }
    }

    @RequestMapping(value={"/query", "/hussarlog/query"})
    public Object query(@RequestBody String queryStr, String index, String size, String from, String range) {
        String message = "";
        String indexStr = "";
        try {
            List<String> reindexs;
            List indexs;
            TreeSet<Object> indexSet = new TreeSet<Object>();
            if (!StringUtils.isEmpty((Object)index) && !(indexs = Stream.of(index.split(",")).map(String::trim).filter(s -> !StringUtils.isEmpty((Object)s)).collect(Collectors.toList())).isEmpty()) {
                indexSet.addAll(indexs);
            }
            if (!StringUtils.isEmpty((Object)range)) {
                int rangeDays = 0;
                if ("day".equalsIgnoreCase(range)) {
                    rangeDays = 1;
                } else if ("week".equalsIgnoreCase(range)) {
                    rangeDays = 7;
                } else if ("month".equalsIgnoreCase(range)) {
                    rangeDays = 30;
                }
                for (int i = 0; i < rangeDays; ++i) {
                    indexSet.add(IndexUtil.getRunLogIndex(System.currentTimeMillis() - (long)i * 86400000L) + "*");
                }
            }
            if ("".equals(indexStr = (reindexs = this.elasticLowerClient.getExistIndices(indexSet.toArray(new String[0]))).stream().filter(s -> !StringUtils.isEmpty((Object)s)).collect(Collectors.joining(",")))) {
                return message;
            }
            String url = "/" + indexStr + "/_search?from=" + from + "&size=" + size;
            this.logger.debug("queryURL:" + url);
            this.logger.debug("queryStr:" + queryStr);
            return JsonUtil.parse((String)this.elasticLowerClient.get(url, queryStr), Object.class);
        }
        catch (Exception e) {
            this.logger.error("query fail!", (Throwable)e);
            return "";
        }
    }

    @RequestMapping(value={"/deleteByQuery", "/hussarlog/deleteByQuery"})
    public String deleteByQuery(@RequestBody String queryStr, String index, String size, String from) {
        String message = "";
        String indexStr = "";
        try {
            String[] indexs = (String[])Stream.of(index.split(",")).map(String::trim).filter(s -> !StringUtils.isEmpty((Object)s)).toArray(String[]::new);
            List<String> reindexs = this.elasticLowerClient.getExistIndices(indexs);
            indexStr = String.join((CharSequence)",", reindexs);
            if ("".equals(indexStr)) {
                return message;
            }
            String url = "/" + indexStr + "/_delete_by_query?from=" + from + "&size=" + size;
            this.logger.debug("queryURL:" + url);
            this.logger.debug("queryStr:" + queryStr);
            return this.elasticLowerClient.get(url, queryStr);
        }
        catch (Exception e) {
            this.logger.error("deleteByQuery fail!", (Throwable)e);
            return "";
        }
    }

    @RequestMapping(value={"/getServerInfo", "/hussarlog/getServerInfo"})
    public String query(String index) {
        String res = this.elasticLowerClient.cat(index);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(res.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
        ArrayList<String> list = new ArrayList<String>();
        try {
            String aa;
            while (!StringUtils.isEmpty((Object)(aa = br.readLine()))) {
                list.add(aa);
            }
            ArrayList listMap = new ArrayList();
            if (list.size() > 0) {
                String[] title = ((String)list.get(0)).split("\\s+");
                for (int i = 1; i < list.size(); ++i) {
                    String[] values = ((String)list.get(i)).split("\\s+");
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (int j = 0; j < title.length; ++j) {
                        map.put(title[j], values[j]);
                    }
                    listMap.add(map);
                }
            }
            return GfJsonUtil.toJSONString(listMap);
        }
        catch (IOException e) {
            this.logger.error("", (Throwable)e);
            return "";
        }
    }

    @RequestMapping(value={"/getQueueCounts", "/hussarlog/getQueueCounts"})
    public Map<String, Object> getQueueCounts() {
        Long runSize = 0L;
        Long traceSize = 0L;
        if (this.cacheClient != null) {
            runSize = this.cacheClient.llen("hussar_log_list");
            traceSize = this.cacheClient.llen("hussar_log_trace_list");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("runSize", runSize);
        map.put("traceSize", traceSize);
        return map;
    }

    @RequestMapping(value={"/deleteQueue", "/hussarlog/deleteQueue"})
    public ApiResponse<Boolean> deleteQueue(String adminPassWord) {
        HashMap map = new HashMap();
        if (this.cacheClient != null) {
            this.cacheClient.del("hussar_log_list");
            this.cacheClient.del("hussar_log_trace_list");
        }
        return ApiResponse.success((Object)Boolean.TRUE);
    }

    @RequestMapping(value={"/deleteIndex", "/hussarlog/deleteIndex"})
    public ApiResponse<Boolean> deleteIndex(String index, String adminPassWord) {
        HashMap map = new HashMap();
        boolean re = this.elasticLowerClient.deleteIndex(index);
        if (index.startsWith("hussar_log_run")) {
            this.creatIndiceLog(index);
        }
        if (index.startsWith("hussar_log_trace")) {
            this.creatIndiceTrace(index);
        }
        return ApiResponse.success((Object)re);
    }

    private void creatIndiceLog(String index) {
        if (!this.elasticLowerClient.existIndice(index)) {
            this.elasticLowerClient.creatIndice(index, LogMessageConstant.ES_TYPE);
        }
    }

    private void creatIndiceTrace(String index) {
        if (!this.elasticLowerClient.existIndice(index)) {
            this.elasticLowerClient.creatIndiceTrace(index, LogMessageConstant.ES_TYPE);
        }
    }

    @RequestMapping(value={"/getExtendfieldList", "/hussarlog/getExtendfieldList"})
    public Object getExtendfieldList(String appName) {
        return this.cacheClient.hgetAll("hussarLog:extend:" + appName);
    }

    @RequestMapping(value={"/addExtendfield", "/hussarlog/addExtendfield"})
    public Object addExtendfield(String appName, String field, String fieldName) {
        this.cacheClient.hset("hussarLog:extend:" + appName, field, fieldName);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        return result;
    }

    @RequestMapping(value={"/delExtendfield", "/hussarlog/delExtendfield"})
    public Object delExtendfield(String appName, String field) {
        this.cacheClient.hdel("hussarLog:extend:" + appName, new String[]{field});
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        return result;
    }

    @RequestMapping(value={"/getAppNames", "/hussarlog/getAppNames"})
    public Object getAppNames() {
        return AppNameCache.appName;
    }

    private Set<String> queryAppNameWithEnvSet(String url, String queryStr, Set<String> appNameSet, boolean isQueryWithEnv) {
        try {
            String result = this.elasticLowerClient.get(url, queryStr);
            if (!"".equals(result)) {
                HashSet<String> appNameWithEnvSet = new HashSet<String>();
                JSONObject jsonObject = JSON.parseObject((String)result);
                jsonObject = (JSONObject)jsonObject.get((Object)"aggregations");
                jsonObject = (JSONObject)jsonObject.get((Object)"dataCount");
                JSONArray jsonArray = (JSONArray)jsonObject.get((Object)"buckets");
                if (isQueryWithEnv) {
                    jsonArray.forEach(key -> {
                        JSONObject keyJsonObject = (JSONObject)key;
                        String appNameWithEnv = (String)keyJsonObject.get((Object)"key");
                        appNameWithEnvSet.add(appNameWithEnv);
                        appNameSet.add(appNameWithEnv.split("-_-")[0]);
                    });
                } else {
                    jsonArray.forEach(key -> {
                        JSONObject keyJsonObject = (JSONObject)key;
                        String appName = (String)keyJsonObject.get((Object)"key");
                        if (!appNameSet.contains(appName)) {
                            appNameSet.add(appName);
                            appNameWithEnvSet.add(appName + "-_-");
                        }
                    });
                }
                return appNameWithEnvSet;
            }
        }
        catch (Exception ex) {
            this.logger.error("queryAppName fail!", (Throwable)ex);
        }
        return Collections.emptySet();
    }
}

