/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.controller;

import com.jxdinfo.hussar.support.log.InitConfig;
import com.jxdinfo.hussar.support.log.client.ElasticLowerClient;
import com.jxdinfo.hussar.support.log.core.constant.LogMessageConstant;
import com.jxdinfo.hussar.support.log.util.IndexUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class AutoDeleteLogs {
    private final Logger logger = LoggerFactory.getLogger(AutoDeleteLogs.class);
    @Autowired
    private ElasticLowerClient elasticLowerClient;

    @Scheduled(cron="0 0 0 * * ?")
    public void deleteLogs() {
        String hour;
        int a;
        if (InitConfig.keepDays > 0) {
            try {
                this.logger.info("begin delete {} days ago run logs!", (Object)InitConfig.keepDays);
                String runLogIndex = IndexUtil.getRunLogIndex(System.currentTimeMillis() - (long)InitConfig.keepDays * 86400000L);
                this.elasticLowerClient.deleteIndex(runLogIndex);
                for (a = 0; a < 24; ++a) {
                    hour = String.format("%02d", a);
                    this.elasticLowerClient.deleteIndex(runLogIndex + hour);
                }
                this.logger.info("delete success! index:" + runLogIndex);
            }
            catch (Exception e) {
                this.logger.error("delete logs error!", (Throwable)e);
            }
        } else {
            this.logger.info("unwanted delete logs");
        }
        if (InitConfig.traceKeepDays > 0) {
            try {
                this.logger.info("begin delete {} days ago trace logs!", (Object)InitConfig.traceKeepDays);
                String traceLogIndex = IndexUtil.getTraceLogIndex(System.currentTimeMillis() - (long)InitConfig.traceKeepDays * 86400000L);
                this.elasticLowerClient.deleteIndex(traceLogIndex);
                for (a = 0; a < 24; ++a) {
                    hour = String.format("%02d", a);
                    this.elasticLowerClient.deleteIndex(traceLogIndex + hour);
                }
                this.logger.info("delete success! index:" + traceLogIndex);
            }
            catch (Exception e) {
                this.logger.error("delete logs error!", (Throwable)e);
            }
        } else {
            this.logger.info("unwanted delete logs");
        }
    }

    @Scheduled(cron="0 30 * * * ?")
    public void creatIndice() {
        long time = System.currentTimeMillis() + 86400000L;
        String runLogIndex = IndexUtil.getRunLogIndex(time);
        String traceLogIndex = IndexUtil.getTraceLogIndex(time);
        if ("day".equals(InitConfig.ES_INDEX_MODEL)) {
            this.creatIndiceLog(runLogIndex);
            this.creatIndiceTrace(traceLogIndex);
        } else {
            for (int a = 0; a < 24; ++a) {
                String hour = String.format("%02d", a);
                this.creatIndiceLog(runLogIndex + hour);
                this.creatIndiceTrace(traceLogIndex + hour);
            }
        }
    }

    private void creatIndiceLog(String index) {
        if (!this.elasticLowerClient.existIndice(index)) {
            this.elasticLowerClient.creatIndice(index, LogMessageConstant.ES_TYPE);
        }
    }

    private void creatIndiceTrace(String index) {
        if (!this.elasticLowerClient.existIndice(index)) {
            this.elasticLowerClient.creatIndiceTrace(index, LogMessageConstant.ES_TYPE);
        }
    }
}

