/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log;

import com.jxdinfo.hussar.support.log.InitConfig;
import com.jxdinfo.hussar.support.log.client.ElasticLowerClient;
import com.jxdinfo.hussar.support.log.collect.CacheLogCollect;
import com.jxdinfo.hussar.support.log.core.AbstractClient;
import com.jxdinfo.hussar.support.log.core.constant.LogMessageConstant;
import com.jxdinfo.hussar.support.log.util.IndexUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;

public class CollectStartBean
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(CollectStartBean.class);
    @Autowired
    private ElasticLowerClient elasticLowerClient;
    @Autowired(required=false)
    private AbstractClient cacheClient;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Value(value="${hussar.log.redis.compressor:false}")
    private Boolean compressor;

    private void serverStart() {
        CacheLogCollect logCollect = new CacheLogCollect(this.elasticLowerClient, this.cacheClient, this.applicationEventPublisher, this.compressor);
        logCollect.cacheStart();
    }

    public void afterPropertiesSet() {
        try {
            this.autoCreatIndice();
            this.serverStart();
        }
        catch (Exception e) {
            logger.error("hussarlog server starting failed!", (Throwable)e);
        }
    }

    private void autoCreatIndice() {
        long epochMillis = System.currentTimeMillis();
        String runLogIndex = IndexUtil.getRunLogIndex(epochMillis);
        String traceLogIndex = IndexUtil.getTraceLogIndex(epochMillis);
        if ("day".equals(InitConfig.ES_INDEX_MODEL)) {
            this.creatIndiceLog(runLogIndex);
            this.creatIndiceTrace(traceLogIndex);
        } else {
            for (int a = 0; a < 24; ++a) {
                String hour = String.format("%02d", a);
                this.creatIndiceLog(runLogIndex + hour);
                this.creatIndiceTrace(traceLogIndex + hour);
            }
        }
    }

    private void creatIndiceLog(String index) {
        if (!this.elasticLowerClient.existIndice(index)) {
            this.elasticLowerClient.creatIndice(index, LogMessageConstant.ES_TYPE);
        }
    }

    private void creatIndiceTrace(String index) {
        if (!this.elasticLowerClient.existIndice(index)) {
            this.elasticLowerClient.creatIndiceTrace(index, LogMessageConstant.ES_TYPE);
        }
    }
}

