/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.rule.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.log.core.AbstractClient;
import com.jxdinfo.hussar.support.log.rule.entity.LogWarnRule;
import com.jxdinfo.hussar.support.log.rule.mapper.LogWarnRuleMapper;
import com.jxdinfo.hussar.support.log.rule.service.LogWarnRuleService;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogWarnRuleServiceImpl
extends HussarServiceImpl<LogWarnRuleMapper, LogWarnRule>
implements LogWarnRuleService {
    @Autowired
    private AbstractClient cacheClient;

    @Override
    public boolean saveWarnRule(LogWarnRule logWarnRule) {
        boolean flag;
        String errorMsg;
        long num;
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)((Object)logWarnRule)), (String)"\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
        String ruleName = logWarnRule.getRuleName();
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)ruleName), (String)"\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Long ruleId = logWarnRule.getRuleId();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(LogWarnRule::getRuleName, (Object)ruleName);
        if (HussarUtils.isNotEmpty((Object)ruleId)) {
            wrapper.ne(LogWarnRule::getRuleId, (Object)ruleId);
        }
        HussarException.throwBy(((num = this.count((Wrapper)wrapper)) > 0L ? 1 : 0) != 0, (String)"\u4fdd\u5b58\u5931\u8d25\uff01\uff08\u89c4\u5219\u540d\u79f0\u5df2\u5b58\u5728\uff01\uff09");
        wrapper.clear();
        String serverName = logWarnRule.getServerName();
        String className = logWarnRule.getClassName();
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)serverName), (String)"\u670d\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        wrapper.eq(LogWarnRule::getServerName, (Object)serverName);
        if (HussarUtils.isEmpty((Object)className)) {
            wrapper.isNull(LogWarnRule::getClassName);
            errorMsg = "\u4fdd\u5b58\u5931\u8d25\uff01\uff08\u670d\u52a1\u540d\u79f0\u5bf9\u5e94\u7684\u5168\u5c40\u544a\u8b66\u89c4\u5219\u5df2\u5b58\u5728\uff01\uff09";
        } else {
            wrapper.eq(LogWarnRule::getClassName, (Object)className);
            errorMsg = "\u4fdd\u5b58\u5931\u8d25\uff01\uff08\u670d\u52a1\u540d\u79f0\u5bf9\u5e94\u7684\u7c7b\u540d\u544a\u8b66\u89c4\u5219\u5df2\u5b58\u5728\uff01\uff09";
        }
        if (HussarUtils.isNotEmpty((Object)ruleId)) {
            wrapper.ne(LogWarnRule::getRuleId, (Object)ruleId);
        }
        HussarException.throwBy(((num = this.count((Wrapper)wrapper)) > 0L ? 1 : 0) != 0, (String)errorMsg);
        String env = logWarnRule.getServerEnv();
        if (HussarUtils.isEmpty((Object)env)) {
            logWarnRule.setServerEnv("default");
        }
        if (flag = this.saveOrUpdate((BaseEntity)logWarnRule)) {
            this.cacheClient.del("hussarLog:warnRule");
        }
        return flag;
    }

    @Override
    public boolean deleteWarnRule(Long ruleId) {
        if (HussarUtils.isEmpty((Object)ruleId)) {
            throw new HussarException("\u8981\u5220\u9664\u7684\u89c4\u5219id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean flag = this.removeById(ruleId);
        if (flag) {
            this.cacheClient.del("hussarLog:warnRule");
        }
        return flag;
    }

    @Override
    public Page<LogWarnRule> getWarnRulePage(Page<LogWarnRule> page, LogWarnRule logWarnRule) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (HussarUtils.isEmpty((Object)((Object)logWarnRule))) {
            return (Page)this.page((IPage)page);
        }
        String serverName = logWarnRule.getServerName();
        String ruleName = logWarnRule.getRuleName();
        if (HussarUtils.isNotEmpty((Object)serverName)) {
            wrapper.like(LogWarnRule::getServerName, (Object)serverName);
        }
        if (HussarUtils.isNotEmpty((Object)ruleName)) {
            wrapper.like(LogWarnRule::getRuleName, (Object)ruleName);
        }
        return (Page)this.page((IPage)page, (Wrapper)wrapper);
    }
}

