/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.logback.appender;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import com.jxdinfo.hussar.support.log.core.AbstractClient;
import com.jxdinfo.hussar.support.log.core.MessageAppenderFactory;
import com.jxdinfo.hussar.support.log.core.cache.CacheClient;
import com.jxdinfo.hussar.support.log.core.constant.LogMessageConstant;
import com.jxdinfo.hussar.support.log.core.dto.BaseLogMessage;
import com.jxdinfo.hussar.support.log.core.dto.RunLogMessage;
import com.jxdinfo.hussar.support.log.core.util.GfJsonUtil;
import com.jxdinfo.hussar.support.log.core.util.ThreadPoolUtil;
import com.jxdinfo.hussar.support.log.logback.util.LogMessageUtil;
import java.util.concurrent.ThreadPoolExecutor;

public class CacheAppender
extends AppenderBase<ILoggingEvent> {
    private static final ThreadPoolExecutor threadPoolExecutor = ThreadPoolUtil.getPool();
    private AbstractClient cacheClient;
    private String appName;
    private String env;
    private String expand;
    private String runModel;
    private int maxCount = 500;
    private int logQueueSize = 10000;
    private int threadPoolSize = 5;
    private boolean compressor = false;

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public String getRunModel() {
        return this.runModel;
    }

    public void setRunModel(String runModel) {
        this.runModel = runModel;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public int getLogQueueSize() {
        return this.logQueueSize;
    }

    public void setLogQueueSize(int logQueueSize) {
        this.logQueueSize = logQueueSize;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public boolean isCompressor() {
        return this.compressor;
    }

    public void setCompressor(boolean compressor) {
        this.compressor = compressor;
    }

    protected void append(ILoggingEvent iLoggingEvent) {
        this.send(iLoggingEvent);
    }

    protected void send(ILoggingEvent logEvent) {
        BaseLogMessage logMessage = LogMessageUtil.getLogMessage(this.appName, this.env, logEvent);
        if (logMessage instanceof RunLogMessage) {
            String message = LogMessageUtil.getLogMessage(logMessage, logEvent);
            MessageAppenderFactory.pushRundataQueue((String)message);
        } else {
            MessageAppenderFactory.pushTracedataQueue((String)GfJsonUtil.toJSONString((Object)logMessage));
        }
    }

    public void start() {
        if (this.env == null) {
            this.env = "default";
        }
        if (this.runModel != null) {
            LogMessageConstant.RUN_MODEL = Integer.parseInt(this.runModel);
        }
        if (this.expand != null && LogMessageConstant.EXPANDS.contains(this.expand)) {
            LogMessageConstant.EXPAND = this.expand;
        }
        this.cacheClient = new CacheClient();
        if (this.maxCount == 0) {
            this.maxCount = 100;
        }
        if (this.logQueueSize == 0) {
            this.logQueueSize = 10000;
        }
        if (this.threadPoolSize == 0) {
            this.threadPoolSize = 1;
        }
        int count = this.maxCount;
        MessageAppenderFactory.initQueue((int)this.logQueueSize);
        for (int a = 0; a < this.threadPoolSize; ++a) {
            threadPoolExecutor.execute(() -> MessageAppenderFactory.startRunLog((AbstractClient)this.cacheClient, (int)count, (String)(this.compressor ? "hussar_log_list_compress" : "hussar_log_list"), (boolean)this.compressor));
            threadPoolExecutor.execute(() -> MessageAppenderFactory.startTraceLog((AbstractClient)this.cacheClient, (int)count, (String)(this.compressor ? "hussar_log_trace_list_compress" : "hussar_log_trace_list"), (boolean)this.compressor));
        }
    }
}

