/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.logback.util;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import com.jxdinfo.hussar.support.log.core.LogMessageThreadLocal;
import com.jxdinfo.hussar.support.log.core.TraceId;
import com.jxdinfo.hussar.support.log.core.TraceMessage;
import com.jxdinfo.hussar.support.log.core.dto.BaseLogMessage;
import com.jxdinfo.hussar.support.log.core.dto.RunLogMessage;
import com.jxdinfo.hussar.support.log.core.util.DateUtil;
import com.jxdinfo.hussar.support.log.core.util.GfJsonUtil;
import com.jxdinfo.hussar.support.log.core.util.LogExceptionStackTrace;
import com.jxdinfo.hussar.support.log.core.util.TraceLogMessageFactory;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.helpers.MessageFormatter;

public class LogMessageUtil {
    private static final AtomicLong SEQ_BUILDER = new AtomicLong();

    private static String isExpandRunLog(ILoggingEvent logEvent) {
        String traceId = null;
        if (!logEvent.getMDCPropertyMap().isEmpty() && (traceId = (String)logEvent.getMDCPropertyMap().get("traceId")) != null) {
            TraceId.logTraceID.set((Object)traceId);
        }
        return traceId;
    }

    public static String getLogMessage(BaseLogMessage baseLogMessage, ILoggingEvent iLoggingEvent) {
        Map mdc = iLoggingEvent.getMDCPropertyMap();
        Map map = (Map)GfJsonUtil.parseObject((String)GfJsonUtil.toJSONString((Object)baseLogMessage), Map.class);
        if (mdc != null) {
            map.putAll(mdc);
        }
        return GfJsonUtil.toJSONString((Object)map);
    }

    public static BaseLogMessage getLogMessage(String appName, String env, ILoggingEvent iLoggingEvent) {
        LogMessageUtil.isExpandRunLog(iLoggingEvent);
        TraceMessage traceMessage = (TraceMessage)LogMessageThreadLocal.logMessageThreadLocal.get();
        String formattedMessage = LogMessageUtil.getMessage(iLoggingEvent);
        if (formattedMessage.startsWith("TRACE:")) {
            return TraceLogMessageFactory.getTraceLogMessage((TraceMessage)traceMessage, (String)appName, (String)env, (long)iLoggingEvent.getTimeStamp());
        }
        RunLogMessage logMessage = TraceLogMessageFactory.getLogMessage((String)appName, (String)env, (String)formattedMessage, (long)iLoggingEvent.getTimeStamp());
        logMessage.setClassName(iLoggingEvent.getLoggerName());
        logMessage.setThreadName(iLoggingEvent.getThreadName());
        logMessage.setSeq(Long.valueOf(SEQ_BUILDER.getAndIncrement()));
        logMessage.setClientIp(traceMessage.getClientIp());
        StackTraceElement stackTraceElement = iLoggingEvent.getCallerData()[0];
        String method = stackTraceElement.getMethodName();
        String line = String.valueOf(stackTraceElement.getLineNumber());
        logMessage.setMethod(method + "(" + stackTraceElement.getFileName() + ":" + line + ")");
        logMessage.setDateTime(DateUtil.getDatetimeNormalStrWithMills((long)iLoggingEvent.getTimeStamp()));
        logMessage.setLogLevel(iLoggingEvent.getLevel().toString());
        return logMessage;
    }

    private static String getMessage(ILoggingEvent logEvent) {
        if (logEvent.getLevel().equals(Level.ERROR)) {
            if (logEvent.getThrowableProxy() != null) {
                ThrowableProxy throwableProxy = (ThrowableProxy)logEvent.getThrowableProxy();
                Object[] args = new String[]{logEvent.getFormattedMessage() + "\n" + LogExceptionStackTrace.erroStackTrace((Object)throwableProxy.getThrowable()).toString()};
                return LogMessageUtil.packageMessage("{}", args);
            }
            Object[] args = logEvent.getArgumentArray();
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (!(args[i] instanceof Throwable)) continue;
                    args[i] = LogExceptionStackTrace.erroStackTrace((Object)args[i]);
                }
                return LogMessageUtil.packageMessage(logEvent.getMessage(), args);
            }
        }
        return logEvent.getFormattedMessage();
    }

    private static String packageMessage(String message, Object[] args) {
        if (message != null && message.contains("{}")) {
            return MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage();
        }
        return TraceLogMessageFactory.packageMessage((String)message, (Object[])args);
    }
}

