/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.logback.appender;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import com.jxdinfo.hussar.support.log.core.AbstractClient;
import com.jxdinfo.hussar.support.log.core.MessageAppenderFactory;
import com.jxdinfo.hussar.support.log.core.constant.LogMessageConstant;
import com.jxdinfo.hussar.support.log.core.dto.BaseLogMessage;
import com.jxdinfo.hussar.support.log.core.dto.RunLogMessage;
import com.jxdinfo.hussar.support.log.core.redis.RedisClient;
import com.jxdinfo.hussar.support.log.core.redis.RedisSentinelClient;
import com.jxdinfo.hussar.support.log.core.util.GfJsonUtil;
import com.jxdinfo.hussar.support.log.core.util.ThreadPoolUtil;
import com.jxdinfo.hussar.support.log.logback.util.LogMessageUtil;
import java.util.concurrent.ThreadPoolExecutor;

public class RedisAppender
extends AppenderBase<ILoggingEvent> {
    private static final ThreadPoolExecutor threadPoolExecutor = ThreadPoolUtil.getPool();
    private AbstractClient redisClient;
    private String appName;
    private String env = "default";
    private String redisHost;
    private String redisPort;
    private String redisAuth;
    private String model = "standalone";
    private String masterName;
    private int redisDb = 0;
    private String runModel;
    private String expand;
    private int maxCount = 100;
    private int logQueueSize = 10000;
    private int threadPoolSize = 1;
    private boolean compressor = false;

    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getRedisHost() {
        return this.redisHost;
    }

    public void setRedisHost(String redisHost) {
        this.redisHost = redisHost;
    }

    public String getRedisPort() {
        return this.redisPort;
    }

    public void setRedisPort(String redisPort) {
        this.redisPort = redisPort;
    }

    public void setRedisAuth(String redisAuth) {
        this.redisAuth = redisAuth;
    }

    public int getRedisDb() {
        return this.redisDb;
    }

    public void setRedisDb(int redisDb) {
        this.redisDb = redisDb;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public String getRunModel() {
        return this.runModel;
    }

    public void setRunModel(String runModel) {
        this.runModel = runModel;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public int getLogQueueSize() {
        return this.logQueueSize;
    }

    public void setLogQueueSize(int logQueueSize) {
        this.logQueueSize = logQueueSize;
    }

    public boolean isCompressor() {
        return this.compressor;
    }

    public void setCompressor(boolean compressor) {
        this.compressor = compressor;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public void setMasterName(String masterName) {
        this.masterName = masterName;
    }

    protected void append(ILoggingEvent event) {
        this.send(event);
    }

    protected void send(ILoggingEvent event) {
        BaseLogMessage logMessage = LogMessageUtil.getLogMessage(this.appName, this.env, event);
        if (logMessage instanceof RunLogMessage) {
            String message = LogMessageUtil.getLogMessage(logMessage, event);
            MessageAppenderFactory.pushRundataQueue((String)message);
        } else {
            MessageAppenderFactory.pushTracedataQueue((String)GfJsonUtil.toJSONString((Object)logMessage));
        }
    }

    public void start() {
        int a;
        super.start();
        if (this.runModel != null) {
            LogMessageConstant.RUN_MODEL = Integer.parseInt(this.runModel);
        }
        if (this.expand != null && LogMessageConstant.EXPANDS.contains(this.expand)) {
            LogMessageConstant.EXPAND = this.expand;
        }
        if (this.redisClient == null) {
            if ("sentinel".equals(this.model)) {
                this.redisClient = RedisSentinelClient.getInstance((String)this.redisHost, (String)this.masterName, (String)this.redisAuth, (int)this.redisDb);
            } else {
                int port = 6379;
                String ip = "127.0.0.1";
                if (this.redisPort == null) {
                    if (this.redisHost.contains(":")) {
                        String[] hs = this.redisHost.split(":");
                        if (hs.length == 2) {
                            ip = hs[0];
                            port = Integer.parseInt(hs[1]);
                        }
                    } else {
                        ip = this.redisHost;
                    }
                } else {
                    ip = this.redisHost;
                    port = Integer.parseInt(this.redisPort);
                }
                this.redisClient = RedisClient.getInstance((String)ip, (int)port, (String)this.redisAuth, (int)this.redisDb);
            }
        }
        MessageAppenderFactory.initQueue((int)this.logQueueSize);
        for (a = 0; a < this.threadPoolSize; ++a) {
            threadPoolExecutor.execute(() -> MessageAppenderFactory.startRunLog((AbstractClient)this.redisClient, (int)this.maxCount, (String)(this.compressor ? "hussar_log_list_compress" : "hussar_list"), (boolean)this.compressor));
        }
        for (a = 0; a < this.threadPoolSize; ++a) {
            threadPoolExecutor.execute(() -> MessageAppenderFactory.startTraceLog((AbstractClient)this.redisClient, (int)this.maxCount, (String)(this.compressor ? "hussar_trace_list_compress" : "hussar_trace_list"), (boolean)this.compressor));
        }
    }
}

