/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.log4j2.appender;

import com.jxdinfo.hussar.support.log.core.AbstractClient;
import com.jxdinfo.hussar.support.log.core.MessageAppenderFactory;
import com.jxdinfo.hussar.support.log.core.constant.LogMessageConstant;
import com.jxdinfo.hussar.support.log.core.dto.BaseLogMessage;
import com.jxdinfo.hussar.support.log.core.dto.RunLogMessage;
import com.jxdinfo.hussar.support.log.core.mq.MqClient;
import com.jxdinfo.hussar.support.log.core.util.GfJsonUtil;
import com.jxdinfo.hussar.support.log.core.util.ThreadPoolUtil;
import com.jxdinfo.hussar.support.log.log4j2.util.LogMessageUtil;
import java.io.Serializable;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="MqAppender", category="Core", elementType="appender", printObject=true)
public class MqAppender
extends AbstractAppender {
    private static final String[] IGNORE_PACKAGES = new String[]{"io.lettuce.", "redis.clients.jedis.", "com.jxdinfo.hussar.support.mq."};
    private static MqClient mqClient;
    private static final ThreadPoolExecutor threadPoolExecutor;
    private final String appName;
    private final String env;
    private final String runModel;
    private final String expand;
    private int maxCount = 500;
    private int logQueueSize = 10000;
    private int threadPoolSize = 1;

    protected MqAppender(String name, String appName, String env, String runModel, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, String expand, int maxCount, int logQueueSize, int threadPoolSize) {
        super(name, filter, layout, ignoreExceptions);
        this.appName = appName;
        this.env = env;
        this.runModel = runModel;
        this.expand = expand;
        this.maxCount = maxCount;
        this.logQueueSize = logQueueSize;
        this.threadPoolSize = threadPoolSize;
    }

    @PluginFactory
    public static MqAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="appName") String appName, @PluginAttribute(value="env") String env, @PluginAttribute(value="expand") String expand, @PluginAttribute(value="runModel") String runModel, @PluginAttribute(value="maxCount") int maxCount, @PluginAttribute(value="logQueueSize") int logQueueSize, @PluginAttribute(value="threadPoolSize") int threadPoolSize, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter) {
        if (env == null) {
            env = "default";
        }
        if (runModel != null) {
            LogMessageConstant.RUN_MODEL = Integer.parseInt(runModel);
        }
        if (mqClient == null) {
            mqClient = MqClient.getInstance();
        }
        if (expand != null && LogMessageConstant.EXPANDS.contains(expand)) {
            LogMessageConstant.EXPAND = expand;
        }
        if (maxCount == 0) {
            maxCount = 100;
        }
        if (logQueueSize == 0) {
            logQueueSize = 10000;
        }
        if (threadPoolSize == 0) {
            threadPoolSize = 1;
        }
        int count = maxCount;
        MessageAppenderFactory.initQueue((int)logQueueSize);
        for (int a = 0; a < threadPoolSize; ++a) {
            threadPoolExecutor.execute(() -> MessageAppenderFactory.startRunLog((AbstractClient)mqClient, (int)count));
            threadPoolExecutor.execute(() -> MessageAppenderFactory.startTraceLog((AbstractClient)mqClient, (int)count));
        }
        return new MqAppender(name, appName, env, runModel, filter, layout, true, expand, maxCount, logQueueSize, threadPoolSize);
    }

    public void append(LogEvent logEvent) {
        if (logEvent == null || this.shouldIgnore(logEvent)) {
            return;
        }
        this.send(logEvent);
    }

    protected void send(LogEvent logEvent) {
        BaseLogMessage logMessage = LogMessageUtil.getLogMessage(this.appName, this.env, logEvent);
        if (logMessage instanceof RunLogMessage) {
            String message = LogMessageUtil.getLogMessage((BaseLogMessage)((RunLogMessage)logMessage), logEvent);
            MessageAppenderFactory.pushRundataQueue((String)message);
        } else {
            MessageAppenderFactory.pushTracedataQueue((String)GfJsonUtil.toJSONString((Object)logMessage));
        }
    }

    private boolean shouldIgnore(LogEvent logEvent) {
        if (logEvent.getLevel().isLessSpecificThan(Level.DEBUG)) {
            String name = logEvent.getLoggerName();
            return StringUtils.startsWithAny((CharSequence)name, (CharSequence[])IGNORE_PACKAGES);
        }
        return false;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getEnv() {
        return this.env;
    }

    public String getRunModel() {
        return this.runModel;
    }

    public String getExpand() {
        return this.expand;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public int getLogQueueSize() {
        return this.logQueueSize;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    static {
        threadPoolExecutor = ThreadPoolUtil.getPool();
    }
}

