/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.log4j2.appender;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.WebUtil;
import com.jxdinfo.hussar.support.log.log4j2.manager.HussarRollingRandomAccessFileManager;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DirectFileRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DirectWriteRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.net.Advertiser;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.Integers;

@Plugin(name="HussarRollingRandomAccessFile", category="Core", elementType="appender", printObject=true)
public final class HussarRollingRandomAccessFileAppender
extends AbstractOutputStreamAppender<HussarRollingRandomAccessFileManager> {
    private final String fileName;
    private final String filePattern;
    private final Object advertisement;
    private final Advertiser advertiser;
    private final HussarRollingRandomAccessFileManager basicManager;
    private final Map<Object, HussarRollingRandomAccessFileManager> tenantFileManager = new ConcurrentHashMap<Object, HussarRollingRandomAccessFileManager>();

    private HussarRollingRandomAccessFileAppender(String name, Layout<? extends Serializable> layout, Filter filter, HussarRollingRandomAccessFileManager manager, String fileName, String filePattern, boolean ignoreExceptions, boolean immediateFlush, int bufferSize, Advertiser advertiser, Property[] properties) {
        super(name, layout, filter, ignoreExceptions, immediateFlush, properties, (OutputStreamManager)manager);
        if (advertiser != null) {
            HashMap<String, String> configuration = new HashMap<String, String>(layout.getContentFormat());
            configuration.put("contentType", layout.getContentType());
            configuration.put("name", name);
            this.advertisement = advertiser.advertise(configuration);
        } else {
            this.advertisement = null;
        }
        this.fileName = fileName;
        this.filePattern = filePattern;
        this.advertiser = advertiser;
        this.basicManager = manager;
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(timeout, timeUnit, false);
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
        this.setStopped();
        return true;
    }

    public void append(LogEvent event) {
        String tenantCode = this.getTenantCode();
        if (HussarUtils.isNotEmpty((Object)tenantCode)) {
            this.tenantAppend(event, tenantCode);
            return;
        }
        HussarRollingRandomAccessFileManager manager = (HussarRollingRandomAccessFileManager)this.getManager();
        manager.checkRollover(event);
        manager.setEndOfBatch(event.isEndOfBatch());
        super.append(event);
    }

    private void tenantAppend(LogEvent event, String tenantCode) {
        if (!this.tenantFileManager.containsKey(tenantCode)) {
            this.createTenantFileManager(tenantCode);
        }
        HussarRollingRandomAccessFileManager manager = this.tenantFileManager.get(tenantCode);
        manager.checkRollover(event);
        manager.setEndOfBatch(event.isEndOfBatch());
        try {
            this.tryAppend(event, manager);
        }
        catch (AppenderLoggingException e) {
            this.error("Unable to write to stream " + manager.getName() + " for appender " + this.getName(), event, e);
            throw e;
        }
    }

    private void tryAppend(LogEvent event, HussarRollingRandomAccessFileManager manager) {
        if (Constants.ENABLE_DIRECT_ENCODERS) {
            this.directEncodeEvent(event, manager);
        } else {
            this.writeByteArrayToManager(event, manager);
        }
    }

    private void directEncodeEvent(LogEvent event, HussarRollingRandomAccessFileManager manager) {
        this.getLayout().encode((Object)event, (ByteBufferDestination)manager);
        if (this.getImmediateFlush() || event.isEndOfBatch()) {
            manager.flush();
        }
    }

    private void writeByteArrayToManager(LogEvent event, HussarRollingRandomAccessFileManager manager) {
        byte[] bytes = this.getLayout().toByteArray(event);
        if (bytes != null && bytes.length > 0) {
            manager.write(bytes, this.getImmediateFlush() || event.isEndOfBatch());
        }
    }

    public void createTenantFileManager(String tenantCode) {
        String filePattern;
        if (this.basicManager == null) {
            LOGGER.error("No BasicManager");
            return;
        }
        String fileName = this.addTenantPath(this.fileName, tenantCode);
        HussarRollingRandomAccessFileManager manager = HussarRollingRandomAccessFileManager.getRollingRandomAccessFileManager(fileName, filePattern = this.addTenantPath(this.filePattern, tenantCode), this.basicManager.isAppend(), this.getImmediateFlush(), this.basicManager.getBufferSize(), this.basicManager.getPolicy(), this.basicManager.getStrategy(), this.basicManager.getAdvertiseURI(), (Layout<? extends Serializable>)this.getLayout(), this.basicManager.getFilePermission(), this.basicManager.getFileOwner(), this.basicManager.getFileGroup(), this.basicManager.getConfiguration());
        if (manager == null) {
            return;
        }
        manager.initialize();
        this.tenantFileManager.put(tenantCode, manager);
    }

    public String addTenantPath(String name, String tenantCode) {
        int lastIndex = name.lastIndexOf("/");
        return name.substring(0, lastIndex) + "/" + tenantCode + name.substring(lastIndex);
    }

    public String getTenantCode() {
        HttpServletRequest request = WebUtil.getRequest();
        if (request == null) {
            return null;
        }
        return request.getHeader("tcode");
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public int getBufferSize() {
        return ((HussarRollingRandomAccessFileManager)this.getManager()).getBufferSize();
    }

    @Deprecated
    public static <B extends Builder<B>> HussarRollingRandomAccessFileAppender createAppender(String fileName, String filePattern, String append, String name, String immediateFlush, String bufferSizeStr, TriggeringPolicy policy, RolloverStrategy strategy, Layout<? extends Serializable> layout, Filter filter, String ignoreExceptions, String advertise, String advertiseURI, Configuration configuration) {
        boolean isAppend = Booleans.parseBoolean((String)append, (boolean)true);
        boolean isIgnoreExceptions = Booleans.parseBoolean((String)ignoreExceptions, (boolean)true);
        boolean isImmediateFlush = Booleans.parseBoolean((String)immediateFlush, (boolean)true);
        boolean isAdvertise = Boolean.parseBoolean(advertise);
        int bufferSize = Integers.parseInt((String)bufferSizeStr, (int)262144);
        return ((Builder)((Object)((Builder)((Object)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Object)((Builder)((Builder)((Builder)((Object)((Builder)((Object)((Builder)((Object)HussarRollingRandomAccessFileAppender.newBuilder())).withAdvertise(isAdvertise))).withAdvertiseURI(advertiseURI))).withAppend(isAppend).withBufferSize(bufferSize)).setConfiguration(configuration)).withFileName(fileName))).withFilePattern(filePattern).setFilter(filter)).setIgnoreExceptions(isIgnoreExceptions)).withImmediateFlush(isImmediateFlush)).setLayout(layout)).setName(name)).withPolicy(policy))).withStrategy(strategy))).build();
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractOutputStreamAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<HussarRollingRandomAccessFileAppender> {
        @PluginBuilderAttribute(value="fileName")
        private String fileName;
        @PluginBuilderAttribute(value="filePattern")
        private String filePattern;
        @PluginBuilderAttribute(value="append")
        private boolean append = true;
        @PluginElement(value="Policy")
        private TriggeringPolicy policy;
        @PluginElement(value="Strategy")
        private RolloverStrategy strategy;
        @PluginBuilderAttribute(value="advertise")
        private boolean advertise;
        @PluginBuilderAttribute(value="advertiseURI")
        private String advertiseURI;
        @PluginBuilderAttribute
        private String filePermissions;
        @PluginBuilderAttribute
        private String fileOwner;
        @PluginBuilderAttribute
        private String fileGroup;

        public Builder() {
            this.withBufferSize(262144);
            this.setIgnoreExceptions(true);
            this.withImmediateFlush(true);
        }

        public HussarRollingRandomAccessFileAppender build() {
            int bufferSize;
            String name = this.getName();
            if (name == null) {
                LOGGER.error("No name provided for FileAppender");
                return null;
            }
            if (this.strategy == null) {
                this.strategy = this.fileName != null ? DefaultRolloverStrategy.newBuilder().withCompressionLevelStr(String.valueOf(-1)).withConfig(this.getConfiguration()).build() : DirectWriteRolloverStrategy.newBuilder().withCompressionLevelStr(String.valueOf(-1)).withConfig(this.getConfiguration()).build();
            } else if (this.fileName == null && !(this.strategy instanceof DirectFileRolloverStrategy)) {
                LOGGER.error("RollingFileAppender '{}': When no file name is provided a DirectFileRolloverStrategy must be configured");
                return null;
            }
            if (this.filePattern == null) {
                LOGGER.error("No filename pattern provided for FileAppender with name " + name);
                return null;
            }
            if (this.policy == null) {
                LOGGER.error("A TriggeringPolicy must be provided");
                return null;
            }
            Layout layout = this.getOrCreateLayout();
            boolean immediateFlush = this.isImmediateFlush();
            HussarRollingRandomAccessFileManager manager = HussarRollingRandomAccessFileManager.getRollingRandomAccessFileManager(this.fileName, this.filePattern, this.append, immediateFlush, bufferSize = this.getBufferSize(), this.policy, this.strategy, this.advertiseURI, (Layout<? extends Serializable>)layout, this.filePermissions, this.fileOwner, this.fileGroup, this.getConfiguration());
            if (manager == null) {
                return null;
            }
            manager.initialize();
            return new HussarRollingRandomAccessFileAppender(name, layout, this.getFilter(), manager, this.fileName, this.filePattern, this.isIgnoreExceptions(), immediateFlush, bufferSize, this.advertise ? this.getConfiguration().getAdvertiser() : null, this.getPropertyArray());
        }

        public B withFileName(String fileName) {
            this.fileName = fileName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withFilePattern(String filePattern) {
            this.filePattern = filePattern;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withAppend(boolean append) {
            this.append = append;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withPolicy(TriggeringPolicy policy) {
            this.policy = policy;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withStrategy(RolloverStrategy strategy) {
            this.strategy = strategy;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withAdvertise(boolean advertise) {
            this.advertise = advertise;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withAdvertiseURI(String advertiseURI) {
            this.advertiseURI = advertiseURI;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withFilePermissions(String filePermissions) {
            this.filePermissions = filePermissions;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withFileOwner(String fileOwner) {
            this.fileOwner = fileOwner;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withFileGroup(String fileGroup) {
            this.fileGroup = fileGroup;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }
}

