/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.log4j2.filter;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;

@Plugin(name="TraceFilter", category="Core", elementType="filter", printObject=true)
public class TraceFilter
extends AbstractFilter {
    private static final String packageName = "com.jxdinfo.hussar.support.log.trace.aspect.AbstractLogTraceAspect";
    private Filter.Result onMatch;
    private Filter.Result onMisMatch;
    private Level level;

    public TraceFilter(Filter.Result onMatch, Filter.Result onMisMatch, Level level) {
        this.onMatch = onMatch;
        this.onMisMatch = onMisMatch;
        this.level = level;
    }

    @PluginFactory
    public static TraceFilter createFilter() {
        Filter.Result onMatch = Filter.Result.DENY;
        Filter.Result onMismatch = Filter.Result.NEUTRAL;
        Level level = Level.INFO;
        return new TraceFilter(onMatch, onMismatch, level);
    }

    public Filter.Result filter(LogEvent event) {
        if (this.level.equals((Object)event.getLevel()) && event.getLoggerName().equals(packageName) && event.getMessage().getFormattedMessage().startsWith("TRACE:")) {
            return this.onMatch;
        }
        return this.onMisMatch;
    }
}

