/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.log4j.appender;

import com.jxdinfo.hussar.support.log.core.AbstractClient;
import com.jxdinfo.hussar.support.log.core.MessageAppenderFactory;
import com.jxdinfo.hussar.support.log.core.constant.LogMessageConstant;
import com.jxdinfo.hussar.support.log.core.dto.BaseLogMessage;
import com.jxdinfo.hussar.support.log.core.dto.RunLogMessage;
import com.jxdinfo.hussar.support.log.core.mq.MqClient;
import com.jxdinfo.hussar.support.log.core.util.GfJsonUtil;
import com.jxdinfo.hussar.support.log.core.util.ThreadPoolUtil;
import com.jxdinfo.hussar.support.log.log4j.util.LogMessageUtil;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

public class MqAppender
extends AppenderSkeleton {
    private static final String[] IGNORE_PACKAGES = new String[]{"io.lettuce.", "redis.clients.jedis.", "com.jxdinfo.hussar.support.mq."};
    private static final AtomicBoolean INIT = new AtomicBoolean();
    private static final ThreadPoolExecutor threadPoolExecutor = ThreadPoolUtil.getPool();
    private MqClient mqClient;
    private String appName;
    private String env = "default";
    private String runModel;
    private int maxCount = 100;
    private int logQueueSize = 10000;
    private final int threadPoolSize = 1;

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getRunModel() {
        return this.runModel;
    }

    public void setRunModel(String runModel) {
        this.runModel = runModel;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public int getLogQueueSize() {
        return this.logQueueSize;
    }

    public void setLogQueueSize(int logQueueSize) {
        this.logQueueSize = logQueueSize;
    }

    public void setMqClient(MqClient mqClient) {
        this.mqClient = mqClient;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    protected void append(LoggingEvent loggingEvent) {
        if (this.runModel != null) {
            LogMessageConstant.RUN_MODEL = Integer.parseInt(this.runModel);
        }
        if (this.mqClient == null) {
            MessageAppenderFactory.initQueue((int)this.logQueueSize);
            this.mqClient = MqClient.getInstance();
            if (INIT.compareAndSet(false, true)) {
                for (int a = 0; a < this.threadPoolSize; ++a) {
                    threadPoolExecutor.execute(() -> MessageAppenderFactory.startRunLog((AbstractClient)this.mqClient, (int)this.maxCount));
                    threadPoolExecutor.execute(() -> MessageAppenderFactory.startTraceLog((AbstractClient)this.mqClient, (int)this.maxCount));
                }
            }
        }
        if (loggingEvent == null || this.shouldIgnore(loggingEvent)) {
            return;
        }
        BaseLogMessage logMessage = LogMessageUtil.getLogMessage(this.appName, this.env, loggingEvent);
        if (logMessage instanceof RunLogMessage) {
            String message = LogMessageUtil.getLogMessage(logMessage, loggingEvent);
            MessageAppenderFactory.pushRundataQueue((String)message);
        } else {
            MessageAppenderFactory.pushTracedataQueue((String)GfJsonUtil.toJSONString((Object)logMessage));
        }
    }

    private boolean shouldIgnore(LoggingEvent loggingEvent) {
        if (loggingEvent.getLevel().toInt() <= Level.DEBUG.toInt()) {
            String name = loggingEvent.getLoggerName();
            return StringUtils.startsWithAny((CharSequence)name, (CharSequence[])IGNORE_PACKAGES);
        }
        return false;
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }
}

