/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.log4j.appender;

import com.jxdinfo.hussar.support.log.core.AbstractClient;
import com.jxdinfo.hussar.support.log.core.MessageAppenderFactory;
import com.jxdinfo.hussar.support.log.core.constant.LogMessageConstant;
import com.jxdinfo.hussar.support.log.core.dto.BaseLogMessage;
import com.jxdinfo.hussar.support.log.core.dto.RunLogMessage;
import com.jxdinfo.hussar.support.log.core.kafka.KafkaProducerClient;
import com.jxdinfo.hussar.support.log.core.util.GfJsonUtil;
import com.jxdinfo.hussar.support.log.core.util.ThreadPoolUtil;
import com.jxdinfo.hussar.support.log.log4j.util.LogMessageUtil;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class KafkaAppender
extends AppenderSkeleton {
    private static final AtomicBoolean INIT = new AtomicBoolean();
    private static final ThreadPoolExecutor threadPoolExecutor = ThreadPoolUtil.getPool();
    private KafkaProducerClient kafkaClient;
    private String appName;
    private String env = "default";
    private String kafkaHosts;
    private String runModel;
    private int maxCount = 100;
    private int logQueueSize = 10000;
    private final int threadPoolSize = 1;
    private boolean compressor = false;

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getKafkaHosts() {
        return this.kafkaHosts;
    }

    public void setKafkaHosts(String kafkaHosts) {
        this.kafkaHosts = kafkaHosts;
    }

    public String getRunModel() {
        return this.runModel;
    }

    public void setRunModel(String runModel) {
        this.runModel = runModel;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public int getLogQueueSize() {
        return this.logQueueSize;
    }

    public void setLogQueueSize(int logQueueSize) {
        this.logQueueSize = logQueueSize;
    }

    public void setKafkaClient(KafkaProducerClient kafkaClient) {
        this.kafkaClient = kafkaClient;
    }

    public boolean isCompressor() {
        return this.compressor;
    }

    public void setCompressor(boolean compressor) {
        this.compressor = compressor;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    protected void append(LoggingEvent loggingEvent) {
        BaseLogMessage logMessage;
        if (this.runModel != null) {
            LogMessageConstant.RUN_MODEL = Integer.parseInt(this.runModel);
        }
        if (this.kafkaClient == null) {
            MessageAppenderFactory.initQueue((int)this.logQueueSize);
            this.kafkaClient = KafkaProducerClient.getInstance((String)this.kafkaHosts, (String)(this.compressor ? "lz4" : "none"));
            if (INIT.compareAndSet(false, true)) {
                for (int a = 0; a < this.threadPoolSize; ++a) {
                    threadPoolExecutor.execute(() -> MessageAppenderFactory.startRunLog((AbstractClient)this.kafkaClient, (int)this.maxCount));
                    threadPoolExecutor.execute(() -> MessageAppenderFactory.startTraceLog((AbstractClient)this.kafkaClient, (int)this.maxCount));
                }
            }
        }
        if ((logMessage = LogMessageUtil.getLogMessage(this.appName, this.env, loggingEvent)) instanceof RunLogMessage) {
            String message = LogMessageUtil.getLogMessage(logMessage, loggingEvent);
            MessageAppenderFactory.pushRundataQueue((String)message);
        } else {
            MessageAppenderFactory.pushTracedataQueue((String)GfJsonUtil.toJSONString((Object)logMessage));
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }
}

