/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.jsonschema.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.jsonschema.api.service.SchemaService;
import com.jxdinfo.hussar.support.jsonschema.plugin.data.Generator;
import com.jxdinfo.hussar.support.jsonschema.plugin.genertor.support.generator.config.DefaultJsonSchemaGenerator;
import com.jxdinfo.hussar.support.jsonschema.plugin.genertor.support.generator.config.JsonSchemaGenerator;
import com.jxdinfo.hussar.support.jsonschema.plugin.validator.exception.ListValidationException;
import com.jxdinfo.hussar.support.jsonschema.plugin.validator.support.struct.Schema;
import com.jxdinfo.hussar.support.jsonschema.plugin.validator.support.struct.SchemaStore;
import com.jxdinfo.hussar.support.jsonschema.plugin.validator.support.validate.Validator;
import com.jxdinfo.hussar.support.jsonschema.properties.SchemaProperties;
import java.util.ArrayList;

public class SchemaServiceImpl
implements SchemaService {
    private final JsonSchemaGenerator jsonSchemaGenerator;
    private final SchemaStore schemaStore;
    private final Validator validator;
    private final Generator generator;
    private final SchemaProperties properties;

    public SchemaServiceImpl(SchemaProperties properties) {
        this.properties = properties;
        this.jsonSchemaGenerator = HussarUtils.isNotEmpty((Object)properties.gainGeneratorConfig()) ? new DefaultJsonSchemaGenerator(properties.gainGeneratorConfig()) : new DefaultJsonSchemaGenerator();
        this.schemaStore = new SchemaStore(properties.isCacheSchema());
        SchemaProperties.Validate validate = properties.getValidate();
        this.validator = HussarUtils.isNotEmpty((Object)validate) ? new Validator(validate.isValidateFormats()) : new Validator();
        this.generator = new Generator();
    }

    public String generatorFromString(String string) throws Exception {
        return this.jsonSchemaGenerator.fromString(string);
    }

    public String generatorFromObj(Object object) throws Exception {
        String jsonString = JSON.toJSONString((Object)object);
        return this.generatorFromString(jsonString);
    }

    public void validateSchema(Object document) throws Exception {
        this.schemaStore.loadSchema(document);
    }

    public void validateSchema(String document) throws Exception {
        JSONObject jsonObject = this.getJsonObject(document);
        this.validateSchema(jsonObject);
    }

    public void validate(Object schema, Object document) throws Exception {
        Schema loadSchema = this.schemaStore.loadSchema(schema);
        this.validator.validate(loadSchema, document);
    }

    public void validate(String schema, Object document) throws Exception {
        JSONObject jsonObject = this.getJsonObject(schema);
        this.validate(jsonObject, document);
    }

    public void validateJson(Object schema, String document) throws Exception {
        JSONObject jsonObject = this.getJsonObject(document);
        this.validate(schema, (Object)jsonObject);
    }

    public HussarException validateUnchecked(Object schema, Object document) throws Exception {
        Schema loadSchema = this.schemaStore.loadSchema(schema);
        ArrayList errors = new ArrayList();
        this.validator.validate(loadSchema, document, errors::add);
        if (!errors.isEmpty()) {
            return new HussarException((Throwable)new ListValidationException(errors));
        }
        return null;
    }

    public HussarException validateJsonUnchecked(Object schema, String document) throws Exception {
        JSONObject jsonObject = this.getJsonObject(document);
        return this.validateUnchecked(schema, jsonObject);
    }

    public Object generatorData(Object schema, Object targetSchema, Object document) throws Exception {
        Schema schema1 = HussarUtils.isEmpty((Object)schema) ? null : this.schemaStore.loadSchema(schema);
        Schema schema2 = this.schemaStore.loadSchema(targetSchema);
        return this.generator.generate(schema1, schema2, document);
    }

    public Object generatorData(Object targetSchema, Object document) throws Exception {
        return this.generatorData(null, targetSchema, document);
    }

    public Object generatorData(String schema, String targetSchema, Object document) throws Exception {
        JSONObject jsonObject1 = this.getJsonObject(schema);
        JSONObject jsonObject2 = this.getJsonObject(targetSchema);
        return this.generatorData(jsonObject1, jsonObject2, document);
    }

    public Object generatorData(String targetSchema, Object document) throws Exception {
        return this.generatorData(null, targetSchema, document);
    }

    public Object translationData(String schema, Object document) throws Exception {
        Schema schema1 = this.schemaStore.loadSchema((Object)this.getJsonObject(schema));
        return this.generator.translation(schema1, document);
    }

    private JSONObject getJsonObject(String schema) {
        return JSON.parseObject((String)schema);
    }
}

