/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.execution.log.impl;

import com.jxdinfo.hussar.support.job.core.enums.LogLevel;
import com.jxdinfo.hussar.support.job.execution.background.OmsLogHandler;
import com.jxdinfo.hussar.support.job.execution.log.OmsLogger;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class OmsServerLogger
implements OmsLogger {
    private final long instanceId;
    private final OmsLogHandler omsLogHandler;

    @Override
    public void debug(String messagePattern, Object ... args) {
        this.process(LogLevel.DEBUG, messagePattern, args);
    }

    @Override
    public void info(String messagePattern, Object ... args) {
        this.process(LogLevel.INFO, messagePattern, args);
    }

    @Override
    public void warn(String messagePattern, Object ... args) {
        this.process(LogLevel.WARN, messagePattern, args);
    }

    @Override
    public void error(String messagePattern, Object ... args) {
        this.process(LogLevel.ERROR, messagePattern, args);
    }

    private static String genLogContent(String messagePattern, Object ... arg) {
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat((String)messagePattern, (Object[])arg);
        if (formattingTuple.getThrowable() != null) {
            String stackTrace = ExceptionUtils.getStackTrace((Throwable)formattingTuple.getThrowable());
            return formattingTuple.getMessage() + System.lineSeparator() + stackTrace;
        }
        return formattingTuple.getMessage();
    }

    private void process(LogLevel level, String messagePattern, Object ... args) {
        String logContent = OmsServerLogger.genLogContent(messagePattern, args);
        this.omsLogHandler.submitLog(this.instanceId, level, logContent);
    }

    public OmsServerLogger(long instanceId, OmsLogHandler omsLogHandler) {
        this.instanceId = instanceId;
        this.omsLogHandler = omsLogHandler;
    }
}

