/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.execution.core.tracker.singlemodel;

import com.jxdinfo.hussar.support.job.core.JobSerializable;
import com.jxdinfo.hussar.support.job.core.exception.SingleModelException;
import com.jxdinfo.hussar.support.job.core.execution.request.ProcessorMapTaskRequest;
import com.jxdinfo.hussar.support.job.core.execution.request.ProcessorReportTaskStatusReq;
import com.jxdinfo.hussar.support.job.core.execution.request.ProcessorTrackerStatusReportReq;
import com.jxdinfo.hussar.support.job.core.response.AskResponse;
import com.jxdinfo.hussar.support.job.core.service.ExecutionReceiveReqService;
import com.jxdinfo.hussar.support.job.execution.common.WorkerRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleTaskTrackerActor {
    private static final Logger log = LoggerFactory.getLogger(SingleTaskTrackerActor.class);
    private static ExecutionReceiveReqService executionReceiveReqService;
    private static WorkerRuntime workerRuntime;

    public static void init(ExecutionReceiveReqService executionService, WorkerRuntime runtime) {
        executionReceiveReqService = executionService;
        workerRuntime = runtime;
        if (executionReceiveReqService == null || workerRuntime == null) {
            throw new SingleModelException("Failed to initialize the SingleTaskTrackerActor.");
        }
    }

    public static void tell(JobSerializable object) {
        if (object instanceof ProcessorTrackerStatusReportReq) {
            executionReceiveReqService.onReceiveProcessorTrackerStatusReportReq((ProcessorTrackerStatusReportReq)object);
        } else if (object instanceof ProcessorReportTaskStatusReq) {
            executionReceiveReqService.onReceiveProcessorReportTaskStatusReq((ProcessorReportTaskStatusReq)object);
        } else {
            throw new SingleModelException("No suitable processing method found in SingleTaskTrackerActor#tell\uff0cobject =" + object.getClass());
        }
    }

    public static AskResponse ask(JobSerializable object) {
        if (object instanceof ProcessorMapTaskRequest) {
            return executionReceiveReqService.onReceiveProcessorMapTaskRequest((ProcessorMapTaskRequest)object);
        }
        if (object instanceof ProcessorReportTaskStatusReq) {
            AskResponse response = new AskResponse();
            try {
                SingleTaskTrackerActor.tell(object);
                response.setSuccess(true);
            }
            catch (Exception e) {
                log.error("SingleTaskTrackerActor\u4e2donReceiveProcessorReportTaskStatusReq\u6267\u884c\u5931\u8d25", (Throwable)e);
                response.setSuccess(false);
            }
            return response;
        }
        throw new SingleModelException("No suitable processing method found in SingleTaskTrackerActor#ask\uff0cobject =" + object.getClass());
    }
}

