/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.execution.persistence;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.core.execution.model.TaskDO;
import com.jxdinfo.hussar.support.job.execution.HussarJobFixedCacheUtil;
import com.jxdinfo.hussar.support.job.execution.common.constants.TaskStatus;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class TaskPersistenceService {
    private static final Logger log = LoggerFactory.getLogger(TaskPersistenceService.class);
    private static final String TASK_CACHE_NAME = "job_task_cache";
    private static final String INSTANCE_ID = "instanceId:";
    private static final String TASK_ID = "taskId:";
    public static final Set<Integer> TASK_FINISH_STATUS = Sets.newHashSet((Object[])new Integer[]{TaskStatus.WORKER_PROCESS_FAILED.getValue(), TaskStatus.WORKER_PROCESS_SUCCESS.getValue()});

    public boolean save(TaskDO task) {
        try {
            String cacheKey = this.generateKey(task.getInstanceId(), task.getTaskId());
            HussarJobFixedCacheUtil.put(TASK_CACHE_NAME, cacheKey, task);
            return true;
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] \u4fdd\u5b58 task {} \u5931\u8d25.", (Object)task, (Object)e);
            return false;
        }
    }

    public boolean batchSave(List<TaskDO> tasks) {
        if (CollectionUtils.isEmpty(tasks)) {
            return true;
        }
        try {
            tasks.forEach(task -> this.save((TaskDO)task));
            return true;
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] \u6279\u91cf\u4fdd\u5b58 tasks({}) \u5931\u8d25.", tasks, (Object)e);
            return false;
        }
    }

    public boolean updateTask(Long instanceId, String taskId, TaskDO updateEntity) {
        try {
            String key = this.generateKey(instanceId, taskId);
            TaskDO originTaskDO = (TaskDO)HussarJobFixedCacheUtil.get(TASK_CACHE_NAME, key);
            if (HussarUtils.isEmpty((Object)originTaskDO)) {
                log.error("[TaskPersistenceService] updateTask \u5931\u8d25. instanceId = {},taskId = {} \u5bf9\u5e94\u6570\u636e\u4e0d\u5b58\u5728", (Object)instanceId, (Object)taskId);
                return false;
            }
            HussarJobFixedCacheUtil.put(TASK_CACHE_NAME, key, updateEntity.updateValue(originTaskDO));
            return true;
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] updateTask \u5931\u8d25.", (Throwable)e);
            return false;
        }
    }

    public boolean updateTaskStatus(Long instanceId, String taskId, int status, long lastReportTime, String result) {
        try {
            TaskDO updateEntity = new TaskDO();
            updateEntity.setStatus(Integer.valueOf(status));
            updateEntity.setLastReportTime(Long.valueOf(lastReportTime));
            updateEntity.setResult(result);
            return this.updateTask(instanceId, taskId, updateEntity);
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] updateTaskStatus \u5931\u8d25.", (Throwable)e);
            return false;
        }
    }

    public boolean updateLostTasks(Long instanceId, List<String> addressList, boolean retry) {
        try {
            List<String> cacheKeys = HussarJobFixedCacheUtil.getKeysRightLike(TASK_CACHE_NAME, INSTANCE_ID + instanceId);
            if (HussarUtils.isEmpty(cacheKeys)) {
                return true;
            }
            cacheKeys.forEach(cacheKey -> {
                TaskDO taskDO = (TaskDO)HussarJobFixedCacheUtil.get(TASK_CACHE_NAME, cacheKey);
                if (taskDO != null && addressList.contains(taskDO.getAddress()) && TASK_FINISH_STATUS.contains(taskDO.getStatus())) {
                    taskDO.setLastModifiedTime(Long.valueOf(System.currentTimeMillis()));
                    if (retry) {
                        taskDO.setAddress("N/A");
                        taskDO.setStatus(Integer.valueOf(TaskStatus.WAITING_DISPATCH.getValue()));
                    } else {
                        taskDO.setStatus(Integer.valueOf(TaskStatus.WORKER_PROCESS_FAILED.getValue()));
                        taskDO.setResult("maybe worker down");
                    }
                }
                HussarJobFixedCacheUtil.put(TASK_CACHE_NAME, cacheKey, taskDO);
            });
            return true;
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] updateLostTasks \u6267\u884c\u5931\u8d25. instanceId = {}, addressList = {}, retry = {}", new Object[]{instanceId, addressList, retry, e});
            return false;
        }
    }

    public Optional<TaskDO> getLastTask(Long instanceId, Long subInstanceId) {
        try {
            List<String> cacheKeys = HussarJobFixedCacheUtil.getKeysRightLike(TASK_CACHE_NAME, INSTANCE_ID + instanceId);
            if (HussarUtils.isEmpty(cacheKeys)) {
                return Optional.empty();
            }
            for (String cacheKey : cacheKeys) {
                TaskDO taskDO = (TaskDO)HussarJobFixedCacheUtil.get(TASK_CACHE_NAME, cacheKey);
                if (taskDO == null || !Objects.equals(taskDO.getSubInstanceId(), subInstanceId) || !"OMS_LAST_TASK".equals(taskDO.getTaskName())) continue;
                return Optional.of(taskDO);
            }
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] getLastTask \u6267\u884c\u5931\u8d25, instanceId ={}, subInstanceId = {}", new Object[]{instanceId, subInstanceId, e});
        }
        return Optional.empty();
    }

    public List<TaskDO> getAllTask(Long instanceId, Long subInstanceId) {
        ArrayList<TaskDO> result = new ArrayList<TaskDO>();
        try {
            List<String> cacheKeys = HussarJobFixedCacheUtil.getKeysRightLike(TASK_CACHE_NAME, INSTANCE_ID + instanceId);
            for (String cacheKey : cacheKeys) {
                TaskDO taskDO = (TaskDO)HussarJobFixedCacheUtil.get(TASK_CACHE_NAME, cacheKey);
                if (taskDO == null || !Objects.equals(taskDO.getSubInstanceId(), subInstanceId)) continue;
                result.add(taskDO);
            }
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] getAllTask \u6267\u884c\u5931\u8d25\uff0cinstanceId = {}, subInstanceId = {}", new Object[]{instanceId, subInstanceId, e});
        }
        return result;
    }

    public List<TaskDO> getAllUnFinishedTaskByAddress(Long instanceId, String address) {
        ArrayList result = new ArrayList();
        try {
            List<String> cacheKeys = HussarJobFixedCacheUtil.getKeysRightLike(TASK_CACHE_NAME, INSTANCE_ID + instanceId);
            cacheKeys.forEach(cacheKey -> {
                TaskDO taskDO = (TaskDO)HussarJobFixedCacheUtil.get(TASK_CACHE_NAME, cacheKey);
                if (taskDO != null && Objects.equals(address, taskDO.getAddress()) && !TASK_FINISH_STATUS.contains(taskDO.getStatus())) {
                    result.add(taskDO);
                }
            });
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] getAllTaskByAddress \u6267\u884c\u5931\u8d25\uff0cinstanceId = {}, address = {}", new Object[]{instanceId, address, e});
        }
        return Lists.newArrayList();
    }

    public List<TaskDO> getTaskByStatus(Long instanceId, TaskStatus status, int limit) {
        ArrayList<TaskDO> result = new ArrayList<TaskDO>();
        try {
            List<String> cacheKeys = HussarJobFixedCacheUtil.getKeysRightLike(TASK_CACHE_NAME, INSTANCE_ID + instanceId);
            for (String cacheKey : cacheKeys) {
                if (result.size() < limit) {
                    TaskDO taskDO = (TaskDO)HussarJobFixedCacheUtil.get(TASK_CACHE_NAME, cacheKey);
                    if (taskDO == null || !Objects.equals(status.getValue(), taskDO.getStatus())) continue;
                    result.add(taskDO);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] getTaskByStatus \u6267\u884c\u5931\u8d25, instanceId = {},status = {}.", new Object[]{instanceId, status, e});
        }
        return result;
    }

    public Map<TaskStatus, Long> getTaskStatusStatistics(Long instanceId, Long subInstanceId) {
        try {
            List<String> cacheKeys = HussarJobFixedCacheUtil.getKeysRightLike(TASK_CACHE_NAME, INSTANCE_ID + instanceId);
            ArrayList<TaskDO> taskDOList = new ArrayList<TaskDO>();
            for (String cacheKey : cacheKeys) {
                TaskDO taskDO2 = (TaskDO)HussarJobFixedCacheUtil.get(TASK_CACHE_NAME, cacheKey);
                if (taskDO2 == null || !Objects.equals(taskDO2.getSubInstanceId(), subInstanceId)) continue;
                taskDOList.add(taskDO2);
            }
            return taskDOList.stream().collect(Collectors.groupingBy(taskDO -> TaskStatus.of(taskDO.getStatus()), Collectors.counting()));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] getTaskStatusStatistics \u6267\u884c\u5931\u8d25\uff0cinstanceId = {}, subInstanceId = {}", new Object[]{instanceId, subInstanceId, e});
            return Maps.newHashMap();
        }
    }

    public List<TaskResult> getAllTaskResult(Long instanceId, Long subInstanceId) {
        try {
            return this.getAllTask(instanceId, subInstanceId).stream().filter(taskDO -> TASK_FINISH_STATUS.contains(taskDO.getStatus())).map(taskDO -> {
                TaskResult result = new TaskResult();
                result.setTaskId(taskDO.getTaskId());
                result.setSuccess(Objects.equals(taskDO.getStatus(), TaskStatus.WORKER_PROCESS_SUCCESS.getValue()));
                result.setResult(taskDO.getResult());
                return result;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] getTaskId2ResultMap \u6267\u884c\u5931\u8d25\uff0cinstanceId = {}, subInstanceId = {},", new Object[]{instanceId, subInstanceId, e});
            return Lists.newLinkedList();
        }
    }

    public Optional<TaskStatus> getTaskStatus(Long instanceId, String taskId) {
        try {
            TaskDO taskDO = (TaskDO)HussarJobFixedCacheUtil.get(TASK_CACHE_NAME, this.generateKey(instanceId, taskId));
            return taskDO == null ? Optional.empty() : Optional.of(TaskStatus.of(taskDO.getStatus()));
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] getTaskStatus failed, instanceId={},taskId={}.", new Object[]{instanceId, taskId, e});
            return Optional.empty();
        }
    }

    public Optional<TaskDO> getTask(Long instanceId, String taskId) {
        try {
            TaskDO taskDO = (TaskDO)HussarJobFixedCacheUtil.get(TASK_CACHE_NAME, this.generateKey(instanceId, taskId));
            return taskDO == null ? Optional.empty() : Optional.of(taskDO);
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] getTask \u6267\u884c\u5931\u8d25, instanceId={}, taskId={}.", new Object[]{instanceId, taskId, e});
            return Optional.empty();
        }
    }

    public boolean deleteAllTasks(Long instanceId) {
        try {
            HussarJobFixedCacheUtil.evictKeysRightLike(TASK_CACHE_NAME, INSTANCE_ID + instanceId);
            return true;
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] deleteAllTasks failed, instanceId={}.", (Object)instanceId, (Object)e);
            return false;
        }
    }

    public boolean deleteAllSubInstanceTasks(Long instanceId, Long subInstanceId) {
        try {
            HussarJobFixedCacheUtil.getKeysRightLike(TASK_CACHE_NAME, INSTANCE_ID + instanceId).stream().map(cacheKey -> {
                TaskDO taskDO = (TaskDO)HussarJobFixedCacheUtil.get(TASK_CACHE_NAME, cacheKey);
                if (taskDO != null && Objects.equals(taskDO.getSubInstanceId(), subInstanceId)) {
                    return this.generateKey(instanceId, taskDO.getTaskId());
                }
                return "";
            }).filter(HussarUtils::isNotEmpty).forEach(doDeleteKey -> HussarJobFixedCacheUtil.evict(TASK_CACHE_NAME, doDeleteKey));
            return true;
        }
        catch (Exception e) {
            log.error("[TaskPersistenceService] deleteAllTasks \u6267\u884c\u5931\u8d25, instanceId = {}, subInstanceId = {}", new Object[]{instanceId, subInstanceId, e});
            return false;
        }
    }

    private String generateKey(Long instanceId, String taskId) {
        return INSTANCE_ID + instanceId + TASK_ID + taskId;
    }
}

