/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.execution;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.support.HussarCache;
import com.jxdinfo.hussar.support.cache.support.NoCacheManagerException;
import com.jxdinfo.hussar.support.cache.support.properties.HussarCacheProperties;
import com.jxdinfo.hussar.support.cache.util.AbstractHussarCacheOperator;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class HussarJobFixedCacheUtil
extends AbstractHussarCacheOperator {
    private static HussarCacheProperties hussarCacheProperties;

    protected static HussarCache getCache(String cacheName) {
        if (StringUtils.isEmpty((Object)cacheName)) {
            throw new NoCacheManagerException("The name of the cache cannot be empty.");
        }
        if (HussarUtils.isEmpty((Object)hussarCacheProperties)) {
            hussarCacheProperties = (HussarCacheProperties)SpringContextUtil.getBean(HussarCacheProperties.class);
        }
        if ("ehcache".equals(hussarCacheProperties.getCacheType())) {
            return (HussarCache)HussarJobFixedCacheUtil.getHussarCacheManager().getCache(StringUtil.addPrefixIfNot((CharSequence)cacheName, (CharSequence)"fixed_cache_name_prefix::"));
        }
        return (HussarCache)HussarJobFixedCacheUtil.getHussarJobCacheManager().getCache(StringUtil.addPrefixIfNot((CharSequence)cacheName, (CharSequence)"fixed_cache_name_prefix::"));
    }

    protected static CacheManager getHussarJobCacheManager() {
        Optional<Object> bean = Optional.ofNullable(SpringContextUtil.getBean((String)"jobLocalCacheManager"));
        if (!bean.isPresent()) {
            throw new NoCacheManagerException("Failed to retrieve the cache object.");
        }
        return (CacheManager)bean.get();
    }

    public static void put(String cacheName, Object key, @Nullable Object value) {
        Long keyExpireTime = HussarJobFixedCacheUtil.getCache(cacheName).getKeyExpireTime(key);
        if (HussarUtils.isEmpty((Object)keyExpireTime)) {
            HussarJobFixedCacheUtil.getCache(cacheName).put(key, value, Duration.ZERO);
        } else {
            HussarJobFixedCacheUtil.getCache(cacheName).put(key, value, keyExpireTime.longValue());
        }
    }

    public static void put(String cacheName, Object key, Object value, long seconds) {
        HussarJobFixedCacheUtil.getCache(cacheName).put(key, value, seconds);
    }

    public static <T> T putIfAbsent(String cacheName, Object key, @Nullable T value) {
        Cache.ValueWrapper valueWrapper = HussarJobFixedCacheUtil.getCache(cacheName).putIfAbsent(key, value);
        if (valueWrapper == null) {
            return value;
        }
        return (T)valueWrapper.get();
    }

    public static <T> T putIfAbsent(String cacheName, Object key, @Nullable T value, long seconds) {
        Cache.ValueWrapper valueWrapper = HussarJobFixedCacheUtil.getCache(cacheName).putIfAbsent(key, value, seconds);
        if (valueWrapper == null) {
            return value;
        }
        return (T)valueWrapper.get();
    }

    public static <T> T get(String cacheName, Object key, @Nullable Class<T> type) {
        Object t = null;
        try {
            t = HussarJobFixedCacheUtil.getCache(cacheName).get(key, type);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)t;
    }

    public static <T> T get(String cacheName, Object key) {
        Cache.ValueWrapper valueWrapper = HussarJobFixedCacheUtil.getCache(cacheName).get(key);
        if (valueWrapper == null) {
            return null;
        }
        return (T)valueWrapper.get();
    }

    public static boolean containKey(String cacheName, Object key) {
        if (StringUtils.isEmpty((Object)key)) {
            return false;
        }
        return HussarJobFixedCacheUtil.getCache(cacheName).containKey(key);
    }

    public static List<String> getKeysLeftLike(String cacheName, String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return null;
        }
        key = "*" + key;
        return HussarJobFixedCacheUtil.getCache(cacheName).getKeys(key);
    }

    public static List<String> getKeysRightLike(String cacheName, String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return null;
        }
        key = key + "*";
        return HussarJobFixedCacheUtil.getCache(cacheName).getKeys(key);
    }

    public static List<String> getKeysLike(String cacheName, String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return null;
        }
        key = "*" + key + "*";
        return HussarJobFixedCacheUtil.getCache(cacheName).getKeys(key);
    }

    public static List<String> getKeys(String cacheName, String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return null;
        }
        return HussarJobFixedCacheUtil.getCache(cacheName).getKeys(key);
    }

    public static List<String> scanKeys(String cacheName, String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return null;
        }
        return HussarJobFixedCacheUtil.getCache(cacheName).scanKeys(key);
    }

    public static void evict(String cacheName, Object key) {
        HussarJobFixedCacheUtil.getCache(cacheName).evict(key);
    }

    public static void evictKeysLike(String cacheName, String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return;
        }
        key = "*" + key + "*";
        HussarJobFixedCacheUtil.getCache(cacheName).evictKeys(key);
    }

    public static void evictKeysLeftLike(String cacheName, String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return;
        }
        key = "*" + key;
        HussarJobFixedCacheUtil.getCache(cacheName).evictKeys(key);
    }

    public static void evictKeysRightLike(String cacheName, String key) {
        if (StringUtils.isEmpty((Object)key)) {
            return;
        }
        key = key + "*";
        HussarJobFixedCacheUtil.getCache(cacheName).evictKeys(key);
    }

    public static Long getKeyExpireTime(String cacheName, String key) {
        return HussarJobFixedCacheUtil.getCache(cacheName).getKeyExpireTime((Object)key);
    }
}

