/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.execution.core.processor.sdk;

import com.jxdinfo.hussar.support.job.core.JobSerializable;
import com.jxdinfo.hussar.support.job.core.exception.JobCheckedException;
import com.jxdinfo.hussar.support.job.core.execution.model.TaskDO;
import com.jxdinfo.hussar.support.job.core.execution.request.ProcessorMapTaskRequest;
import com.jxdinfo.hussar.support.job.execution.common.ThreadLocalStore;
import com.jxdinfo.hussar.support.job.execution.common.WorkerRuntime;
import com.jxdinfo.hussar.support.job.execution.common.utils.AkkaUtils;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import com.jxdinfo.hussar.support.job.execution.core.tracker.singlemodel.SingleTaskTrackerActor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public interface MapProcessor
extends BasicProcessor {
    public static final Logger log = LoggerFactory.getLogger(MapProcessor.class);
    public static final int RECOMMEND_BATCH_SIZE = 200;

    default public void map(List<?> taskList, String taskName) throws JobCheckedException {
        boolean requestSucceed;
        if (CollectionUtils.isEmpty(taskList)) {
            return;
        }
        TaskDO task = ThreadLocalStore.getTask();
        WorkerRuntime workerRuntime = ThreadLocalStore.getRuntimeMeta();
        if (taskList.size() > 200) {
            log.warn("[Map-{}] map task size is too large, network maybe overload... please try to split the tasks.", (Object)task.getInstanceId());
        }
        if ("OMS_ROOT_TASK".equals(taskName) || "OMS_LAST_TASK".equals(taskName)) {
            log.warn("[Map-{}] illegal map task name : {}! please do not use 'OMS_ROOT_TASK' or 'OMS_LAST_TASK' as map task name. as a precaution, it will be renamed 'X-{}' automatically.", new Object[]{task.getInstanceId(), taskName, taskName});
            taskName = "X-" + taskName;
        }
        ProcessorMapTaskRequest req = new ProcessorMapTaskRequest(task, taskList, taskName);
        if (workerRuntime.isSingleModel()) {
            requestSucceed = SingleTaskTrackerActor.ask((JobSerializable)req).isSuccess();
        } else {
            String akkaRemotePath = AkkaUtils.getAkkaWorkerPath(task.getAddress(), "task_tracker");
            requestSucceed = AkkaUtils.reliableTransmit(workerRuntime.getActorSystem().actorSelection(akkaRemotePath), req);
        }
        if (!requestSucceed) {
            throw new JobCheckedException("map failed for task: " + taskName);
        }
        log.info("[Map-{}] map task[name={},num={}] successfully!", new Object[]{task.getInstanceId(), taskName, taskList.size()});
    }

    default public boolean isRootTask() {
        TaskDO task = ThreadLocalStore.getTask();
        return "OMS_ROOT_TASK".equals(task.getTaskName());
    }
}

