/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.execution.core.ha;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.support.job.core.execution.request.ProcessorTrackerStatusReportReq;
import com.jxdinfo.hussar.support.job.execution.core.ha.ProcessorTrackerStatus;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorTrackerStatusHolder {
    private static Logger log = LoggerFactory.getLogger(ProcessorTrackerStatusHolder.class);
    private final Map<String, ProcessorTrackerStatus> address2Status = Maps.newConcurrentMap();

    public ProcessorTrackerStatusHolder(List<String> allWorkerAddress) {
        allWorkerAddress.forEach(address -> {
            ProcessorTrackerStatus pts = new ProcessorTrackerStatus();
            pts.init((String)address);
            this.address2Status.put((String)address, pts);
        });
    }

    public ProcessorTrackerStatus getProcessorTrackerStatus(String address) {
        return this.address2Status.computeIfAbsent(address, ignore -> {
            log.warn("[ProcessorTrackerStatusHolder] unregistered worker: {}", (Object)address);
            ProcessorTrackerStatus processorTrackerStatus = new ProcessorTrackerStatus();
            processorTrackerStatus.init(address);
            return processorTrackerStatus;
        });
    }

    public void updateStatus(ProcessorTrackerStatusReportReq heartbeatReq) {
        this.getProcessorTrackerStatus(heartbeatReq.getAddress()).update(heartbeatReq);
    }

    public List<String> getAvailableProcessorTrackers() {
        LinkedList result = Lists.newLinkedList();
        this.address2Status.forEach((address, ptStatus) -> {
            if (ptStatus.available()) {
                result.add(address);
            }
        });
        return result;
    }

    public List<String> getAllProcessorTrackers() {
        return Lists.newArrayList(this.address2Status.keySet());
    }

    public List<String> getAllDisconnectedProcessorTrackers() {
        LinkedList result = Lists.newLinkedList();
        this.address2Status.forEach((ip, ptStatus) -> {
            if (ptStatus.isTimeout()) {
                result.add(ip);
            }
        });
        return result;
    }

    public boolean register(String address) {
        ProcessorTrackerStatus pts = this.address2Status.get(address);
        if (pts != null) {
            return false;
        }
        pts = new ProcessorTrackerStatus();
        pts.init(address);
        this.address2Status.put(address, pts);
        return true;
    }

    public void remove(List<String> addressList) {
        addressList.forEach(this.address2Status::remove);
    }
}

