/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.execution.core.ha;

import com.jxdinfo.hussar.support.job.core.execution.request.ProcessorTrackerStatusReportReq;

public class ProcessorTrackerStatus {
    private static final int DISPATCH_THRESHOLD = 20;
    private static final int HEARTBEAT_TIMEOUT_MS = 60000;
    private String address;
    private long lastActiveTime;
    private long remainTaskNum;
    private boolean dispatched;
    private boolean connected;

    public void init(String address) {
        this.address = address;
        this.lastActiveTime = -1L;
        this.remainTaskNum = 0L;
        this.dispatched = false;
        this.connected = false;
    }

    public void update(ProcessorTrackerStatusReportReq req) {
        if (req.getTime() <= this.lastActiveTime) {
            return;
        }
        this.address = req.getAddress();
        this.lastActiveTime = req.getTime();
        this.remainTaskNum = req.getRemainTaskNum();
        this.dispatched = true;
        this.connected = true;
    }

    public boolean available() {
        if (!this.dispatched) {
            return true;
        }
        if (!this.connected) {
            return false;
        }
        if (this.isTimeout()) {
            return false;
        }
        return this.remainTaskNum < 20L;
    }

    public boolean isTimeout() {
        if (this.dispatched) {
            return System.currentTimeMillis() - this.lastActiveTime > 60000L;
        }
        return false;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public long getLastActiveTime() {
        return this.lastActiveTime;
    }

    public void setLastActiveTime(long lastActiveTime) {
        this.lastActiveTime = lastActiveTime;
    }

    public long getRemainTaskNum() {
        return this.remainTaskNum;
    }

    public void setRemainTaskNum(long remainTaskNum) {
        this.remainTaskNum = remainTaskNum;
    }

    public boolean isDispatched() {
        return this.dispatched;
    }

    public void setDispatched(boolean dispatched) {
        this.dispatched = dispatched;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }
}

