/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.web.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.support.job.core.enums.InstanceStatus;
import com.jxdinfo.hussar.support.job.core.response.ResultDTO;
import com.jxdinfo.hussar.support.job.dispatch.api.entity.JobInfoEntity;
import com.jxdinfo.hussar.support.job.dispatch.common.constants.SwitchableStatus;
import com.jxdinfo.hussar.support.job.dispatch.dao.entity.JobInstanceInfoEntity;
import com.jxdinfo.hussar.support.job.dispatch.dao.service.JobInfoService;
import com.jxdinfo.hussar.support.job.dispatch.dao.service.JobInstanceInfoService;
import com.jxdinfo.hussar.support.job.dispatch.remote.server.ServerInfoService;
import com.jxdinfo.hussar.support.job.dispatch.remote.worker.WorkerClusterQueryService;
import com.jxdinfo.hussar.support.job.dispatch.web.response.SystemOverviewVO;
import com.jxdinfo.hussar.support.job.dispatch.web.response.WorkerStatusVO;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system"})
public class SystemInfoController {
    @Resource
    private JobInfoService jobInfoService;
    @Resource
    private JobInstanceInfoService jobInstanceInfoService;
    @Resource
    private ServerInfoService serverInfoService;
    @Resource
    private WorkerClusterQueryService workerClusterQueryService;

    @GetMapping(value={"/listWorker"})
    public ResultDTO<List<WorkerStatusVO>> listWorker(Long appId) {
        List workerInfos = this.workerClusterQueryService.getAllWorkers(appId);
        return ResultDTO.success(workerInfos.stream().map(WorkerStatusVO::new).collect(Collectors.toList()));
    }

    @GetMapping(value={"/overview"})
    public ResultDTO<SystemOverviewVO> getSystemOverview(Long appId) {
        SystemOverviewVO overview = new SystemOverviewVO();
        overview.setJobCount(this.jobInfoService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobInfoEntity::getAppId, (Object)appId)).ne(JobInfoEntity::getStatus, (Object)SwitchableStatus.DELETED.getV())));
        overview.setRunningInstanceCount(this.jobInstanceInfoService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobInstanceInfoEntity::getAppId, (Object)appId)).eq(JobInstanceInfoEntity::getStatus, (Object)InstanceStatus.RUNNING.getV())));
        Date date = DateUtils.addDays((Date)new Date(), (int)-1);
        overview.setFailedInstanceCount(this.jobInstanceInfoService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobInstanceInfoEntity::getAppId, (Object)appId)).eq(JobInstanceInfoEntity::getStatus, (Object)InstanceStatus.FAILED.getV())).ge(HussarBaseEntity::getCreateTime, (Object)date)));
        overview.setTimezone(TimeZone.getDefault().getDisplayName());
        overview.setServerTime(LocalDateTime.now());
        SystemOverviewVO.CurrentServerInfo info = new SystemOverviewVO.CurrentServerInfo(this.serverInfoService.getServerId(), this.serverInfoService.getServerIp(), this.serverInfoService.getServerVersion());
        overview.setCurrentServerInfo(info);
        return ResultDTO.success((Object)overview);
    }
}

