/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.web.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.job.core.response.ResultDTO;
import com.jxdinfo.hussar.support.job.core.support.JobAppInfoService;
import com.jxdinfo.hussar.support.job.core.support.entity.JobAppInfoEntity;
import com.jxdinfo.hussar.support.job.core.utils.CommonUtils;
import com.jxdinfo.hussar.support.job.core.utils.NetUtils;
import com.jxdinfo.hussar.support.job.dispatch.remote.server.election.ServerElectionService;
import com.jxdinfo.hussar.support.job.dispatch.remote.transport.TransportService;
import com.jxdinfo.hussar.support.job.dispatch.remote.worker.WorkerClusterQueryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Optional;
import java.util.TimeZone;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/server"})
@Api(value="server", tags={"\u5904\u7406Worker\u5bf9server\u8bf7\u6c42"})
public class ServerController {
    @Resource
    private TransportService transportService;
    @Resource
    private ServerElectionService serverElectionService;
    @Resource
    private JobAppInfoService jobAppInfoService;
    @Resource
    private WorkerClusterQueryService workerClusterQueryService;

    @GetMapping(value={"/assert"})
    @ApiOperation(value="\u9a8c\u8bc1appName\u7684\u53ef\u7528\u6027", notes="\u9a8c\u8bc1appName\u7684\u53ef\u7528\u6027")
    public ApiResponse<Long> assertAppName(@ApiParam(value="\u5e94\u7528\u540d") String appName) {
        Optional<Object> appInfoOpt = Optional.ofNullable(this.jobAppInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(JobAppInfoEntity::getAppName, (Object)appName)));
        return appInfoOpt.map(appInfoDO -> ApiResponse.success((Object)appInfoDO.getId())).orElseGet(() -> ApiResponse.fail((String)String.format("\u5e94\u7528(%s)\u4e0d\u5b58\u5728,\u8bf7\u786e\u8ba4\u914d\u7f6e\u7684\u5e94\u7528\u4fe1\u606f\u662f\u5426\u6b63\u786e.", appName)));
    }

    @GetMapping(value={"/acquire"})
    @ApiOperation(value="\u83b7\u53d6\u53ef\u7528server\u5730\u5740", notes="\u83b7\u53d6\u53ef\u7528server\u5730\u5740")
    public ResultDTO<String> acquireServer(@ApiParam(value="\u5e94\u7528id") Long appId, @ApiParam(value="\u901a\u4fe1\u534f\u8bae") String protocol, @ApiParam(value="\u5f53\u524dserver\u5730\u5740") String currentServer) {
        return ResultDTO.success((Object)this.serverElectionService.elect(appId, protocol, currentServer));
    }

    @GetMapping(value={"/hello"})
    @ApiOperation(value="worker\u9a8c\u8bc1\u662f\u5426\u53ef\u4e0eserver\u901a\u4fe1\u6210\u529f", notes="worker\u9a8c\u8bc1\u662f\u5426\u53ef\u4e0eserver\u901a\u4fe1\u6210\u529f")
    public ResultDTO<JSONObject> ping(@ApiParam(value="\u662f\u5426\u4e3a\u8c03\u8bd5\u6a21\u5f0f") @RequestParam(required=false) boolean debug) {
        JSONObject res = new JSONObject();
        res.put("localHost", (Object)NetUtils.getLocalHost());
        res.put("communicationSystemInfo", (Object)TransportService.getProtocol2Transporter());
        res.put("serverTime", (Object)CommonUtils.formatTime((Long)System.currentTimeMillis()));
        res.put("serverTimeZone", (Object)TimeZone.getDefault().getDisplayName());
        res.put("appIds", this.workerClusterQueryService.getAppId2ClusterStatus().keySet());
        if (debug) {
            res.put("appId2ClusterInfo", (Object)JSON.parseObject((String)JSON.toJSONString((Object)this.workerClusterQueryService.getAppId2ClusterStatus())));
        }
        return ResultDTO.success((Object)res);
    }
}

