/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.web.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.job.core.exception.JobRuntimeException;
import com.jxdinfo.hussar.support.job.core.support.JobAppInfoService;
import com.jxdinfo.hussar.support.job.core.support.entity.JobAppInfoEntity;
import com.jxdinfo.hussar.support.job.dispatch.core.service.AppInfoService;
import com.jxdinfo.hussar.support.job.dispatch.web.request.AppAssertRequest;
import com.jxdinfo.hussar.support.job.dispatch.web.request.ModifyAppInfoRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/appInfo"})
@AuditLog(moduleName="\u5e94\u7528\u7ba1\u7406")
@Api(value="appInfo", tags={"\u5e94\u7528\u7ba1\u7406"})
public class AppInfoController {
    @Resource
    private AppInfoService appInfoService;
    @Resource
    private JobAppInfoService jobAppInfoService;
    private static final int MAX_APP_NUM = 200;

    @PostMapping(value={"/save"})
    @AuditLog(eventDesc="\u65b0\u589e\u5e94\u7528", evnetType=AuditEventType.INSERT, eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE)
    @ApiOperation(value="\u65b0\u589e\u5e94\u7528", notes="\u65b0\u589e\u5e94\u7528")
    public ApiResponse saveAppInfo(@ApiParam(value="\u5f85\u65b0\u589e\u5e94\u7528\u4fe1\u606f") @RequestBody ModifyAppInfoRequest req) {
        JobAppInfoEntity appInfoDO;
        req.valid();
        Long id = req.getId();
        JobAppInfoEntity appInfoEntity = this.jobAppInfoService.getAppInfoByAppName(req.getAppName());
        if (HussarUtils.isNotEmpty((Object)appInfoEntity) && (HussarUtils.isEmpty((Object)id) || !HussarUtils.equals((Object)id, (Object)appInfoEntity.getId()))) {
            return ApiResponse.fail((String)"\u5e94\u7528\u540d\u79f0\u5df2\u5b58\u5728!");
        }
        if (id == null) {
            appInfoDO = new JobAppInfoEntity();
        } else {
            appInfoDO = (JobAppInfoEntity)Optional.ofNullable(this.jobAppInfoService.getById((Serializable)id)).orElseThrow(() -> new IllegalArgumentException("can't find appInfo by id:" + id));
            if (!Objects.equals(req.getOldPassword(), appInfoDO.getPassword())) {
                throw new JobRuntimeException("The password is incorrect.");
            }
        }
        BeanUtils.copyProperties((Object)req, (Object)appInfoDO);
        this.jobAppInfoService.saveOrUpdate((Object)appInfoDO);
        return ApiResponse.success();
    }

    @PostMapping(value={"/assert"})
    @ApiOperation(value="\u9a8c\u8bc1\u5e94\u7528", notes="\u9a8c\u8bc1\u5e94\u7528")
    public ApiResponse<Long> assertApp(@ApiParam(value="\u5f85\u9a8c\u8bc1\u5e94\u7528\u4fe1\u606f") @RequestBody AppAssertRequest request) {
        return ApiResponse.success((Object)this.appInfoService.assertApp(request.getAppName(), request.getPassword()));
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u5e94\u7528", notes="\u5220\u9664\u5e94\u7528")
    @AuditLog(eventDesc="\u5220\u9664\u5e94\u7528", evnetType=AuditEventType.DELETE, eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE)
    public ApiResponse<Void> deleteAppInfo(@ApiParam(value="\u5e94\u7528id") @RequestBody Long appId) {
        this.jobAppInfoService.removeById((Serializable)appId);
        return ApiResponse.success();
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u67e5\u8be2\u5e94\u7528\u5217\u8868", notes="\u67e5\u8be2\u5e94\u7528\u5217\u8868")
    public ApiResponse<List<AppInfoVO>> listAppInfo(@ApiParam(value="\u5e94\u7528\u540d") @RequestParam(required=false) String condition) {
        Page page = new Page(0L, 200L);
        List result = ((Page)this.jobAppInfoService.page((IPage)page, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(HussarUtils.isNotEmpty((Object)condition), JobAppInfoEntity::getAppName, (Object)condition)).orderByDesc(JobAppInfoEntity::getId))).getRecords();
        return ApiResponse.success(AppInfoController.convert(result));
    }

    private static List<AppInfoVO> convert(List<JobAppInfoEntity> data) {
        if (CollectionUtils.isEmpty(data)) {
            return Lists.newLinkedList();
        }
        return data.stream().map(appInfoDO -> {
            AppInfoVO appInfoVO = new AppInfoVO();
            BeanUtils.copyProperties((Object)appInfoDO, (Object)appInfoVO);
            return appInfoVO;
        }).collect(Collectors.toList());
    }

    @GetMapping(value={"/page"})
    @AuditLog(eventDesc="\u67e5\u8be2\u5e94\u7528\u5217\u8868", evnetType=AuditEventType.QUERY, eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE)
    @ApiOperation(value="\u5e94\u7528\u4fe1\u606f\u5206\u9875\u67e5\u8be2", notes="\u5e94\u7528\u4fe1\u606f\u5206\u9875\u67e5\u8be2")
    public ApiResponse<Page<AppInfoVO>> pageAppInfo(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page<JobAppInfoEntity> page, @ApiParam(value="\u5f85\u67e5\u8be2\u5e94\u7528\u4fe1\u606f") JobAppInfoEntity jobAppInfoEntity) {
        page = (Page)this.jobAppInfoService.page(page, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(HussarUtils.isNotEmpty((Object)jobAppInfoEntity.getAppName()), JobAppInfoEntity::getAppName, (Object)jobAppInfoEntity.getAppName())).orderByDesc(JobAppInfoEntity::getId));
        return ApiResponse.success(AppInfoController.pageConvert((Page<JobAppInfoEntity>)page));
    }

    private static Page<AppInfoVO> pageConvert(Page<JobAppInfoEntity> page) {
        Page voPage = new Page(page.getCurrent(), page.getSize());
        voPage.setRecords(AppInfoController.convert(page.getRecords()));
        voPage.setTotal(page.getTotal());
        return voPage;
    }

    @ApiModel(value="\u5e94\u7528\u4fe1\u606f")
    private static class AppInfoVO {
        @ApiModelProperty(value="\u5e94\u7528id")
        private Long id;
        @ApiModelProperty(value="\u5e94\u7528\u540d")
        private String appName;

        private AppInfoVO() {
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }
    }
}

