/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.web.response;

import com.jxdinfo.hussar.support.job.core.model.SystemMetrics;
import com.jxdinfo.hussar.support.job.core.utils.CommonUtils;
import com.jxdinfo.hussar.support.job.dispatch.common.module.WorkerInfo;
import java.text.DecimalFormat;

public class WorkerStatusVO {
    private String address;
    private String cpuLoad;
    private String memoryLoad;
    private String diskLoad;
    private String protocol;
    private String tag;
    private String lastActiveTime;
    private int status;
    private static final String CPU_FORMAT = "%s / %s cores";
    private static final String OTHER_FORMAT = "%s%%\uff08%s / %s GB\uff09";
    private static final DecimalFormat df = new DecimalFormat("#.#");
    private static final double THRESHOLD = 0.8;

    public WorkerStatusVO(WorkerInfo workerInfo) {
        SystemMetrics systemMetrics = workerInfo.getSystemMetrics();
        this.status = 1;
        this.address = workerInfo.getAddress();
        this.cpuLoad = String.format(CPU_FORMAT, df.format(systemMetrics.getCpuLoad()), systemMetrics.getCpuProcessors());
        if (systemMetrics.getCpuLoad() > (double)systemMetrics.getCpuProcessors() * 0.8) {
            ++this.status;
        }
        String menL = df.format(systemMetrics.getJvmMemoryUsage() * 100.0);
        String menUsed = df.format(systemMetrics.getJvmUsedMemory());
        String menMax = df.format(systemMetrics.getJvmMaxMemory());
        this.memoryLoad = String.format(OTHER_FORMAT, menL, menUsed, menMax);
        if (systemMetrics.getJvmMemoryUsage() > 0.8) {
            ++this.status;
        }
        String diskL = df.format(systemMetrics.getDiskUsage() * 100.0);
        String diskUsed = df.format(systemMetrics.getDiskUsed());
        String diskMax = df.format(systemMetrics.getDiskTotal());
        this.diskLoad = String.format(OTHER_FORMAT, diskL, diskUsed, diskMax);
        if (systemMetrics.getDiskUsage() > 0.8) {
            ++this.status;
        }
        if (workerInfo.timeout()) {
            this.status = 9999;
        }
        this.protocol = workerInfo.getProtocol();
        this.tag = CommonUtils.formatString((String)workerInfo.getTag());
        this.lastActiveTime = CommonUtils.formatTime((Long)workerInfo.getLastActiveTime());
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCpuLoad() {
        return this.cpuLoad;
    }

    public void setCpuLoad(String cpuLoad) {
        this.cpuLoad = cpuLoad;
    }

    public String getMemoryLoad() {
        return this.memoryLoad;
    }

    public void setMemoryLoad(String memoryLoad) {
        this.memoryLoad = memoryLoad;
    }

    public String getDiskLoad() {
        return this.diskLoad;
    }

    public void setDiskLoad(String diskLoad) {
        this.diskLoad = diskLoad;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getLastActiveTime() {
        return this.lastActiveTime;
    }

    public void setLastActiveTime(String lastActiveTime) {
        this.lastActiveTime = lastActiveTime;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public static String getCpuFormat() {
        return CPU_FORMAT;
    }

    public static String getOtherFormat() {
        return OTHER_FORMAT;
    }

    public static DecimalFormat getDf() {
        return df;
    }

    public static double getTHRESHOLD() {
        return 0.8;
    }
}

