/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.web.response;

import com.google.common.collect.Lists;
import com.jxdinfo.hussar.support.job.core.enums.DispatchStrategy;
import com.jxdinfo.hussar.support.job.core.enums.ExecuteType;
import com.jxdinfo.hussar.support.job.core.enums.ProcessorType;
import com.jxdinfo.hussar.support.job.core.enums.TimeExpressionType;
import com.jxdinfo.hussar.support.job.dispatch.api.entity.JobInfoEntity;
import com.jxdinfo.hussar.support.job.dispatch.common.SJ;
import com.jxdinfo.hussar.support.job.dispatch.common.constants.SwitchableStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

@ApiModel(value="\u4efb\u52a1\u4fe1\u606f\u5bf9\u5916\u5c55\u793aVO")
public class JobInfoVO {
    @ApiModelProperty(value="\u4efb\u52a1id")
    private Long id;
    @ApiModelProperty(value="\u4efb\u52a1\u540d")
    private String jobName;
    @ApiModelProperty(value="\u4efb\u52a1\u63cf\u8ff0")
    private String jobDescription;
    @ApiModelProperty(value="\u4efb\u52a1\u6240\u5c5e\u7684\u5e94\u7528ID")
    private Long appId;
    @ApiModelProperty(value="\u4efb\u52a1\u53c2\u6570")
    private String jobParams;
    @ApiModelProperty(value="\u65f6\u95f4\u8868\u8fbe\u5f0f\u7c7b\u578b", example="CRON\u3001API\u3001FIX_RATE\u3001FIX_DELAY")
    private String timeExpressionType;
    @ApiModelProperty(value="\u65f6\u95f4\u8868\u8fbe\u5f0f")
    private String timeExpression;
    @ApiModelProperty(value="\u6267\u884c\u7c7b\u578b, \u5355\u673a/\u5e7f\u64ad/MR")
    private String executeType;
    @ApiModelProperty(value="\u6267\u884c\u5668\u7c7b\u578b, Java/Shell")
    private String processorType;
    @ApiModelProperty(value="\u6267\u884c\u5668\u4fe1\u606f")
    private String processorInfo;
    @ApiModelProperty(value="\u6700\u5927\u540c\u65f6\u8fd0\u884c\u4efb\u52a1\u6570\uff0c\u9ed8\u8ba41")
    private Integer maxInstanceNum;
    @ApiModelProperty(value="\u5e76\u53d1\u5ea6\uff0c\u540c\u65f6\u6267\u884c\u67d0\u4e2a\u4efb\u52a1\u7684\u6700\u5927\u7ebf\u7a0b\u6570\u91cf")
    private Integer concurrency;
    @ApiModelProperty(value="\u4efb\u52a1\u6574\u4f53\u8d85\u65f6\u65f6\u95f4")
    private Long instanceTimeLimit;
    @ApiModelProperty(value="\u5b9e\u4f8b\u91cd\u8bd5\u6b21\u6570")
    private Integer instanceRetryNum;
    @ApiModelProperty(value="\u4efb\u52a1\u91cd\u8bd5\u6b21\u6570")
    private Integer taskRetryNum;
    @ApiModelProperty(value="\u4efb\u52a1\u72b6\u6001")
    private boolean enable;
    @ApiModelProperty(value="\u4e0b\u6b21\u8c03\u5ea6\u65f6\u95f4")
    private LocalDateTime nextTriggerTime;
    @ApiModelProperty(value="\u6700\u4f4eCPU\u6838\u5fc3\u6570\u91cf\uff0c0\u4ee3\u8868\u4e0d\u9650")
    private double minCpuCores;
    @ApiModelProperty(value="\u6700\u4f4e\u5185\u5b58\u7a7a\u95f4\uff0c\u5355\u4f4d GB\uff0c0\u4ee3\u8868\u4e0d\u9650")
    private double minMemorySpace;
    @ApiModelProperty(value="\u6700\u4f4e\u78c1\u76d8\u7a7a\u95f4\uff0c\u5355\u4f4d GB\uff0c0\u4ee3\u8868\u4e0d\u9650")
    private double minDiskSpace;
    @ApiModelProperty(value="\u6307\u5b9a\u673a\u5668\u8fd0\u884c\uff0c\u7a7a\u4ee3\u8868\u4e0d\u9650\uff0c\u975e\u7a7a\u5219\u53ea\u4f1a\u4f7f\u7528\u5176\u4e2d\u7684\u673a\u5668\u8fd0\u884c\uff08\u591a\u503c\u9017\u53f7\u5206\u5272\uff09")
    private String designatedWorkers;
    @ApiModelProperty(value="\u6700\u5927\u673a\u5668\u6570\u91cf")
    private Integer maxWorkerCount;
    @ApiModelProperty(value="\u62a5\u8b66\u7528\u6237ID\u5217\u8868")
    private List<String> notifyUserIds;
    @ApiModelProperty(value="\u6269\u5c55\u53c2\u6570")
    private String extra;
    @ApiModelProperty(value="\u5206\u914d\u7b56\u7565")
    private String dispatchStrategy;
    @ApiModelProperty(value="\u751f\u547d\u5468\u671f")
    private String lifecycle;

    public static JobInfoVO from(JobInfoEntity jobInfoDO) {
        JobInfoVO jobInfoVO = new JobInfoVO();
        BeanUtils.copyProperties((Object)jobInfoDO, (Object)jobInfoVO);
        TimeExpressionType timeExpressionType = TimeExpressionType.of((int)jobInfoDO.getTimeExpressionType());
        ExecuteType executeType = ExecuteType.of((int)jobInfoDO.getExecuteType());
        ProcessorType processorType = ProcessorType.of((int)jobInfoDO.getProcessorType());
        DispatchStrategy dispatchStrategy = DispatchStrategy.of((Integer)jobInfoDO.getDispatchStrategy());
        jobInfoVO.setTimeExpressionType(timeExpressionType.name());
        jobInfoVO.setExecuteType(executeType.name());
        jobInfoVO.setProcessorType(processorType.name());
        jobInfoVO.setEnable(jobInfoDO.getStatus().intValue() == SwitchableStatus.ENABLE.getV());
        jobInfoVO.setDispatchStrategy(dispatchStrategy.name());
        if (!StringUtils.isEmpty((Object)jobInfoDO.getNotifyUserIds())) {
            jobInfoVO.setNotifyUserIds(SJ.COMMA_SPLITTER.splitToList((CharSequence)jobInfoDO.getNotifyUserIds()));
        } else {
            jobInfoVO.setNotifyUserIds(Lists.newLinkedList());
        }
        return jobInfoVO;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobDescription() {
        return this.jobDescription;
    }

    public void setJobDescription(String jobDescription) {
        this.jobDescription = jobDescription;
    }

    public Long getAppId() {
        return this.appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getJobParams() {
        return this.jobParams;
    }

    public void setJobParams(String jobParams) {
        this.jobParams = jobParams;
    }

    public String getTimeExpressionType() {
        return this.timeExpressionType;
    }

    public void setTimeExpressionType(String timeExpressionType) {
        this.timeExpressionType = timeExpressionType;
    }

    public String getTimeExpression() {
        return this.timeExpression;
    }

    public void setTimeExpression(String timeExpression) {
        this.timeExpression = timeExpression;
    }

    public String getExecuteType() {
        return this.executeType;
    }

    public void setExecuteType(String executeType) {
        this.executeType = executeType;
    }

    public String getProcessorType() {
        return this.processorType;
    }

    public void setProcessorType(String processorType) {
        this.processorType = processorType;
    }

    public String getProcessorInfo() {
        return this.processorInfo;
    }

    public void setProcessorInfo(String processorInfo) {
        this.processorInfo = processorInfo;
    }

    public Integer getMaxInstanceNum() {
        return this.maxInstanceNum;
    }

    public void setMaxInstanceNum(Integer maxInstanceNum) {
        this.maxInstanceNum = maxInstanceNum;
    }

    public Integer getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(Integer concurrency) {
        this.concurrency = concurrency;
    }

    public Long getInstanceTimeLimit() {
        return this.instanceTimeLimit;
    }

    public void setInstanceTimeLimit(Long instanceTimeLimit) {
        this.instanceTimeLimit = instanceTimeLimit;
    }

    public Integer getInstanceRetryNum() {
        return this.instanceRetryNum;
    }

    public void setInstanceRetryNum(Integer instanceRetryNum) {
        this.instanceRetryNum = instanceRetryNum;
    }

    public Integer getTaskRetryNum() {
        return this.taskRetryNum;
    }

    public void setTaskRetryNum(Integer taskRetryNum) {
        this.taskRetryNum = taskRetryNum;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public LocalDateTime getNextTriggerTime() {
        return this.nextTriggerTime;
    }

    public void setNextTriggerTime(LocalDateTime nextTriggerTime) {
        this.nextTriggerTime = nextTriggerTime;
    }

    public double getMinCpuCores() {
        return this.minCpuCores;
    }

    public void setMinCpuCores(double minCpuCores) {
        this.minCpuCores = minCpuCores;
    }

    public double getMinMemorySpace() {
        return this.minMemorySpace;
    }

    public void setMinMemorySpace(double minMemorySpace) {
        this.minMemorySpace = minMemorySpace;
    }

    public double getMinDiskSpace() {
        return this.minDiskSpace;
    }

    public void setMinDiskSpace(double minDiskSpace) {
        this.minDiskSpace = minDiskSpace;
    }

    public String getDesignatedWorkers() {
        return this.designatedWorkers;
    }

    public void setDesignatedWorkers(String designatedWorkers) {
        this.designatedWorkers = designatedWorkers;
    }

    public Integer getMaxWorkerCount() {
        return this.maxWorkerCount;
    }

    public void setMaxWorkerCount(Integer maxWorkerCount) {
        this.maxWorkerCount = maxWorkerCount;
    }

    public List<String> getNotifyUserIds() {
        return this.notifyUserIds;
    }

    public void setNotifyUserIds(List<String> notifyUserIds) {
        this.notifyUserIds = notifyUserIds;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public String getDispatchStrategy() {
        return this.dispatchStrategy;
    }

    public void setDispatchStrategy(String dispatchStrategy) {
        this.dispatchStrategy = dispatchStrategy;
    }

    public String getLifecycle() {
        return this.lifecycle;
    }

    public void setLifecycle(String lifecycle) {
        this.lifecycle = lifecycle;
    }
}

