/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.web.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.job.dispatch.common.utils.OmsFileUtils;
import com.jxdinfo.hussar.support.job.dispatch.core.instance.InstanceLogService;
import com.jxdinfo.hussar.support.job.dispatch.core.instance.InstanceService;
import com.jxdinfo.hussar.support.job.dispatch.core.service.CacheService;
import com.jxdinfo.hussar.support.job.dispatch.dao.StringPage;
import com.jxdinfo.hussar.support.job.dispatch.dao.model.InstanceInfoModel;
import com.jxdinfo.hussar.support.job.dispatch.dao.service.JobInstanceInfoService;
import com.jxdinfo.hussar.support.job.dispatch.web.response.InstanceDetailVO;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/instance"})
@AuditLog(moduleName="\u4efb\u52a1\u5b9e\u4f8b")
@Api(value="instance", tags={"\u4efb\u52a1\u5b9e\u4f8b\u7ba1\u7406"})
public class InstanceController {
    @Resource
    private InstanceService instanceService;
    @Resource
    private InstanceLogService instanceLogService;
    @Resource
    private CacheService cacheService;
    @Resource
    private JobInstanceInfoService jobInstanceInfoService;

    @GetMapping(value={"/stop"})
    @AuditLog(eventDesc="\u624b\u52a8\u505c\u6b62\u4efb\u52a1\u5b9e\u4f8b", evnetType=AuditEventType.UPDATE, eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE)
    @ApiOperation(value="\u505c\u6b62\u4efb\u52a1\u5b9e\u4f8b", notes="\u505c\u6b62\u4efb\u52a1\u5b9e\u4f8b")
    public ApiResponse stopInstance(@ApiParam(value="\u5e94\u7528id") Long appId, @ApiParam(value="\u5b9e\u4f8bid") Long instanceId) {
        this.instanceService.stopInstance(appId, instanceId);
        return ApiResponse.success();
    }

    @GetMapping(value={"/retry"})
    @AuditLog(eventDesc="\u91cd\u8bd5\u4efb\u52a1\u5b9e\u4f8b", evnetType=AuditEventType.UPDATE, eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE)
    @ApiOperation(value="\u91cd\u8bd5\u4efb\u52a1\u5b9e\u4f8b", notes="\u91cd\u8bd5\u4efb\u52a1\u5b9e\u4f8b")
    public ApiResponse retryInstance(@ApiParam(value="\u5e94\u7528id") String appId, @ApiParam(value="\u5b9e\u4f8bid") Long instanceId) {
        this.instanceService.retryInstance(Long.valueOf(appId), instanceId);
        return ApiResponse.success();
    }

    @GetMapping(value={"/detail"})
    @AuditLog(eventDesc="\u67e5\u8be2\u4efb\u52a1\u5b9e\u4f8b\u8be6\u60c5", evnetType=AuditEventType.QUERY, eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE)
    @ApiOperation(value="\u67e5\u8be2\u4efb\u52a1\u5b9e\u4f8b\u8be6\u60c5", notes="\u67e5\u8be2\u4efb\u52a1\u5b9e\u4f8b\u8be6\u60c5")
    public ApiResponse<InstanceDetailVO> getInstanceDetail(@ApiParam(value="\u5b9e\u4f8bid") Long instanceId) {
        return ApiResponse.success((Object)InstanceDetailVO.from(this.instanceService.getInstanceDetail(instanceId)));
    }

    @GetMapping(value={"/log"})
    @ApiOperation(value="\u67e5\u8be2\u5b9e\u4f8b\u8fd0\u884c\u65e5\u5fd7", notes="\u67e5\u8be2\u5b9e\u4f8b\u8fd0\u884c\u65e5\u5fd7")
    public ApiResponse<StringPage> getInstanceLog(@ApiParam(value="\u5e94\u7528id") Long appId, @ApiParam(value="\u5b9e\u4f8bid") Long instanceId, @ApiParam(value="\u9875\u7801") Long index) {
        return ApiResponse.success((Object)this.instanceLogService.fetchInstanceLog(appId, instanceId, index));
    }

    @GetMapping(value={"/downloadLogUrl"})
    @ApiOperation(value="\u83b7\u53d6\u5b9e\u4f8b\u8fd0\u884c\u65e5\u5fd7\u4e0b\u8f7d\u5730\u5740", notes="\u83b7\u53d6\u5b9e\u4f8b\u8fd0\u884c\u65e5\u5fd7\u4e0b\u8f7d\u5730\u5740")
    public ApiResponse<String> getDownloadUrl(@ApiParam(value="\u5e94\u7528id") Long appId, @ApiParam(value="\u5b9e\u4f8bid") Long instanceId) {
        return ApiResponse.success((String)this.instanceLogService.fetchDownloadUrl(appId, instanceId));
    }

    @GetMapping(value={"/downloadLog"})
    @ApiOperation(value="\u4e0b\u8f7d\u5b9e\u4f8b\u8fd0\u884c\u65e5\u5fd7\u6587\u4ef6", notes="\u4e0b\u8f7d\u5b9e\u4f8b\u8fd0\u884c\u65e5\u5fd7\u6587\u4ef6")
    public void downloadLogFile(@ApiParam(value="\u5b9e\u4f8bid") Long instanceId, HttpServletResponse response) throws Exception {
        File file = this.instanceLogService.downloadInstanceLog(instanceId.longValue());
        OmsFileUtils.file2HttpResponse((File)file, (HttpServletResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/downloadLog4Console"})
    @ApiOperation(value="\u4e0b\u8f7d\u5b9e\u4f8b\u8fd0\u884c\u65e5\u5fd7\u5c55\u793a\u7f51\u9875", notes="\u4e0b\u8f7d\u5b9e\u4f8b\u8fd0\u884c\u65e5\u5fd7\u5c55\u793a\u7f51\u9875")
    public void downloadLog4Console(@ApiParam(value="\u5e94\u7528id") Long appId, @ApiParam(value="\u5b9e\u4f8bid") Long instanceId, HttpServletResponse response) {
        String downloadUrl = this.instanceLogService.fetchDownloadUrl(appId, instanceId);
        String logFilePath = OmsFileUtils.genTemporaryWorkPath() + String.format("HussarJob-%s-%s.log", appId, instanceId);
        File logFile = new File(logFilePath);
        try {
            FileUtils.copyURLToFile((URL)new URL(downloadUrl), (File)logFile);
            OmsFileUtils.file2HttpResponse((File)logFile, (HttpServletResponse)response);
        }
        catch (IOException e) {
        }
        finally {
            try {
                FileUtils.forceDelete((File)logFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @GetMapping(value={"/list"})
    @AuditLog(eventDesc="\u67e5\u8be2\u4efb\u52a1\u5b9e\u4f8b\u5217\u8868", evnetType=AuditEventType.QUERY, eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE)
    @ApiOperation(value="\u67e5\u8be2\u4efb\u52a1\u5b9e\u4f8b\u5217\u8868", notes="\u67e5\u8be2\u4efb\u52a1\u5b9e\u4f8b\u5217\u8868")
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<Page<InstanceInfoModel>> list(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page<InstanceInfoModel> page, @ApiParam(value="\u5f85\u67e5\u8be2\u4efb\u52a1\u5b9e\u4f8b\u4fe1\u606f") InstanceInfoModel model) {
        if (HussarUtils.isEmpty((Object)model.getTenantCode())) {
            UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
            String tenantCode = "0";
            if (HussarUtils.isNotEmpty((Object)userDetails) && HussarUtils.isNotEmpty((Object)userDetails.getTenantCode())) {
                tenantCode = userDetails.getTenantCode();
            }
            model.setTenantCode(tenantCode);
        }
        return ApiResponse.success((Object)this.jobInstanceInfoService.getPage(page, model));
    }
}

