/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.remote.transport.impl;

import com.jxdinfo.hussar.support.job.core.JobSerializable;
import com.jxdinfo.hussar.support.job.core.enums.Protocol;
import com.jxdinfo.hussar.support.job.core.exception.SingleModelException;
import com.jxdinfo.hussar.support.job.core.request.ServerQueryInstanceStatusReq;
import com.jxdinfo.hussar.support.job.core.request.ServerScheduleJobReq;
import com.jxdinfo.hussar.support.job.core.request.ServerStopInstanceReq;
import com.jxdinfo.hussar.support.job.core.response.AskResponse;
import com.jxdinfo.hussar.support.job.core.service.ExecutionReceiveReqService;
import com.jxdinfo.hussar.support.job.core.utils.NetUtils;
import com.jxdinfo.hussar.support.job.dispatch.remote.transport.Transporter;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="hussar.job", name={"enable-single-model"}, havingValue="true")
public class SingleModelTransporter
implements Transporter {
    protected final Log logger = LogFactory.getLog(SingleModelTransporter.class);
    @Resource
    private ExecutionReceiveReqService executionReceiveReqService;
    @Value(value="${server.port}")
    private int port;

    @Override
    public Protocol getProtocol() {
        return Protocol.SINGLE_INSTANCE;
    }

    @Override
    public String getAddress() {
        return NetUtils.getLocalHost() + ":" + this.port;
    }

    @Override
    public void tell(String address, JobSerializable object) {
        if (object instanceof ServerScheduleJobReq) {
            this.executionReceiveReqService.onReceiveServerScheduleJobReq((ServerScheduleJobReq)object);
        } else if (object instanceof ServerStopInstanceReq) {
            this.executionReceiveReqService.onReceiveServerStopInstanceReq((ServerStopInstanceReq)object);
        } else {
            throw new SingleModelException("Dispatch request failed. No suitable handler method found in Execution, req = " + object.getClass());
        }
    }

    @Override
    public AskResponse ask(String address, JobSerializable object) throws Exception {
        if (object instanceof ServerQueryInstanceStatusReq) {
            return this.executionReceiveReqService.onReceiveServerQueryInstanceStatusReq((ServerQueryInstanceStatusReq)object);
        }
        return new AskResponse(false, new byte[0], "Dispatch request failed. No suitable handler method found in Execution, req = " + object.getClass());
    }
}

