/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.remote.transport.starter;

import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import akka.actor.Props;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.core.utils.NetUtils;
import com.jxdinfo.hussar.support.job.dispatch.remote.config.JobDispatchProperties;
import com.jxdinfo.hussar.support.job.dispatch.remote.server.FriendRequestHandler;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class AkkaStarter {
    private static final Logger log = LoggerFactory.getLogger(AkkaStarter.class);
    public static ActorSystem actorSystem;
    private static String actorSystemAddress;
    private static final String AKKA_PATH = "akka://%s@%s/user/%s";

    public static void init(Environment environment, JobDispatchProperties jobDispatchProperties) {
        String portFromJVM;
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.info("[hussarjob] HussarJob's akka system start to bootstrap...");
        Integer port = jobDispatchProperties.getAkkaPort();
        if (HussarUtils.isEmpty((Object)port)) {
            Integer serverPort = HussarUtils.isEmpty((Object)environment.getProperty("server.port")) ? Integer.valueOf(10086) : (Integer)environment.getProperty("server.port", Integer.class);
            port = serverPort + 2333;
        }
        if (StringUtils.isNotEmpty((CharSequence)(portFromJVM = System.getProperty("hussar.job.dispatch.akka-port")))) {
            log.info("[HussarJob] use port from jvm params: {}", (Object)portFromJVM);
            port = Integer.parseInt(portFromJVM);
        }
        HashMap overrideConfig = Maps.newHashMap();
        String localIP = HussarUtils.isNotEmpty((Object)jobDispatchProperties.getAkkaIp()) ? jobDispatchProperties.getAkkaIp() : NetUtils.getLocalHost();
        overrideConfig.put("akka.remote.artery.canonical.hostname", localIP);
        overrideConfig.put("akka.remote.artery.canonical.port", port);
        actorSystemAddress = localIP + ":" + port;
        log.info("[HussarJob] akka-remote server address: {}", (Object)actorSystemAddress);
        Config akkaBasicConfig = ConfigFactory.load((String)"job-server.akka.conf");
        Config akkaFinalConfig = ConfigFactory.parseMap((Map)overrideConfig).withFallback((ConfigMergeable)akkaBasicConfig);
        actorSystem = ActorSystem.create((String)"oms-server", (Config)akkaFinalConfig);
        actorSystem.actorOf(Props.create(FriendRequestHandler.class, (Object[])new Object[0]), "friend_actor");
        log.info("[HussarJob] HussarJob's akka system started successfully, using time {}.", (Object)stopwatch);
    }

    public static ActorSelection getFriendActor(String address) {
        String path = String.format(AKKA_PATH, "oms-server", address, "friend_actor");
        return actorSystem.actorSelection(path);
    }

    public static ActorSelection getWorkerActor(String address) {
        String path = String.format(AKKA_PATH, "oms", address, "worker");
        return actorSystem.actorSelection(path);
    }

    public static ActorSystem getActorSystem() {
        return actorSystem;
    }

    public static String getActorSystemAddress() {
        return actorSystemAddress;
    }

    public static String getAkkaPath() {
        return AKKA_PATH;
    }
}

